/*
 * Copyright(c) 1995,1996 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: imap_conf.c,v 2.2 1997/11/17 16:12:12 gena Exp $
 */

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include "configform.h"

extern FD_POPacc    *pacc_obj;
static FD_config_imap *imap_obj;
static int ready = 0;

void IMAP_Host_Call(FL_OBJECT *obj, long param)
{
}

void IMAP_Port_Call(FL_OBJECT *obj, long param)
{
}

void IMAP_User_Call(FL_OBJECT *obj, long param)
{
}

void IMAP_Pwd_Call(FL_OBJECT *obj, long param)
{
}

void IMAP_Use_Trash_Call(FL_OBJECT *obj, long param)
{
}

void IMAP_Store_Pwd_Call(FL_OBJECT *obj, long param)
{
if (fl_get_button(imap_obj->IMAP_Store_Pwd)) {
        fl_show_alert("WARNING", "This is very unsecure option", "make sure your config file (.xfmailrc) is not readable by anyone else", 1);
        b_setcfg_flags("imapwd", 0); }

}

void IMAP_Extra_Call(FL_OBJECT *obj, long param)
{
}

void IMAP_Autocon_Call(FL_OBJECT *obj, long param)
{
}

void
imap_conf(int set_default, FD_config_imap *form) 
{
 imap_obj = form;

 fl_set_input(imap_obj->IMAP_Host, b_getcfg_str_default(conf_name, "imaphost", "127.0.0.1", set_default));
 fl_set_input(imap_obj->IMAP_Port, b_getcfg_str_default(conf_name, "imaport", "143", set_default));
 fl_set_input(imap_obj->IMAP_User, b_getcfg_str_default(conf_name, "imapuser", user_n, set_default));
 fl_set_input(imap_obj->IMAP_Pwd, b_getcfg_str_default(conf_name, "imapwd", "", set_default));
 fl_set_input(imap_obj->IMAP_Extra, b_getcfg_str_default(conf_name, "imapextra", "\"\"", set_default));

 fl_set_button(imap_obj->IMAP_Store_Pwd, b_getcfg_int_default(conf_name, "imapstorpwd", 0, set_default));
 fl_set_button(imap_obj->IMAP_Autocon, b_getcfg_int_default(conf_name, "imapautocon", 0, set_default));
 fl_set_button(imap_obj->IMAP_Use_Trash, b_getcfg_int_default(conf_name, "imapusetrash", 0, set_default));
 fl_set_button(imap_obj->IMAP_Cache, b_getcfg_int_default(conf_name, "imapcache", 0, set_default));
 fl_set_button(imap_obj->IMAP_NExpunge, b_getcfg_int_default(conf_name, "imapnexpunge", 0, set_default));
 fl_set_button(imap_obj->IMAP_Log, (logging & LOG_IMAP) ? 1 : 0);     
}

void
handle_imap_input(FD_config_imap *form)
{
 imap_obj = form;
 
 b_putcfg_str(conf_name, "imaphost", (char *)fl_get_input(imap_obj->IMAP_Host));
 b_putcfg_str(conf_name, "imaport", (char *)fl_get_input(imap_obj->IMAP_Port));
 b_putcfg_str(conf_name, "imapuser", (char *)fl_get_input(imap_obj->IMAP_User));
 b_putcfg_str(conf_name, "imapwd", (char *)fl_get_input(imap_obj->IMAP_Pwd));
 b_putcfg_str(conf_name, "imapextra", (char *)fl_get_input(imap_obj->IMAP_Extra));
 if (fl_get_button(imap_obj->IMAP_Store_Pwd))
	b_setcfg_flags("imapwd", CF_UNSECURE);
 else
	b_setcfg_flags("imapwd", DONT_STORE|CF_UNSECURE);

 b_putcfg_int(conf_name, "imapstorpwd", fl_get_button(imap_obj->IMAP_Store_Pwd));
 b_putcfg_int(conf_name, "imapautocon", fl_get_button(imap_obj->IMAP_Autocon));
 b_putcfg_int(conf_name, "imapusetrash", fl_get_button(imap_obj->IMAP_Use_Trash));
 b_putcfg_int(conf_name, "imapcache", fl_get_button(imap_obj->IMAP_Cache));
 b_putcfg_int(conf_name, "imapnexpunge", fl_get_button(imap_obj->IMAP_NExpunge));
 if (fl_get_button(imap_obj->IMAP_Log))
	logging |= LOG_IMAP;
 else
	logging &= ~LOG_IMAP;

 return;         
}

void
imap_account()
{

 if (ready)
        return;

 ready = 1;

 fl_set_input(pacc_obj->P_Username, b_getcfg_str(conf_name, "imapuser", ""));
 fl_set_input(pacc_obj->P_Password, b_getcfg_str(conf_name, "imapwd", ""));
 fl_set_object_label(pacc_obj->P_Server, b_getcfg_str(conf_name, "imaphost", "127.0.0.1"));
 fl_set_object_label(pacc_obj->P_Title, "IMAP Account on");

 fl_set_object_focus(pacc_obj->POPacc, pacc_obj->P_Password);

 fl_show_form(pacc_obj->POPacc, FL_PLACE_CENTER, FL_TRANSIENT, "IMAP account");

 fl_do_only_forms();

 b_putcfg_str(conf_name,"imapuser",(char *)fl_get_input(pacc_obj->P_Username));
 b_putcfg_str(conf_name,"imapwd",(char *)fl_get_input(pacc_obj->P_Password));

 fl_hide_form(pacc_obj->POPacc);

 ready = 0;
 return;
}

