/*
 * Copyright(c) 1995,1996 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: mime_conf.c,v 2.0 1997/09/23 15:55:10 gena Exp $
 */

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#define ATT_XPM
#include "pixmaps.h"

static FD_Attach *att_obj;
static FD_config_mime *mime_obj;
static int ready = 0;
void display_mailcap();

void
Att_Type_Call(obj, param)
FL_OBJECT *obj;
long param;
{
}

void
Att_Subtype_Call(obj, param)
FL_OBJECT *obj;
long param;
{
}

void
set_encode(encode)
u_int encode;
{
 fl_set_button(att_obj->Att_8bit, 0);
 fl_set_button(att_obj->Att_7bit, 0);
 fl_set_button(att_obj->Att_Base64, 0);
 fl_set_button(att_obj->Att_qprt, 0);

 switch(encode) {
   case CE_NONE:
	fl_set_button(att_obj->Att_8bit, 1);
   break;

   case CE_7BIT:
	fl_set_button(att_obj->Att_7bit, 1);
   break;

   case CE_BASE64:
	fl_set_button(att_obj->Att_Base64, 1);
   break;

   case CE_QPRT:
	fl_set_button(att_obj->Att_qprt, 1);
   break;

   default:
	fl_set_button(att_obj->Att_Base64, 1);
   break;
		}
}

u_int
get_encode()
{
  if (fl_get_button(att_obj->Att_8bit))
	return CE_NONE;
  else
  if (fl_get_button(att_obj->Att_7bit))
	return CE_7BIT;
  else
  if (fl_get_button(att_obj->Att_Base64))
	return CE_BASE64;
  else
  if (fl_get_button(att_obj->Att_qprt))
	return CE_QPRT;
  else
	return CE_BASE64;
}

void
Att_Type_Choose_Call(obj, param)
FL_OBJECT *obj;
long param;
{
char *type;
int i, enc;

  if (obj == NULL)
	type = (char *)fl_get_input(att_obj->Att_Type);
  else {
	type = (char *)fl_get_menu_text(obj);
	fl_set_input(att_obj->Att_Type, type);
       }
  fl_set_input(att_obj->Att_Subtype, "");
  fl_clear_menu(att_obj->Att_Subtype_Choose);

  i = 0;
  enc = CE_BASE64;
  while (mailcap[i].type_code != CTYPE_UNSUPPORTED) {
    if (mailcap[i].subtype_code == CSUBTYPE_DEFAULT) {
	i++;
	continue; }

    if (!strcmp(type, mailcap[i].type_text)) {
       if (strlen(fl_get_input(att_obj->Att_Subtype)) < 1) {
	  fl_set_input(att_obj->Att_Subtype, mailcap[i].subtype_text);
          enc = mailcap[i].encode;
							   }
       fl_addto_menu(att_obj->Att_Subtype_Choose, mailcap[i].subtype_text);
					     }
    i++;
						    }

  set_encode(enc);

  return; 
}

void
Att_Subtype_Choose_Call(obj, param)
FL_OBJECT *obj;
long param;
{
struct _mime_mailcap *mcap;
char *subtype, *type;

  subtype = (char *)fl_get_menu_text(obj);
  fl_set_input(att_obj->Att_Subtype, subtype);

  type = (char *)fl_get_input(att_obj->Att_Type);
  if ((mcap = find_mailcap(type, subtype, 1)) == NULL)
	return;

  set_encode(mcap->encode);

  if (mcap->type_code == CTYPE_UNSUPPORTED) {
     if (mcap->ext_mcap)
        free(mcap->ext_mcap);
     free(mcap);
					    }

  return;
}

void
Att_File_Call(obj, param)
FL_OBJECT *obj;
long param;
{
}

void
Att_Descr_Call(obj, param)
FL_OBJECT *obj;
long param;
{
}

void
Att_File_Choose_Call(obj, param)
FL_OBJECT *obj;
long param;
{
char *attach;
char *ext;
int i;

   fl_set_fselector_title("Choose file to attach");
   attach = (char *)fl_show_fselector("Attach", "", "*", "");
   if (attach)
	fl_set_input(att_obj->Att_File, attach);
   else
	return;

   if ((ext = strrchr(attach, '/')) != NULL)
	ext++;
   else
	ext = attach;

   fl_set_input(att_obj->Att_Descr, ext);

   i = 0;
   if ((ext = strrchr(ext, '.')) != NULL) {
	ext++;
	if (strlen(ext) <= 4) {
	 while (mailcap[i].type_code != CTYPE_UNSUPPORTED) {
	    if (!strcasecmp(ext, mailcap[i].ext))   {
		fl_set_input(att_obj->Att_Type, mailcap[i].type_text);
		Att_Type_Choose_Call(NULL, 0);
		fl_set_input(att_obj->Att_Subtype, mailcap[i].subtype_text);
		i = -1;
		break;				}
	 i++;
							   }

			      }
					     }

  if (i != -1)  {
	i = 0;
	while (mailcap[i].type_code != CTYPE_UNSUPPORTED)  {
	if ((mailcap[i].type_code == CTYPE_APPLICATION) &&
	  (mailcap[i].subtype_code == CSUBTYPE_OSTREAM) ) {
	        fl_set_input(att_obj->Att_Type, mailcap[i].type_text);
		Att_Type_Choose_Call(NULL, 0);
		break;					  }
	i++;
							   }
		}

}

void
Att_8bit_Call(obj, param)
FL_OBJECT *obj;
long param;
{
}

void
Att_7bit_Call(obj, param)
FL_OBJECT *obj;
long param;
{
}

void
Att_Base64_Call(obj, param)
FL_OBJECT *obj;
long param;
{
}

void
Att_qprt_Call(obj, param)
FL_OBJECT *obj;
long param;
{
}


struct _mime_msg *
compose_attachment(omime)
struct _mime_msg *omime;
{
int i, type_num;
int enc, mtype, msubtype;
struct _mime_msg *mime;
struct _mime_mailcap *mcap;
char *mfile, *mdescr;
char *name;
char buf[255], buf1[127];
struct stat sb;
u_int size;

if (ready) {
        XRaiseWindow(fl_display, att_obj->Attach->window);
        display_msg(MSG_WARN, "Attach", "Dialog is currently in use, close it and open again");
        return NULL; }

if (omime) {
 if (omime->mailcap->type_code == CTYPE_MULTIPART) 	{
	display_msg(MSG_WARN,"Attach","Multipart attachment can not be edited");
	return NULL;					}

 if (omime->mailcap->type_code == CTYPE_EXTERNAL) 	{
	display_msg(MSG_WARN, "Attach","External attachment can not be edited");
	return NULL;					}

 mtype = (omime->mailcap->type_code == CTYPE_UNSUPPORTED) ? CTYPE_APPLICATION : omime->mailcap->type_code;
 msubtype = (omime->mailcap->subtype_code == CSUBTYPE_UNSUPPORTED) ? CSUBTYPE_OSTREAM : omime->mailcap->subtype_code;
	   }
else	{
 mtype = CTYPE_APPLICATION;
 msubtype = CSUBTYPE_OSTREAM;
	}

ready = 1;

att_obj = create_form_Attach();

fl_deactivate_object(att_obj->Att_Type);
fl_set_pixmapbutton_data(att_obj->Att_File_Choose, save_xpm);
att_obj->Att_File_Choose->u_vdata = "Select file to attach";
fl_set_object_posthandler(att_obj->Att_File_Choose, post_handler);
fl_set_object_resize(att_obj->Att_File_Choose,FL_RESIZE_NONE);
fl_set_object_gravity(att_obj->Att_File_Choose,NorthWestGravity,0);

fl_clear_menu(att_obj->Att_Type_Choose);

i = 0;
type_num = 0;
while (mailcap[i].type_code != CTYPE_UNSUPPORTED) {
  if (mailcap[i].type_code == CTYPE_MULTIPART) {
	i++;
	continue; }

  if (mailcap[i].type_code == CTYPE_EXTERNAL) {
	i++;
	continue; }

  if (mailcap[i].type_code > type_num) {
	if ((mailcap[i].type_code == mtype) &&
	  (mailcap[i].subtype_code == msubtype) )
		fl_set_input(att_obj->Att_Type, mailcap[i].type_text);

	fl_addto_menu(att_obj->Att_Type_Choose, mailcap[i].type_text);
	type_num = mailcap[i].type_code;
					}

  i++;
				}

Att_Type_Choose_Call(NULL, 0);
if (omime) {
 set_encode(omime->encoding->c_trans_enc);
 name = get_mime_fname(omime);
 if (name)
	fl_set_input(att_obj->Att_File, name);

 if (omime->c_descr)
	fl_set_input(att_obj->Att_Descr, omime->c_descr);
 fl_deactivate_object(att_obj->Att_File_Choose);
 fl_deactivate_object(att_obj->Att_7bit);
 fl_deactivate_object(att_obj->Att_8bit);
 fl_deactivate_object(att_obj->Att_Base64);
 fl_deactivate_object(att_obj->Att_qprt);
	   }
else
 set_encode(CE_BASE64);

again: fl_show_form(att_obj->Attach, FL_PLACE_CENTER, FL_TRANSIENT, omime ? "Edit attachment" : "New attachment");

 mime = NULL;

 if (fl_do_only_forms() == att_obj->Att_Cancel)
        goto end;

 if (omime) {
	mime = omime;
	enc = mime->encoding->c_trans_enc;
	    }
 else	{
 enc = get_encode();
 if ((mime = create_mime()) == NULL) {
	display_msg(MSG_WARN, "MIME", "Can not create new attachment");
	goto end; }
	}

 if ((mcap = find_mailcap((char *)fl_get_input(att_obj->Att_Type), (char *)fl_get_input(att_obj->Att_Subtype), 1)) == NULL) {
	display_msg(MSG_WARN, "MIME", "Unknown MIME type");
	if (!omime)
		discard_mime(mime);
	mime = NULL;
	goto end; }

 mime->mailcap = mcap;
 mime->encoding = &supp_encodings[enc];

/*
 if (enc != mcap->encode) {
	if (!display_msg(MSG_QUEST||MSG_DEFNO, "This type of encoding is not recommended for", "%s/%s, continue?", mcap->type_text, mcap->subtype_text)) {
	if (!omime)
		discard_mime(mime);
	mime = NULL;
	goto again; }
			}
*/

 mfile = (char *)fl_get_input(att_obj->Att_File);
 if (!omime && (strlen(mfile) < 1)) {
	display_msg(MSG_WARN, "MIME", "Must specify filename");
	if (!omime)
		discard_mime(mime);
	mime = NULL;
	goto again; }

 if (omime == NULL) {
  if (stat(mfile, &sb) == -1) 	{
	display_msg(MSG_WARN, "MIME", "Can not access %s", mfile);
	discard_mime(mime);
	mime = NULL;
	goto again; 		}

  size = (u_int)sb.st_size;
  mime->src_info = strdup(mfile);

  if ((name = strrchr(mfile, '/')) != NULL)
	name++;
  else
	name = mfile;
		   }
 else	{
  size = get_mime_fsize(mime);
  if (strlen(mfile) < 1) {
	name = NULL;
	size = 0;	 }
  else  {
   if ((name = strrchr(mfile, '/')) != NULL)
	name++;
   else
	name = mfile;
	}
	}

 mime->flags = ATTACHMENT;

 if (name) {
  sprintf(buf, "attachment; filename=\"%s\"", name);
	   }
 else
  sprintf(buf, "attachment");

 replace_mime_field(mime, MIME_C_DISP, buf);

 replace_mime_field(mime, MIME_C_ENCR, supp_encodings[enc].encoding_name);

 mdescr = (char *)fl_get_input(att_obj->Att_Descr);
 if ((strlen(mdescr) > 1) && (strlen(mdescr) < 64)) {
	if (mime->c_descr)
		free(mime->c_descr);
	mime->c_descr = strdup(mdescr);
	replace_mime_field(mime, MIME_C_DESCR, mime->c_descr); }

 if (size > 0)
	sprintf(buf1, "; SizeOnDisk=%d", size);
 else
	*buf = '\0';

 if (name) {
 if (mime->mailcap->type_code == CTYPE_TEXT)
	sprintf(buf, "%s/%s; charset=%s; name=%s%s", mime->mailcap->type_text, mime->mailcap->subtype_text, mime->charset->charset_name, name, buf1);
 else
	sprintf(buf, "%s/%s; name=%s%s", mime->mailcap->type_text, mime->mailcap->subtype_text, name, buf1);
	   }
 else	{
 if (mime->mailcap->type_code == CTYPE_TEXT)
	sprintf(buf, "%s/%s; charset=%s", mime->mailcap->type_text, mime->mailcap->subtype_text, mime->charset->charset_name);
 else
	sprintf(buf, "%s/%s", mime->mailcap->type_text, mime->mailcap->subtype_text);
	}

 replace_mime_field(mime, MIME_C_TYPE, buf);

end: fl_hide_form(att_obj->Attach);
 fl_free_form(att_obj->Attach);
 fl_free(att_obj);
 att_obj = NULL;

 ready = 0;
 return mime;
}

void
display_mailcap()
{
char buf[255];
char mtype[34];
char mview[128];
int i = 0;

  fl_freeze_form(mime_obj->config_mime);
  fl_clear_browser(mime_obj->MIME_Disp);
  while (mailcap[i].type_code != CTYPE_UNSUPPORTED) {

   sprintf(mtype, "%s/%s", mailcap[i].type_text, mailcap[i].subtype_text);
   strcpy(mview, "[none]");
   if (mailcap[i].process)
      strcpy(mview, "[internal]");
   else
   if (mailcap[i].ext_mcap)
      strncpy(mview, mailcap[i].ext_mcap, 96);
   else
   if (mailcap[i].view)
      strcpy(mview, "[internal]");

   mview[96] = '\0';

   if (mailcap[i].type_code == CTYPE_EXTERNAL)
	sprintf(buf, "@C4%-22.22s %-4.4s %s", mtype, mailcap[i].ext, mview);
   else
	sprintf(buf, "%-22.22s %-4.4s %s", mtype, mailcap[i].ext, mview);

   fl_add_browser_line(mime_obj->MIME_Disp, buf);
   i++;
						    }

  fl_select_browser_line(mime_obj->MIME_Disp, 1);
  MIME_Disp_Call(NULL, 1);
  fl_unfreeze_form(mime_obj->config_mime);
}

struct _mime_mailcap *
get_mcap_by_num(num)
int num;
{
int i;

  i = 0;
  while (mailcap[i].type_code != CTYPE_UNSUPPORTED) {
  i++;
  if (i == num)
	return &mailcap[i-1];
						    }

  return NULL;
}

void
MIME_Disp_Call(obj, param)
FL_OBJECT *obj;
long param;
{
int n;
struct _mime_mailcap *mcap;

   if (obj)
	n = fl_get_browser(obj);
   else
	n = param;

   if ((mcap = get_mcap_by_num(n)) == NULL)
	return;

   fl_set_input(mime_obj->MIME_Type, mcap->type_text);
   fl_set_input(mime_obj->MIME_Subtype, mcap->subtype_text);
   fl_set_input(mime_obj->MIME_Ext, mcap->ext);
   fl_set_input(mime_obj->MIME_Command, mcap->ext_mcap ? mcap->ext_mcap : "");
}

void
MIME_Type_Call(obj, param)
FL_OBJECT *obj;
long param;
{
}

void
MIME_Subtype_Call(obj, param)
FL_OBJECT *obj;
long param;
{
}

void
MIME_Ext_Call(obj, param)
FL_OBJECT *obj;
long param;
{
}

void
MIME_Command_Call(obj, param)
FL_OBJECT *obj;
long param;
{
}

void
MIME_Add_Call(obj, param)
FL_OBJECT *obj;
long param;
{
char *type, *subtype, *ext, *command;
struct _mime_mailcap *mcap;

 type = (char *)fl_get_input(mime_obj->MIME_Type);
 subtype = (char *)fl_get_input(mime_obj->MIME_Subtype);
 ext = (char *)fl_get_input(mime_obj->MIME_Ext);
 command = (char *)fl_get_input(mime_obj->MIME_Command);

 if ((strlen(type) < 1) || (strlen(type) > 16)) {
	display_msg(MSG_WARN, "MIME", "Invalid MIME type");
	return; }

 if ((strlen(subtype) < 1) || (strlen(subtype) > 16)) {
	display_msg(MSG_WARN, "MIME", "Invalid MIME subtype");
	return; }

 if (strlen(ext) > 4) {
	display_msg(MSG_WARN, "MIME", "Extension can not be longer then 4 characters");
	return; }

 if (strlen(command) < 1)
	command = NULL;

 if ((mcap = find_mailcap(type, subtype, 1)) == NULL)
	return;

 if (mcap->process)
	return;

 if (mcap->ext_mcap)
	free(mcap->ext_mcap);

 strcpy(mcap->ext, ext);

 if (command)
	mcap->ext_mcap = strdup(command);
 else
	mcap->ext_mcap = NULL;

 add_mailcap(mcap);
/*
 if (mcap->type_code == CTYPE_UNSUPPORTED) {
	free(mcap->ext_mcap);
	free(mcap); }
*/

 display_mailcap();
}

void
MIME_Delete_Call(obj, param)
FL_OBJECT *obj;
long param;
{
struct _mime_mailcap *mcap;
int n;

   n = fl_get_browser(mime_obj->MIME_Disp);

   if ((mcap = get_mcap_by_num(n)) == NULL)
	return;

   if (mcap->ext_mcap) {
	free(mcap->ext_mcap);
	mcap->ext_mcap = NULL;
			}

   if (mcap->type_code != CTYPE_EXTERNAL) {
	display_mailcap();
	return;
					  }

  n--;
  while (mailcap[n].type_code != CTYPE_UNSUPPORTED) {
	if (mailcap[n].ext_mcap)
		free(mailcap[n].ext_mcap);

	memcpy(&mailcap[n], &mailcap[n + 1], sizeof(struct _mime_mailcap));

	mailcap[n + 1].ext_mcap = NULL;
	
	n++;
						    }

  display_mailcap();
}

void
MIME_Save_Call(obj, param)
FL_OBJECT *obj;
long param;
{
save_mailcap();
}

void
mime_conf(FD_config_mime *form)
{
mime_obj = form;
fl_set_browser_fontstyle(mime_obj->MIME_Disp, FL_FIXED_STYLE);
fl_set_browser_fontsize(mime_obj->MIME_Disp, FL_NORMAL_SIZE);
 
display_mailcap();
}
