/*
 * Copyright(c) 1995,1996 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: misc.c,v 2.2 1997/11/27 16:26:31 gena Exp $
 */

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include "configform.h"

static FD_config_misc *misc_obj;
static FD_config_header *header_obj;

void Misc_Mail_Dir_Call(FL_OBJECT *obj, long param)
{
}

void Misc_Cache_Dir_Call(FL_OBJECT *obj, long param)
{
 fl_show_message("Warning!", "Please restart XFMail immediatly after you", "changed the location of cache directory");
}

void Misc_SIconized_Call(FL_OBJECT *obj, long param)
{
}

void Misc_Empty_Call(FL_OBJECT *obj, long param)
{
}

void Misc_From_Call(FL_OBJECT *obj, long param)
{
}

void
misc_conf(int set_default, FD_config_misc *form)
{
char buf[255];

 misc_obj = form;

 sprintf(buf, "%s/Mail", homedir);
 fl_set_input(misc_obj->Misc_Mail_Dir, b_getcfg_str_default(conf_name, "maildir", buf, set_default));
 fl_set_input(misc_obj->Misc_From, b_getcfg_str_default(conf_name, "from", "", set_default));
 fl_set_input(misc_obj->Misc_LPR, b_getcfg_str_default(conf_name, "print", get_print_command(NULL), set_default));
 fl_set_input(misc_obj->Misc_Printer, b_getcfg_str_default(conf_name, "printer", "lp", set_default));

 if (cfg_exist("cachedir"))
  fl_set_input(misc_obj->Misc_Cache_Dir, b_getcfg_str_default(conf_name, "cachedir", configdir, set_default));
 else
  fl_set_input(misc_obj->Misc_Cache_Dir, "");

 if (cfg_exist("organization"))
  fl_set_input(misc_obj->Misc_Org, b_getcfg_str_default(conf_name, "organization", "", set_default));
 else
  fl_set_input(misc_obj->Misc_Org, "");

 if (cfg_exist("replyto"))
  fl_set_input(misc_obj->Misc_RTO, b_getcfg_str_default(conf_name, "replyto", "", set_default));
 else
  fl_set_input(misc_obj->Misc_RTO, "");

 fl_set_input(misc_obj->Misc_Cache, b_getcfg_str_default(conf_name, "mincache", "512", set_default));

 fl_set_button(misc_obj->Misc_SIconized, b_getcfg_int_default(conf_name,"starticon",0, set_default));
 fl_set_button(misc_obj->Misc_Empty, b_getcfg_int_default(conf_name,"emptytrash",1, set_default));
 fl_set_button(misc_obj->Misc_SLog, b_getcfg_int_default(conf_name,"startlog",0, set_default));
 fl_set_button(misc_obj->Misc_TTips, b_getcfg_int_default(conf_name,"tooltips",1, set_default));
 fl_set_button(misc_obj->Misc_Placement, b_getcfg_int_default(conf_name,"wplace",1, set_default));
 fl_set_button(misc_obj->Misc_CExit, b_getcfg_int_default(conf_name,"cexit",0, set_default));
 fl_set_button(misc_obj->Misc_SetID, b_getcfg_int_default(conf_name,"setmsgid",1, set_default));
 fl_set_button(misc_obj->Misc_SetSender, b_getcfg_int_default(conf_name,"setsender",1, set_default));
 fl_set_button(misc_obj->Misc_Log, (logging & LOG_ERRORS) ? 1 : 0);
 fl_set_button(misc_obj->Misc_Lognet, (logging & LOG_NET) ? 1 : 0);
}

void
handle_misc_input(FD_config_misc *form)
{
struct _mail_addr *ma;
char *p;

 misc_obj = form;

 b_putcfg_str(conf_name, "from", (char *)fl_get_input(misc_obj->Misc_From));

 if (((ma = get_address(b_getcfg_str(conf_name, "from", ""), ADDR_GET_FIRST)) == NULL) ||
        ((p = strchr(ma->addr, '@')) == NULL) ||
        (strchr(p, '.') == NULL))
        display_msg(MSG_WARN, "Your E-Mail address (From field)", "is invalid, please fix it");
 
 if (ma)
        discard_address(ma);

 b_putcfg_str(conf_name, "print", (char *)fl_get_input(misc_obj->Misc_LPR));
 b_putcfg_str(conf_name, "printer", (char *)fl_get_input(misc_obj->Misc_Printer));
 if (strlen(fl_get_input(misc_obj->Misc_Org)) > 1)
   b_putcfg_str(conf_name, "organization", (char *)fl_get_input(misc_obj->Misc_Org));
 else
   b_delcfg_str(conf_name, "organization");

 if (strlen(fl_get_input(misc_obj->Misc_RTO)) > 1)
   b_putcfg_str(conf_name, "replyto", (char *)fl_get_input(misc_obj->Misc_RTO));
 else
   b_delcfg_str(conf_name, "replyto");

 b_putcfg_str(conf_name, "maildir", (char *)fl_get_input(misc_obj->Misc_Mail_Dir));
 b_putcfg_str(conf_name, "mincache", (char *)fl_get_input(misc_obj->Misc_Cache));
 if (strlen(fl_get_input(misc_obj->Misc_Cache_Dir)) > 1)
   b_putcfg_str(conf_name, "cachedir", (char *)fl_get_input(misc_obj->Misc_Cache_Dir));
 else
   b_delcfg_str(conf_name, "cachedir");

 b_putcfg_int(conf_name, "starticon", fl_get_button(misc_obj->Misc_SIconized));
 b_putcfg_int(conf_name, "emptytrash", fl_get_button(misc_obj->Misc_Empty));
 b_putcfg_int(conf_name, "startlog", fl_get_button(misc_obj->Misc_SLog));
 b_putcfg_int(conf_name, "tooltips", fl_get_button(misc_obj->Misc_TTips));
 b_putcfg_int(conf_name, "wplace", fl_get_button(misc_obj->Misc_Placement));
 b_putcfg_int(conf_name, "cexit", fl_get_button(misc_obj->Misc_CExit));
 b_putcfg_int(conf_name, "setmsgid", fl_get_button(misc_obj->Misc_SetID));
 b_putcfg_int(conf_name, "setsender", fl_get_button(misc_obj->Misc_SetSender));

 if (fl_get_button(misc_obj->Misc_Log))
        logging |= LOG_ERRORS;
 else
        logging &= ~LOG_ERRORS;

 if (fl_get_button(misc_obj->Misc_Lognet))
        logging |= LOG_NET;
 else
        logging &= ~LOG_NET;

 ttips = fl_get_button(misc_obj->Misc_TTips);

 return;         
}

void
display_header()
{
struct _head_field *hf;
char buf[255];
char *h = (char *)fl_get_browser_line(header_obj->Header_List,
	fl_get_browser(header_obj->Header_List));

 if (!h || !*h) {
	fl_set_input(header_obj->Header_Name, "");
	fl_set_input(header_obj->Header_Contents, "");
	return;	}

 strncpy(buf, h, sizeof(buf) - 1);
 buf[sizeof(buf) - 1] = '\0';
 if ((hf = get_field(buf)) == NULL) {
	fl_set_input(header_obj->Header_Name, "");
	fl_set_input(header_obj->Header_Contents, "");
	return;			    }

 fl_set_input(header_obj->Header_Name, hf->f_name);
 fl_set_input(header_obj->Header_Contents, hf->f_line);
 if (hf->f_line)
   free(hf->f_line);
 free(hf);

 return;
}

void
display_headers()
{
int i;
char hline[255];
struct _head_field *hf;

 fl_clear_browser(header_obj->Header_List);
 fl_freeze_form(header_obj->config_header);
 for (i = 1; i <= MAX_EXTRA_HEADERS; i++) 	{
  sprintf(hline, "ExtraHeader%d", i);
  if (cfg_exist(hline))		{
  strcpy(hline, b_getcfg_str(conf_name, hline, NULL));
  if ((hf = get_field(hline)) == NULL) {
	b_delcfg_str(conf_name, hline);
	continue;		       }
  if (strlen(hf->f_name) + strlen(hf->f_line) >= sizeof(hline))
	hf->f_line[sizeof(hline) - strlen(hf->f_name)] = '\0';
  sprintf(hline, "%s: %s", hf->f_name, hf->f_line);
  fl_addto_browser(header_obj->Header_List, hline);
  if (hf->f_line)
    free(hf->f_line);
  free(hf);

				}
					}
 fl_select_browser_line(header_obj->Header_List, 1);
 display_header();
 fl_unfreeze_form(header_obj->config_header);

 return;
}

void
store_headers()
{
int i;
char hline[32], buf[255], *h;
struct _head_field *hf;

 for (i = 1; i <= MAX_EXTRA_HEADERS; i++) 	{
  sprintf(hline, "ExtraHeader%d", i);
  if ((h = (char *)fl_get_browser_line(header_obj->Header_List, i))
	!= NULL)	{
   strncpy(buf, h, sizeof(buf) - 1);
   buf[sizeof(buf) - 1] = '\0';
   if ((hf = get_field(buf)) == NULL) {
	b_delcfg_str(conf_name, hline);
	continue;		      }
   if (strlen(hf->f_name) + strlen(hf->f_line) >= sizeof(buf))
	hf->f_line[sizeof(buf) - strlen(hf->f_name)] = '\0';
   sprintf(buf, "%s: %s", hf->f_name, hf->f_line);
   b_putcfg_str(conf_name, hline, buf);
   if (hf->f_line)
     free(hf->f_line);
   free(hf);
			}
  else
   b_delcfg_str(conf_name, hline);
					}

 return;
}

void Header_Call(FL_OBJECT *obj, long param)
{
}

void Header_List_Call(FL_OBJECT *obj, long param)
{
 display_header();
}

void Header_Add_Call(FL_OBJECT *obj, long param)
{
char buf[255], *h;
struct _head_field *hf;
int i;

 sprintf(buf, "%s: %s", fl_get_input(header_obj->Header_Name),
			fl_get_input(header_obj->Header_Contents));

 if (((hf = get_field(buf)) == NULL) ||
	(hf->f_line == NULL) || !*hf->f_line) 	{
  display_msg(MSG_WARN, "add", "Invalid header field");
  if (hf) {
   if (hf->f_line)
     free(hf->f_line);
   free(hf);
	  }
  return;					}

 if (is_spechdr(hf))	{
	if (hf->f_line)
		free(hf->f_line);
	free(hf);
	display_msg(MSG_WARN, "add", "\"%s\" can not be used", hf->f_name);
	return;		}


 if (hf->f_line)
   free(hf->f_line);
 free(hf);

 sprintf(buf, "%s: %s", fl_get_input(header_obj->Header_Name),
			fl_get_input(header_obj->Header_Contents));

 for (i = 1; i <= MAX_EXTRA_HEADERS; i++) 	{
  if ((h = (char *)fl_get_browser_line(header_obj->Header_List, i))
	== NULL)	{
   fl_addto_browser(header_obj->Header_List, buf);
   fl_select_browser_line(header_obj->Header_List,
	fl_get_browser_maxline(header_obj->Header_List));
   display_header();
   return;
			}
					}

 display_header();
 display_msg(MSG_WARN, "add", "Can not have more then %d extra header fields",
	MAX_EXTRA_HEADERS);
 return;
}

void Header_Delete_Call(FL_OBJECT *obj, long param)
{
 fl_delete_browser_line(header_obj->Header_List,
	fl_get_browser(header_obj->Header_List));
 fl_select_browser_line(header_obj->Header_List, 1);
 display_header();
}

void Header_Modify_Call(FL_OBJECT *obj, long param)
{
char buf[255];
struct _head_field *hf;

 sprintf(buf, "%s: %s", fl_get_input(header_obj->Header_Name),
			fl_get_input(header_obj->Header_Contents));

 if (((hf = get_field(buf)) == NULL) ||
	(hf->f_line == NULL) || !*hf->f_line) 	{
  display_msg(MSG_WARN, "modify", "Invalid header field");
  if (hf) {
   if (hf->f_line)
     free(hf->f_line);
   free(hf);
	  }
  return;					}

 if (is_spechdr(hf))	{
	if (hf->f_line)
		free(hf->f_line);
	free(hf);
	display_msg(MSG_WARN, "modify", "\"%s\" can not be used", hf->f_name);
	return;		}

 if (hf->f_line)
   free(hf->f_line);
 free(hf);

 sprintf(buf, "%s: %s", fl_get_input(header_obj->Header_Name),
			fl_get_input(header_obj->Header_Contents));

 fl_replace_browser_line(header_obj->Header_List,
	fl_get_browser(header_obj->Header_List), (char *)buf);

 display_header();

 return;
}

void
header_conf(int set_default, FD_config_header *form)
{

 header_obj = form;
 fl_set_browser_fontstyle(header_obj->Header_List, FL_FIXED_STYLE);
 fl_set_browser_fontsize(header_obj->Header_List, FL_NORMAL_SIZE);
 display_headers();

 return;
}

void
handle_header_input(FD_config_header *form)
{

 header_obj = form;
 store_headers();
}
