/*
 * Copyright(c) 1995,1996 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: xfmail.c,v 2.21 1997/12/26 11:48:40 gena Exp $
 */

#include <fmail.h>
#include <umail.h>
#include <X11/xpm.h>
#ifdef	HAVE_SETLOCALE
#include <X11/Xlocale.h>
#endif
#include <choose_folder.h>
#include "configform.h"
#define	MAIN_XPM
#define	ATT_XPM
#include "pixmaps.h"

FL_FORM		*main_form = NULL;
FL_OBJECT	*b_folders = NULL,
		*b_messages = NULL,
		*f_button = NULL;

FL_OBJECT	*inc_timer = NULL,
		*send_timer = NULL,
		*trash_timer = NULL,
		*imap_timer = NULL,
		*ttip_timer = NULL,
		*pgp_timer = NULL,
		*abrt;

static FL_OBJECT	*menu_file = NULL,
			*menu_message = NULL,
			*menu_folders = NULL,
			*menu_send = NULL,
			*status = NULL;

FL_OBJECT	*menu_misc = NULL;

#define	MESG_MENU     "View (Alt+V)|Edit (Alt+E)|Delete/Undelete (Alt+D)|Move to Folder (Alt+M)|Copy to Folder|Mark|Unmark|Mark Read/Unread|Print (Alt+P)|Bounce|Apply Rules|Select All|Select Marked|Delete from POP|Refresh|Options|Pipe"
#define SEND_MENU     "New (Alt+C)%l|Reply to Sender|Reply to All (Alt+R)|Forward (Alt+F)%l|Send All"
#define FOLD_MENU     "Create|Create Subfolder|Delete|Rename|Open|Open Unread|Empty Trash Folder|Catch Up Unread|Search|Rescan All|Options|Expand/Collapse|Expunge"
#define ctrl(a) (a-'A'+1)

/* RESOURCES */

static char	xfgeom[64] = "",
		xfmsg[127] = "";
static int	xficonic = 0,
		xfcompose = 0,
		xfwithhdr = 0;

static FL_CMD_OPT xfmail_cmdopt[] =
{
    {"-geometry", "*geometry", XrmoptionSepArg, 0},
    {"-iconic", ".iconic", XrmoptionNoArg, "1"},
    {"-compose", ".compose", XrmoptionNoArg, "1"},
    {"-withhdr", ".withhdr", XrmoptionNoArg, "1"},
    {"-message", ".message", XrmoptionSepArg, 0},
    {"-help", ".help", XrmoptionNoArg, "1"}
};
#define Ncopt (sizeof(xfmail_cmdopt)/sizeof(xfmail_cmdopt[0]))

static FL_resource xfres[] =
{
    {"XFMail.geometry", "Geometry", FL_STRING, xfgeom, 0, 64},
    {"iconic", "Iconic", FL_BOOL, &xficonic, "0"},
    {"compose", "Compose", FL_BOOL, &xfcompose, "0"},
    {"withhdr", "Withhdr", FL_BOOL, &xfwithhdr, "0"},
    {"message", "Message", FL_STRING, xfmsg, 0, 127}
};
#define Nropt  (sizeof(xfres)/sizeof(xfres[0]))

char conf_name[255];
char sender_name[127];
char homedir[255];
char maildir[255];
char configdir[255] = "";
char tmpdir[255];

int mpup, spup, fpup;

void cb_menu_messages(FL_OBJECT *obj, long arg);
void cb_messages(FL_OBJECT *obj, long arg);
void cb_menu_folders(FL_OBJECT *obj, long arg);
void cb_menu_send(FL_OBJECT *obj, long arg);
void cb_folders_dbl(FL_OBJECT *obj, long arg);

char user_n[32];
struct _mail_folder *current_folder = NULL;
struct _mail_folder *chfld = NULL;
static struct _mail_msg *current_message = NULL;

static int startup = 0;
#define	STARTUP_NORMAL	0x00
#define	STARTUP_COMPOSE	0x01

static int current_index = 0;
static int init = 0, nomainwindow = 0, initdone;
static int abortbutton = 0;
static int fbrowsersize = 180;
int logging = LOG_POP|LOG_IMAP|LOG_SMTP|LOG_NNTP|LOG_NET|LOG_ERRORS;
u_int busy = 0;
u_int supress_errors = 0;
u_int supress_questions = 0;
int xofft = 0, yofft = 0;

Pixmap iconPix_noMail, iconPix, icon_MailEdit, icon_ABook;
Pixmap iconPix_noMail_sh, iconPix_sh, icon_MailEdit_sh, icon_ABook_sh;
static int mailcur;

int show_msg[5] = { 2, 13, 5, 18, 100 };
int show_fld[3] = { 11, 3, 3 };
int color_msg[5] = { 4, 1, 8, 0, 11 };
int color_fld[9] = { 22, 5, 5, 5, 1, 10, 4, 0, 10 };

FD_Help_Form *info_obj = NULL;

void crash_handle(int s);
void empty_trash_folders();
void template_msg(struct _mail_msg *msg);

char *helps[] =
{   
    "<addrs>...                Add addresses to the recipient list",
    "-help                     this message",
    "-display host:dpy         display name",
    "-geometry geom            initial geometry",
    "-private                  private colormap",
    "-shared                   shared colormap",
    "-standard                 standard colormap",
    "-double                   double buffering",
    "-bw width                 controls border width (-3 ... 3)",
    "-iconic                   start iconic",
    "-cfgfile file             configuration file name",
    "-cfgdir dir               where all configuration files are",
    "-compose                  display compose window only",
    "-message file             take composed message from file (- stdin)",
    "-withhdr                  message in specified file includes header",
    0,
};  

static void
usage(char *s, int die)
{
char **q = helps;

    fprintf(stderr, "usage: %s: [options] <addrs>...\n", s);
    fprintf(stderr, "  where options are\n");
    for (; *q; q++)
        fprintf(stderr, "   %s\n", *q);

    if (die)
        exit(1);
}

static void  
parse_geometry(const char *gstr, int *x, int *y, 
               unsigned int *w, unsigned int *h)
{   
    int s;  
    /* For each value not found, the argument is left unchanged. */
    s = XParseGeometry((char *) gstr, x, y, w, h);
    if (*w<600)
        *w = 600;
    if (*h<300)
        *h = 300;
    if ((s & XValue) && (s & XNegative))
        *x += fl_scrw - *w;
    if ((s & YValue) && (s & YNegative))
        *y += fl_scrh - *h;
}   

void
abort_button_active(button, active)
FL_OBJECT *button;
int active;
{
FL_OBJECT *obj;

 if (!button)
	return;

 abortbutton = 0;
 if (active)
	fl_activate_form(button->form);
 obj = button->form->first;
 while (obj)		{
  if (obj != button) {
    if (active)
	fl_deactivate_object(obj);
    else
	fl_activate_object(obj);
		     }
  obj = obj->next;	}

 if (active)
	fl_activate_object(button);
 else
	fl_deactivate_object(button);
 XFlush(fl_display);

 return;
}

void
my_deactivate()
{
 fl_deactivate_all_forms();
 abort_button_active(abrt, 1);
 msg_text_activate(1);
}

void
my_activate()
{
 fl_activate_all_forms();
 abort_button_active(abrt, 0);
 msg_text_activate(0);
}

void
set_main_icon(hm, name)
	int	hm;
	char 	*name;
{
XWMHints *xwmh;

  if (!main_form || !initdone)
	return;

  if ((xwmh=XAllocWMHints()) != NULL)   {
   if (hm) {
        xwmh->icon_pixmap = iconPix;
        xwmh->icon_mask = iconPix_sh;
	   }
   else	{
        xwmh->icon_pixmap = iconPix_noMail;
        xwmh->icon_mask = iconPix_noMail_sh;
	}
   xwmh->flags = IconPixmapHint | IconMaskHint;
   XSetWMHints(fl_display, main_form->window, xwmh);
   XFree((void *)xwmh);			}

  if ((name != NULL) && (strlen(name) > 1))			{
	fl_set_form_title(main_form, name);
	XSetIconName(fl_display, main_form->window, name);	}
}

void
set_cursor(form, cursor)
FL_FORM *form;
int cursor;
{
 if (form) {
   if (cursor)
	fl_set_cursor(form->window, cursor);
   else
	fl_reset_cursor(form->window);
	   }

 return;
}

#if STDC_HEADERS || defined(USE_STDARG)
int display_msg(int flags, const char *title, const char *fmt, ...)
#else
int display_msg(flags, title, fmt, va_list)
int flags;
char *title;
char *fmt;
va_dcl
#endif
{
va_list ap;
char buf[255];
char buf1[255];
char errstr[64];
int mtype = flags & 0x0f, res = 0;

#if STDC_HEADERS || defined(USE_STDARG)
 va_start(ap, fmt);
#else
 va_start(ap);
#endif

#ifdef HAVE_VSNPRINTF
 vsnprintf(buf, 254, fmt, ap);
#else
 vsprintf(buf, fmt, ap);
#endif

 if ((mtype == MSG_FATAL) || (mtype == MSG_WARN) ||
	(mtype == MSG_STDERR)) 				{
#ifndef	HAVE_STRERROR
if (errno > 0) 	   {
        sprintf(errstr, "System Error %d", errno);
        errno = 0; }
#else
#ifdef	HAVE_SYS_NERR
 if ((errno > 0) && (errno < sys_nerr)) {
	strncpy(errstr, strerror(errno), 63);
	errno = 0; 			}
#else
 if (errno > 0) {
   if (strerror(errno))
	strncpy(errstr, strerror(errno), 63);
   else
        sprintf(errstr, "Unknown Error %d", errno);
   errno = 0;	}
#endif
#endif
 else
	strcpy(errstr, "ERROR");
							}

 if (!init)
	mtype = MSG_STDERR;

 switch (mtype) {
	case MSG_FATAL:
	  if (supress_errors)
		return 0;

	  if (title)
		fl_show_alert(errstr, title, buf, 1);
	  else
		fl_show_alert(errstr, buf, "", 1);
	  exit(1);	
	break;

	case MSG_QUEST:
	  if (supress_questions)
		return (flags & MSG_DEFNO) ? 0 : 1;

	  if (title) {
		sprintf(buf1, "%s\n\n%s", title, buf);
		res = fl_show_question(buf1, (flags & MSG_DEFNO) ? 0 : 1);
		     }
	  else
		res = fl_show_question(buf, (flags & MSG_DEFNO) ? 0 : 1);
	break;

	case MSG_WARN:
	  if (title)
		sprintf(buf1, "WARN: %s: %s", title, buf);
	  else
		sprintf(buf1, "WARN: %s", buf);

	  if (logging & LOG_ERRORS)
		log_str(buf1);

	  if (supress_errors)
		return 0;

	  if (title)
		fl_show_alert(errstr, title, buf, 1);
	  else
		fl_show_alert(errstr, buf, "", 1);
	break;

	case MSG_MSG:
	  if (supress_errors)
		return 0;

	  if (title)
		fl_show_message("MESSAGE", title, buf);
	  else
		fl_show_message("MESSAGE", buf, "");
	break;

	case MSG_STAT:
	 buf[200] = '\0';
	 if (status)
		fl_set_object_label(status, buf);
	 XFlush(fl_display);
	 return 0;
	break;

	case MSG_LOG:
	 if (title)
		sprintf(buf1, "%s: %s", title, buf);
	 else
		sprintf(buf1, "%s", buf);

	 log_str(buf1);
	 XFlush(fl_display);
	 return 0;
	break;

	case MSG_STDERR:
	 if (title)
		fprintf(stderr, "%s\n%s: %s\n", title, errstr, buf);
	 else
		fprintf(stderr, "%s\n%s\n", errstr, buf);
	 fflush(stderr);
	 return 0;
	break;

	default:
		return -1;
	break;
	}

	XFlush(fl_display);
	fl_check_only_forms();
	return res;
}

#if STDC_HEADERS || defined(USE_STDARG)
void fl_edit_error(char *fmt, ...)
#else     
int fl_edit_error(ffmt, va_list)
#endif
{
va_list arg;

#if STDC_HEADERS || defined(USE_STDARG)
 va_start(arg, fmt);
#else
 va_start(arg);
#endif

 display_msg(MSG_WARN, "fl_error", fmt, arg);
 va_end(arg);
}

int
idle_cb(XEvent *xev, void *d)
{
 check_extprocs();
 return 0;
}

int
fld_posthandler(FL_OBJECT *ob, int event,
                          FL_Coord mx, FL_Coord my, int key, void *raw_ev)
{
int num, cw;
struct _mail_folder *fld;

 switch (event) {
  case FL_PUSH:
     num=fl_get_browser(ob);
     num--;

     if (!(fld = get_folder_by_index(num)))
	break;

     if (!fld->subfold)
	break;

     cw = fl_get_string_width(ob->lstyle, ob->lsize, "+", 1);
     if (mx <= ob->x + ob->bw + cw + 3) {
      expand_collapse_tree(fld, 0);
      if (current_folder &&
	 (current_folder->status & FSKIP))
	cb_folders_dbl(ob, 0);
      restore_fld_win();		}
  break;

  case FL_KEYBOARD:
   switch(key) 	{
    case XK_F1:
     num = fl_get_browser(ob) - 1;

     if (!(fld = get_folder_by_index(num)))
	break;

     disp_infowindow(fld, INFO_FOLDER);
    break;

    case '\t':
     fl_set_focus_object(main_form, b_messages);
    break;
		}
  break;
		}

 return 0;
}

int
msg_posthandler(FL_OBJECT *ob, int event,
                          FL_Coord mx, FL_Coord my, int key, void *raw_ev)
{
int		 i, num, x, y;
struct _mail_msg *msg;
XEvent 		 *xev;

 xev = (XEvent *)raw_ev;

 switch (event) {
  case FL_PUSH:
	num = abs(fl_get_browser(b_messages)) - 1;

	if (xev->xbutton.state & ControlMask) {
  		fl_select_browser_line(b_messages, current_index + 1);
		break; }

	if (xev->xbutton.state & ShiftMask)
			{
		if (current_index > num) {
			x = num + 1;
			y = current_index + 1;
					 }
		else    {
			x = current_index + 1;
			y =  num + 1;
			}
		fl_freeze_form(main_form);
		for (i = x; i <= y; i++)
			fl_select_browser_line(b_messages, i);
  		fl_select_browser_line(b_messages, current_index + 1);
		fl_unfreeze_form(main_form);
		break;
			}

	msg = current_message;
	current_index = num;
	current_message = get_msg_by_index(current_folder, num);
	fl_freeze_form(main_form);
	redraw_msg(msg);
	if (msg != current_message)
	 redraw_msg(current_message);
	fl_deselect_browser(b_messages);
  	fl_select_browser_line(b_messages, current_index + 1);
	fl_unfreeze_form(main_form);

	if (current_message)
		display_msg(MSG_STAT, NULL, "From: %.64s Subject: %.114s", get_full_addr_line(current_message->header->From), current_message->header->Subject ? current_message->header->Subject : "* No Subject *");

	if ((key == 2) && current_message)	{
	  if (current_folder == draft)	   {
		set_msg_date(current_message, time(NULL), time(NULL));
		edit_msg(current_message); }
	  else
	  if (current_folder == template)
		template_msg(current_message);
	  else
		view_msg(current_message, 0); 
						}
	else
	if ((key == 3) && current_message)
		fl_dopup(mpup); 

  break;

  case FL_KEYBOARD:
   switch(key) 	{
    case XK_F1:
     disp_infowindow(current_message, INFO_MSG);
    break;

    case XK_Up:
	if (current_index == 0)
		break;

	num = current_index - 1;
	msg = current_message;
	if ((current_message = get_msg_by_index(current_folder, num)) == NULL)
		break;

	fl_freeze_form(main_form);
	redraw_msg(msg);
	redraw_msg(current_message);
  	fl_deselect_browser_line(b_messages, current_index + 1);
  	fl_select_browser_line(b_messages, num + 1);
	fl_unfreeze_form(main_form);
	current_index = num;
    break;

    case XK_Down:
	if (!current_message || !current_message->next)
		break;

	num = current_index + 1;
	msg = current_message;
	if ((current_message = get_msg_by_index(current_folder, num)) == NULL)
		break;

	fl_freeze_form(main_form);
	redraw_msg(msg);
	redraw_msg(current_message);
  	fl_deselect_browser_line(b_messages, current_index + 1);
  	fl_select_browser_line(b_messages, num + 1);
	fl_unfreeze_form(main_form);
	current_index = num;
    break;

    case '\t':
     fl_set_focus_object(main_form, b_folders);
    break;
		}
  break;
		}

  return 0;
}

int
preemptive_handler(FL_OBJECT *ob, int event,
                          FL_Coord mx, FL_Coord my, int key, void *raw_ev)
{
static int	l = 0;
static int	dragndrop = 0;
FL_OBJECT       *obj;
int		lh, t;
XEvent *xev;

 xev = (XEvent *)raw_ev;

 if (!fl_get_browser_maxline(ob))
	return !FL_PREEMPT;

 switch (event) {
  case FL_PUSH:
   if ((key == 2) || (key == 3)) {
	dragndrop = -1;
	return !FL_PREEMPT;	 }
  break;

  case FL_MOUSE:
   obj = fl_find_first(main_form, FL_FIND_MOUSE, mx, my);

   switch (dragndrop)  {
     case -1:
     break;

     case 0:
	if (obj != b_folders)
		return !FL_PREEMPT;
	dragndrop = 2;
	fl_select_browser_line(b_messages, current_index + 1);
	if (xev->xbutton.state & ShiftMask)
		set_cursor(main_form, XC_exchange);
	else
		set_cursor(main_form, mailcur);
	return FL_PREEMPT;
     break;

     case 1:
	if (obj == b_folders) 		    {
	  dragndrop = 2;
	  if (xev->xbutton.state & ShiftMask)
	   set_cursor(main_form, XC_exchange);
	  else
	   set_cursor(main_form, mailcur); }

	return FL_PREEMPT;
     break;

     case 2:
	if (obj != b_folders)  {
	  dragndrop = 1;
	  set_cursor(main_form, XC_cross);  }
	else	{
	  lh = (ob->h - 2 * abs(ob->bw))/fl_get_browser_screenlines(b_folders);
	  t = fl_get_browser_topline(b_folders);
	  l = my - ob->y - abs(ob->bw);
	  if ((l <= 0) && (t > 0))  {
		fl_set_browser_topline(b_folders, --t);
		l = 0;		    }

	  l = l/lh + 1;
	  if (l > fl_get_browser_screenlines(b_folders))   {
		fl_set_browser_topline(b_folders, ++t);
		t = fl_get_browser_topline(b_folders);
		l = fl_get_browser_screenlines(b_folders); }
	  fl_select_browser_line(b_folders, l + t - 1);
		}

	return FL_PREEMPT;
     break;
			}
  break;

  case FL_RELEASE:
	switch(dragndrop) {
	  case -1:
	  break;

	  case 0:
		fl_select_browser_line(b_messages, current_index + 1);
		return !FL_PREEMPT;
	  break;

	  case 1:
		set_cursor(main_form, 0); 
		fl_ringbell(100);
	  break;

	  case 2:
		set_cursor(main_form, 0); 
		if (!l)
			fl_ringbell(100);
		else {
			l = l + fl_get_browser_topline(b_folders) - 2;
			if (l >= folders_num)
				fl_ringbell(100);
			else	{
				if (xev->xbutton.state & ShiftMask)
					copy_messages(get_folder_by_index(l));
				else
					move_messages(get_folder_by_index(l));
				}
		     }
	  break;
			  }
	dragndrop = 0;
	l = 0;
  break;
		}

  return !FL_PREEMPT;
}

int
get_fld_color(fld)
struct _mail_folder *fld;
{
int color;

 color = color_fld[FLD_NORMAL_CLR];
 if (fld->color != -1)
	color = fld->color;
 else
 if (fld->status & FDUMMY)
	color = color_fld[FLD_DUMMY_CLR];
 else
 if (fld->status & SEARCH)
	color = color_fld[FLD_SEARCH_CLR];
 else
 if ((fld->flags & FMARKED) ||
	(fld->status & FMRKTMP))
	color = color_fld[FLD_MARK_CLR];
 else
 if (fld->status & FRECNT)
	color = color_fld[FLD_RECENT_CLR];
 else
 if (fld->status & SYSTEM)
	color = color_fld[FLD_SYSTEM_CLR];
 else
 if (fld->type & F_IMAP)
	color = color_fld[FLD_IMAP_CLR];
 else
 if (fld->type & F_NEWS)
	color = color_fld[FLD_NEWS_CLR];

 return color;
}

char *
get_fld_line(fld)
struct _mail_folder *fld;
{
static char fldline[64];
int color = (fld == current_folder) ? color_fld[FLD_CURR_CLR] : get_fld_color(fld);
char tchar = ' ';

 if (fld->subfold)
	tchar = (fld->flags & FEXPND) ? '-' : '+';

 if (fld->status & FDUMMY)
	sprintf(fldline, "@C%d%c%-.*s%-*.*s", color, tchar, fld->level, "           ", show_fld[FOLD_LEN], show_fld[FOLD_LEN], fld->sname);
 else
	sprintf(fldline, "@C%d%c%-.*s%-*.*s%*d%*d", color, tchar, fld->level, "           ", show_fld[FOLD_LEN], show_fld[FOLD_LEN], fld->sname, show_fld[FNUM_LEN], fld->num_msg,  show_fld[FUNR_LEN], fld->unread_num);

 return fldline;
}

char *
get_msg_line(msg)
struct _mail_msg *msg;
{
static char msgline[255];
struct _head_field *fld;
u_long mlen;
char tbuf[18], size[6], mstat[5], subj[128], *addrline, *apref = "";
int color, ftype, fromlen = show_msg[FROM_LEN];

 mstat[0] = size[0] = tbuf[0] = '\0';
 color = color_msg[MSG_NORMAL_CLR];
 ftype = -1;

 if (msg == current_message)
	color = color_msg[MSG_CURR_CLR];

 if (show_msg[STAT_LEN]) {
	mstat[2] = '\0';
	mstat[0] = mstat[1] = ' ';
	if (msg->status & LOCKED)
		mstat[0] = 'L';
	else
	if (msg->status & MTOUS)
		mstat[0] = '+';
	else
	if (msg->flags & UNREAD)
		mstat[0] = 'N';
	else
	if (msg->flags & M_SFAILED)
		color = 5;

	if (msg->flags & UNREAD)
		color = color_msg[MSG_UNREAD_CLR];

	if ((msg->flags & MARKED) || (msg->status & MARKTMP))	{
		if (color == 0)
			color = color_msg[MSG_MARK_CLR];
		mstat[0] = '*';  				}

	if (msg->status & MOVED)
		mstat[0] = 'M';
	else
	if (msg->status & DELETED)			{
		mstat[0] = 'D';
		color = color_msg[MSG_DELETED_CLR];	}

	if (msg->flags & ANSWERED) 
		mstat[1] = 'A';
	else
	if (msg->flags & FORWARDED) 
		mstat[1] = 'F';
	else
	if ((msg->flags & PGP_SIGNED) || (msg->flags & PGP_ENCRYPTED))
		mstat[1] = 'P';
	else
	if (msg->flags & URGENT2) 
		mstat[1] = '!';
	else
	if (is_mime_msg(msg))
		mstat[1] = 'M';
	else
	if (msg->flags & H_ONLY) 
		mstat[1] = '/';
			}

 if (show_msg[DATE_LEN])
	strftime(tbuf, 16, "%h-%d %H:%M %y ",localtime(&msg->header->snt_time));

 if (show_msg[SIZE_LEN]) {
	if ((msg->flags & H_ONLY) &&
		(fld = find_field(msg, MIME_C_LENGTH)) )
		mlen = atol(fld->f_line);
	else
		mlen = msg->msg_len;

	if (mlen >= 10000)
		sprintf(size, "%dK ", (int)(mlen / 1024));
	else
		sprintf(size, "%d ", (int)mlen);
			}

 strncpy(subj, msg->header->Subject ? rfc1522_decode(msg->header->Subject, &ftype) : "", 127);
 subj[127] = '\0';
 if (fromlen && ((current_folder->flags & FSHRECP) ||
	(msg->status & MFROMUS)))	{
  addrline = msg->header->To ? get_short_addr_line(msg->header->To) :
		(msg->header->News ? msg->header->News->name : "");
  apref = msg->header->To ? "To: " : (msg->header->News ? "Nn: " : "");
  fromlen -= strlen(apref);
  if (fromlen <= 0)	{
	fromlen = show_msg[FROM_LEN];
	apref = "";	}
					}
 else
  addrline = get_short_addr_line(msg->header->From);

 if (msg->status & S_THREAD)
  sprintf(msgline, "@C%d%*.*s%*s %-*.*s%-*.*s%s%-*.*s %.*s",
	color, msg->refs, show_msg[SUBJ_LEN], "", show_msg[STAT_LEN], mstat,
	show_msg[DATE_LEN], show_msg[DATE_LEN], tbuf, show_msg[SIZE_LEN],
	show_msg[SIZE_LEN], size, apref, fromlen, fromlen,
	addrline, show_msg[SUBJ_LEN], subj);
 else
  sprintf(msgline, "@C%d%*s %-*.*s%-*.*s%s%-*.*s %.*s",
	color, show_msg[STAT_LEN], mstat, show_msg[DATE_LEN],
	show_msg[DATE_LEN], tbuf, show_msg[SIZE_LEN], show_msg[SIZE_LEN],
	size, apref, fromlen, fromlen, addrline, show_msg[SUBJ_LEN], subj);

 return msgline;
}

void
display_fld_status(fld)
struct _mail_folder *fld;
{
char ftype[8], flags[64];

 strcpy(ftype, "MH");
 flags[0] = '\0';
 flags[1] = '\0';

 if (fld == NULL)
	return;

 if (fld->type & F_IMAP)
	strcpy(ftype, "IMAP");
 else
 if (fld->type & F_NEWS)
	strcpy(ftype, "NEWS");
 else
 if (fld->type & F_MBOX)
	strcpy(ftype, "MBOX");

 if (fld->status & FRONLY)
	strcat(flags, " READ-ONLY");
 
 if (fld->status & SYSTEM)
	strcat(flags, " SYSTEM");
 
 if (fld->flags & CACHED)
	strcat(flags, " CACHED");
 
 if (fld->status & NOTRASH)
	strcat(flags, " TRASH");
 
 flags[0] = '(';

 if (fld->descr)
  display_msg(MSG_STAT, NULL, "%-.64s (%-.64s): Type: %s Flags: %s) Messages: %d Unread: %d", fld->fold_path, fld->descr, ftype, flags, fld->num_msg, fld->unread_num);
 else
  display_msg(MSG_STAT, NULL, "%-.64s: Type: %s Flags: %s) Messages: %d Unread: %d", fld->fold_path, ftype, flags, fld->num_msg, fld->unread_num);
}

void
redraw_fld(fld)
struct _mail_folder *fld;
{
 if (!fld || !b_folders)
	return;

 if ((fld->status & FHIDDN) ||
	(fld->status & FSKIP))
	return;

 fld->status &= ~FRESCAN;
 if (!(folder_sort & FLD_SORTED)) {
	sort_folders();
	redraw_fld_win();
	return; }

 fl_replace_browser_line(b_folders, get_folder_index(fld) + 1, get_fld_line(fld));
 if (fld == current_folder)
	redraw_msg_win();

 display_fld_status(fld);
}

void
redraw_fld_line(fld)
struct _mail_folder *fld;
{
 if (fld->status & FSKIP)
	return;

 if (!b_folders || !menu_folders)
	return;

 if (fld && !(fld->status & FHIDDN)) {
  fl_replace_browser_line(b_folders, get_folder_index(fld) + 1, get_fld_line(fld));
  if (fld == current_folder) {
        fl_set_menu_item_mode(menu_folders,2, (current_folder->status & NOINFR) ? FL_PUP_GRAY : FL_PUP_NONE);
        fl_set_menu_item_mode(menu_folders,3, (current_folder->status & SYSTEM) ? FL_PUP_GRAY : FL_PUP_NONE);
        fl_set_menu_item_mode(menu_folders,4, (current_folder->status & SYSTEM) ? FL_PUP_GRAY : FL_PUP_NONE);
			     }
	}
}

void
redraw_msg(msg)
struct _mail_msg *msg;
{
 if (!msg || !b_messages)
	return;

 if (msg->folder != current_folder)
	return;

 fl_replace_browser_line(b_messages, get_msg_index(current_folder, msg) + 1, get_msg_line(msg));
 msg->status &= ~MREFRESH;

 return;
}

void
refresh_msgs()
{
struct _mail_msg *msg = current_folder->messages;
int hascurrent = 0;

 while (msg)	   {
  if (msg->status & MREFRESH)
	redraw_msg(msg);
  if (msg == current_message)
	hascurrent = 1;
  msg = msg->next; }

 if (!hascurrent)		{
	current_message = current_folder->messages;
	current_index = 0;
	if (current_folder->status & FRESCAN)
		redraw_fld_line(current_folder);
	redraw_msg_win();	}
 else	{
  if (current_folder->status & FRESCAN)	{
   redraw_fld_line(current_folder);
   restore_msg_win();
   return;				}
	}
}

void
redraw_fld_win()
{
int i;

	if (!main_form)
		return;

	fl_freeze_form(main_form);
	fl_clear_browser(b_folders);

	if (!(folder_sort & FLD_SORTED))
		sort_folders();

	for( i = 0; i < folders_num; i++) {
		if (mailbox[i]->status & FSKIP)
			continue;
		fl_add_browser_line(b_folders, get_fld_line(mailbox[i])); }

	fl_select_browser_line(b_folders,get_folder_index(current_folder) + 1);

        if (current_folder &&
			(current_folder->status & SYSTEM))
                i=FL_PUP_GRAY;
        else
                i=FL_PUP_NONE;

        fl_set_menu_item_mode(menu_folders,2, (current_folder && (current_folder->status & NOINFR)) ? FL_PUP_GRAY : FL_PUP_NONE);
        fl_set_menu_item_mode(menu_folders,3, i);
        fl_set_menu_item_mode(menu_folders,4, i);

	display_fld_status(current_folder);

	fl_unfreeze_form(main_form);
}

void
restore_fld_win()
{
int i, k;

	if (!main_form)
		return;

	fl_freeze_form(main_form);
	k = fl_get_browser_topline(b_folders);
	fl_clear_browser(b_folders);
	for( i = 0; i < folders_num; i++) {
		if (mailbox[i]->status & FSKIP)
			continue;
		fl_add_browser_line(b_folders, get_fld_line(mailbox[i])); }
	fl_select_browser_line(b_folders, get_folder_index(current_folder) + 1);
	fl_set_browser_topline(b_folders, k);
	fl_unfreeze_form(main_form);
}

void
restore_msg_win()
{
struct _mail_msg *msg;
int i;

	if (!main_form)
		return;

	if (!(current_folder->status & SORTED))
		sort_folder(current_folder);

	i = fl_get_browser_topline(b_messages);
	fl_freeze_form(main_form);
	fl_clear_browser(b_messages);

	msg = current_folder->messages;
	while (msg) {
		fl_add_browser_line(b_messages, get_msg_line(msg));
		msg->status &= ~MREFRESH;
		msg = msg->next;
		}

	if (!current_message)
		current_message = current_folder->messages;

	if (current_message) {
	   current_index = get_msg_index(current_folder, current_message);
	   fl_select_browser_line(b_messages,current_index + 1);
			     }

	fl_set_browser_topline(b_messages,i);
	fl_unfreeze_form(main_form);
	display_fld_status(current_folder);
	current_folder->status &= ~FRESCAN;
}

void
redraw_msg_win()
{
struct _mail_msg *msg;

	if (!main_form)
		return;

	fl_freeze_form(main_form);
	fl_clear_browser(b_messages);

	if (!(current_folder->status & SORTED))
		sort_folder(current_folder);

	msg = current_folder->messages;
	while (msg)			{
		fl_add_browser_line(b_messages, get_msg_line(msg));
		msg->status &= ~MREFRESH;
		msg = msg->next;	}

	fl_select_browser_line(b_messages,current_index + 1);
	fl_set_browser_topline(b_messages,current_index + 1);
	fl_unfreeze_form(main_form);
	display_fld_status(current_folder);
	current_folder->status &= ~FRESCAN;
}

void
refresh_folders()
{
int i;

  for( i = 0; i < folders_num; i++)	{
   if (mailbox[i]->status & FSKIP)
	continue;
   if (mailbox[i]->status & FRESCAN)
	redraw_fld(mailbox[i]);
   mailbox[i]->status &= ~FRESCAN;
					}

  return;
}

void
redraw_folders()
{
struct _mail_msg *msg;
int i;

	if (!main_form)
		return;

	fl_freeze_form(main_form);
	fl_clear_browser(b_folders);

	if (!(folder_sort & FLD_SORTED))
		sort_folders();

	for( i = 0; i < folders_num; i++)	{
		if (mailbox[i]->status & FSKIP)
			continue;
		fl_add_browser_line(b_folders, get_fld_line(mailbox[i]));
		mailbox[i]->status &= ~FRESCAN;	}

	fl_select_browser_line(b_folders,get_folder_index(current_folder) + 1);

        if (current_folder->status & SYSTEM)  
                i=FL_PUP_GRAY;
        else
                i=FL_PUP_NONE;

        fl_set_menu_item_mode(menu_folders,2, (current_folder->status & NOINFR) ? FL_PUP_GRAY : FL_PUP_NONE);
        fl_set_menu_item_mode(menu_folders,3, i);
        fl_set_menu_item_mode(menu_folders,4, i);

	fl_clear_browser(b_messages);

	if (!(current_folder->status & SORTED))
		sort_folder(current_folder);

	if (current_index == 0)
		current_message = current_folder->messages;
	else
		current_message = get_msg_by_index(current_folder, current_index);

	if (!current_message) {
		current_message = current_folder->messages;
		current_index = 0; }

	msg = current_folder->messages;

	while (msg) {
		fl_add_browser_line(b_messages, get_msg_line(msg));
		msg = msg->next;
		}

	display_fld_status(current_folder);

	fl_select_browser_line(b_messages,current_index + 1);
	fl_set_browser_topline(b_messages,current_index + 1);
	fl_unfreeze_form(main_form);
}

struct _mail_msg
*delete_msg(msg)
	struct _mail_msg	*msg;
{
struct _mail_folder		*old_folder;
struct _mail_msg		*nxt_msg;
int i;

	if (!msg)
		return NULL;

	if (!(msg->status & LOCKED)) {

		for (nxt_msg = msg->next; nxt_msg; nxt_msg = nxt_msg->next) {
		 if (!(nxt_msg->status & LOCKED) &&
			!(nxt_msg->status & DELETED) &&
			!(nxt_msg->status & MNOTEXISTS))
			break;
									    }

		old_folder = msg->folder;
		msg->status |= DELETED;

		if (msg == current_message)
			current_message = nxt_msg;

		old_folder->update(old_folder);
		current_index = nxt_msg ? get_msg_index(nxt_msg->folder, nxt_msg) : 0;
		for( i = 0; i < folders_num; i++)       {
		 if (mailbox[i]->status & FSKIP) 
			continue;
		 if (mailbox[i]->status & NOTRASH)   {
			redraw_fld_line(mailbox[i]);
			if (current_folder == mailbox[i])
				restore_msg_win();
						    }
							}

		redraw_fld_line(old_folder);
		if (old_folder == current_folder)
			restore_msg_win();

		return nxt_msg;
	}
	return msg;
}

struct _mail_msg
*next_msg(ur, cmsg)
	int	ur;
	struct _mail_msg 	*cmsg;
{
struct _mail_msg 	*msg;
struct _mime_msg	*mime;

	if (!cmsg)
		return NULL;

	if (cmsg->data == MSG_DAT_ENCAP) {
	 if (ur || (cmsg->pdata == NULL))
		return NULL;

	 msg = (struct _mail_msg *)cmsg->pdata;
	 mime = msg->mime;
	 while (mime)	{
	  if (mime->flags & LOCK_PART)	{
		mime = mime->mime_next;
		if (mime == NULL)
			return NULL;
		msg = get_mime_msg(msg, mime);
		return msg;
					}
	  mime = mime->mime_next;
			}
	 return NULL;
					 }

	msg = cmsg->next;

	if (ur) {
		while (msg) {
			if ((msg->flags & UNREAD) &&
				!(msg->status & LOCKED) &&
				!(msg->status & MNOTEXISTS) &&
				!(msg->status & DELETED)) 
			 return msg; 
			msg = msg->next;
				}

		if (!get_total_unread() ||
			!b_getcfg_int(conf_name, "switchfold", 1))
			return NULL;

		if ((msg = get_unread_msg()) == NULL)
			return NULL;

		if (msg->folder == current_folder)
			return msg;

		current_folder->close(current_folder);
		current_folder = msg->folder;
		current_message = msg;
		current_index = get_msg_index(current_folder, current_message);
		redraw_fld_win();
		redraw_msg_win();
		return msg;
		}
	else {
		while (msg) {
			if (!(msg->status & LOCKED) &&
				!(msg->status & DELETED) &&
				!(msg->status & MNOTEXISTS)) 
			 return msg; 
			msg = msg->next;
			    }
		return NULL;
	     }

	return NULL;

}

struct _mail_msg
*prev_msg(ur, cmsg)
	int	ur;
	struct _mail_msg 	*cmsg;
{
struct _mail_msg 	*msg;
struct _mime_msg	*mime;
int i, index;

	if (!cmsg)
		return NULL;

	if (cmsg->data == MSG_DAT_ENCAP) {
	 if (ur || (cmsg->pdata == NULL))
		return NULL;

	 msg = (struct _mail_msg *)cmsg->pdata;
	 mime = msg->mime;
	 while (mime && mime->mime_next)	{
	  if (mime->mime_next->flags & LOCK_PART)	{
		msg = get_mime_msg(msg, mime);
		return msg;
							}
	  mime = mime->mime_next;
						}
	 return NULL;
					 }

	index = get_msg_index(cmsg->folder, cmsg);
	if ((index == -1) || (index == 0))
		return NULL;

	for (i = index-1;i >= 0; i--) {
	  msg = get_msg_by_index(cmsg->folder, i);
	  if (!msg)
		return NULL;

	  if (ur) {
	  if ((msg->flags & UNREAD) &&
		!(msg->status & DELETED) &&
		!(msg->status & MNOTEXISTS) &&
		!(msg->status & LOCKED))
		return msg;
		} else {
	  if (!(msg->status & LOCKED) &&
		!(msg->status & DELETED) &&
		!(msg->status & MNOTEXISTS))
		return msg;
			}
					}

	  if (ur) {
	    if (!get_total_unread() ||
		!b_getcfg_int(conf_name, "switchfold", 1))
			return NULL;

	    return get_unread_msg();
		  }

	return NULL;
}

int
send_msg(msg, queue)
struct _mail_msg	*msg;
int	queue;
{
struct _mail_folder *fld;
int oldoffline = 0, setc = 0;

 fld = msg->folder;

 if (msg == current_message)
	setc = 1;

 if (queue) {
	oldoffline = offline;
	offline = 1;
	    }

 if (send_message(msg) == -1) {
	display_msg(MSG_WARN, "send", "Failed to send");
	if (queue)
		offline = oldoffline;
	return -1;	      }

 if (queue)
	offline = oldoffline;

 if (setc) 		   {
	current_message = current_folder->messages;
	current_index = 0; }

 refresh_folders();
 redraw_fld(outbox);
 redraw_fld(sentm);
 return 0;
}

int
send_pup_cb(int i)
{
   cb_menu_send(NULL, i);
   return 100;
}

int
mesg_pup_cb(int i)
{
   if (i == 100)
	return i;

   cb_menu_messages(NULL, i);
   return i;
}

int
fold_pup_cb(int i)
{
   cb_menu_folders(NULL, i);
   return i;
}

void
cb_fbutton(FL_OBJECT *obj, long arg)
{
}

int
cb_fbutton_handler(ob,event,mx,my,key,xev)
FL_OBJECT *ob;
int event;
FL_Coord mx;
FL_Coord my;
int key;
void *xev;
{
static int fbrowser;
int tmx;

 switch(event) 	{
  case FL_PUSH:
   if (key != 1)
	return 0;
   fbrowser = fbrowsersize;
   set_cursor(main_form, XC_sb_h_double_arrow);
   fl_drawmode(GXxor);
   fl_line(mx, f_button->y, mx, f_button->y + f_button->h, FL_WHITE);
   fl_line(mx - 1, f_button->y, mx - 1, f_button->y + f_button->h, FL_WHITE);
   fl_line(mx + 1, f_button->y, mx + 1, f_button->y + f_button->h, FL_WHITE);
   fl_drawmode(GXcopy);
  break;

  case FL_RELEASE:
   if (key != 1)
	return 0;
   set_cursor(main_form, 0);
   if ((fbrowser != fbrowsersize) && (fbrowser >= 80)
	&& (fbrowser <= 300)) {
     fl_set_object_size(b_folders, fbrowser, b_folders->h);
     fl_set_object_geometry(b_messages, 5 + fbrowser, b_messages->y,
			main_form->w - fbrowser - 8, b_messages->h);
     fl_set_object_position(f_button, 3 + fbrowser, f_button->y);

     fbrowsersize = fbrowser;
     b_putcfg_int(conf_name, "fbrowser", fbrowsersize);
				 }
   fbrowser = -1;
  break;

  case FL_MOUSE:
   if (key != 1)
	return 0;

   fl_drawmode(GXxor);
   if (fbrowser != -1)  {
   tmx = fbrowser + b_folders->x;
   fl_line(tmx, f_button->y, tmx, f_button->y + f_button->h, FL_WHITE);
   fl_line(tmx - 1, f_button->y, tmx - 1, f_button->y + f_button->h, FL_WHITE);
   fl_line(tmx + 1, f_button->y, tmx + 1, f_button->y + f_button->h, FL_WHITE);
			}

   if ((my < b_folders->y) || (my > b_folders->y + b_folders->h)) {
	fl_drawmode(GXcopy);
	set_cursor(main_form, 0);
	fbrowser = -1;
	break;				     			  }

   if (((mx - b_folders->x) < 80) || ((mx - b_folders->x) > 300)) {
	fl_drawmode(GXcopy);
	set_cursor(main_form, 0);
	fbrowser = -1;
	break;				     			  }

   if (fbrowser == -1)
	set_cursor(main_form, XC_sb_h_double_arrow);

   fbrowser = mx - b_folders->x;
   fl_line(mx, f_button->y, mx, f_button->y + f_button->h, FL_WHITE);
   fl_line(mx - 1, f_button->y, mx - 1, f_button->y + f_button->h, FL_WHITE);
   fl_line(mx + 1, f_button->y, mx + 1, f_button->y + f_button->h, FL_WHITE);
   fl_drawmode(GXcopy);
  break;

  case FL_ENTER:
   set_cursor(main_form, XC_sb_h_double_arrow);
  break;

  case FL_LEAVE:
   set_cursor(main_form, 0);
  break;
		}

  return 0;
}

void
template_msg(msg)
struct _mail_msg *msg;
{
struct _mail_msg *msg1;

 if (!display_msg(MSG_QUEST, "Template", "Create new message from template?"))
	return;

 msg->status |= LOCKED;
 if (!(msg1 = outbox->copy(current_message, outbox))) 	{
	display_msg(MSG_WARN,"template","Can not copy message");
	return;						}

 msg->status &= ~LOCKED;
 msg1->status &= ~LOCKED;
 msg1->status |= MSGNEW;
 set_msg_date(msg1, time(NULL), time(NULL));
 edit_msg(msg1);
 redraw_fld_line(outbox);

 return;
}

void
cb_messages_dbl(FL_OBJECT *obj, long arg)
{
	if (!current_message)
		return;

	if (current_folder == draft)	   {
		set_msg_date(current_message, time(NULL), time(NULL));
		edit_msg(current_message); }
	else
	if (current_folder == template)
		template_msg(current_message);
	else
		view_msg(current_message, 1);

	return;
}

void
cb_messages(FL_OBJECT *obj, long arg)
{
}

void
cb_folders(FL_OBJECT *obj, long arg)
{
int		num;
struct _mail_folder *fld;

	num = fl_get_browser(obj);
	num--;

	if (!(fld = get_folder_by_index(num)))
		return;

	display_fld_status(fld);

	if (current_folder && (fl_mouse_button() == FL_RIGHT_MOUSE))	{
		chfld = fld;
		fl_dopup(fpup);
		chfld = NULL;						}

	if (current_folder && (fl_mouse_button() == FL_MIDDLE_MOUSE))
		cb_folders_dbl(obj, arg);

	return;
}

void
cb_folders_dbl(FL_OBJECT *obj, long arg)
{
int	num, flags, i, setlast = 0;
struct _mail_folder *fld, *ofld;
struct _mail_msg *msg;
XEvent *xev;

	if (busy)
		return;
	busy = 1;
	xev = (XEvent *)fl_last_event();

	set_cursor(main_form, XC_watch);
	my_deactivate();
	num = current_folder->unread_num;
	current_folder->close(current_folder);
	if (num != current_folder->unread_num)
		update_title();

	num=fl_get_browser(obj) - 1;
	fld = get_folder_by_index(num);
	if (!fld) {
		set_cursor(main_form, 0);
		my_activate();
		busy = 0;
		return;
		}
	num = fld->unread_num;
	flags = 0;
	if (xev->xbutton.state & ShiftMask)
		flags = FOPEN_UNREAD;

	if (fld->open(fld, flags) == -1) {
		current_folder->open(current_folder, 0);
		redraw_fld_line(current_folder);
		redraw_msg_win();
		my_activate();
		set_cursor(main_form, 0);
		fl_select_browser_line(obj, get_folder_index(current_folder) - 1);
		display_msg(MSG_WARN, "OPEN","Can not open folder");
		busy = 0;
		return;				}

	if ((fld->sort != -1) && (fld->sort & MSG_ASCEND))
		setlast = 1;
	else
	if (sort_type & MSG_ASCEND)
		setlast = 1;

	if (fld != current_folder) {
		current_index = 0;
		current_message = fld->messages;
		i = 0;
		msg = fld->messages;
		while (msg)	{
			if (setlast & (msg->next == NULL))	{
				current_message = msg;
				current_index = i;
				break;		   		}
			if (msg->flags & UNREAD)   {
				current_message = msg;
				current_index = i;
				break;		   }
			msg = msg->next;
			i++;
				}
				   }
	else
		current_message = get_msg_by_index(current_folder, current_index);

	ofld = current_folder;
	current_folder = fld;
	mark_to_us(current_folder);

	redraw_fld_line(ofld);
	if (ofld == fld)
		restore_msg_win();
	else	{
		redraw_fld_line(current_folder);
		redraw_msg_win();
		}

	refresh_folders();
	my_activate();
	set_cursor(main_form, 0);
	if (num != fld->unread_num)
		update_title();

	busy = 0;
	return;
}

void
cb_menu_misc(FL_OBJECT *obj, long arg)
{
int	num;

    num=fl_get_menu(obj);
    switch(num) {
	case 1:	
		addr_book_set_placement(-1, -1);
		addr_book(NULL, NULL, 0);
	break;

        case 2:
		fl_deactivate_form(main_form);
		xfm_config_new(1);
		fl_activate_form(main_form);
        break;

	case 3:
		fl_deactivate_form(main_form);
		xfm_config(1);
		fl_activate_form(main_form);
	break;

	case 4:
		fl_deactivate_form(main_form);
		set_el_size();
		fl_activate_form(main_form);
	break;

	case 5:
		sign_edit();
	break;

	case 6:
		fl_deactivate_form(main_form);
		rules_conf();
		fl_activate_form(main_form);
	break;

	case 7:
		get_new_mail(0);
	break;

	case 8:
		if (imap_isconnected()) {
			if (current_folder->type & F_IMAP) {
				current_folder = inbox;
				current_index = 0;
				current_message = inbox->messages;
				current_folder->open(current_folder, 0);
				mark_to_us(current_folder);
							    }
			my_deactivate();
			set_cursor(main_form, XC_watch);
			imap_close(1);
			redraw_folders();
			update_title();
			set_cursor(main_form, 0);
			my_activate();
			fl_replace_menu_item(menu_misc, 8, "IMAP connect");
					}
		else	{
			my_deactivate();
			set_cursor(main_form, XC_watch);
			if (imap_init() == 0) {
				fl_replace_menu_item(menu_misc, 8, "IMAP disconnect");
				redraw_folders(); }
			update_title();
			set_cursor(main_form, 0);
			my_activate();
			}
	break;

	case 9:
		log_win();
	break;

	case 10: /* Debug */
	break;

	default:
	break;
		}
}

void
cb_menu_help(FL_OBJECT *obj, long arg)
{
int	num;
struct _mail_msg *msg;
struct _mime_msg *mime;
char buf[255],bugtext[512];

    num=fl_get_menu(obj);
    fl_deactivate_form(main_form);
    switch(num) {
	case 1:	
		cb_help_button(NULL, 0);
	break;

	case 2:
		about(0);
	break;

	case 3:
		fl_show_message("BUG REPORT", "Please write down detailed information about the problem and press send", "(before this please consult with KNOWNBUGS file\nincluded in XFMail distribution)");

		msg = create_message(outbox);
		strcpy(buf, "XFMail bug report list <xfmail-bugs@Burka.NetVision.net.il>");
		msg->header->To = get_address(buf, ADDR_IGNORE_COMMAS);
		msg->header->Subject = strdup("XFMail bug report");
		sprintf(bugtext, "XFMail %s%s %s on %s.\nCompiled %s\n\
------------------------Start of bug report------------------------------\n\
\n\
------------------------End of bug report--------------------------------\n"
, VERSION, DEBUGVERSION, PATCHLEVEL, XF_OS, COMPILED);

		update_message_text(msg, bugtext);

		sprintf(buf, "%s/.xfmrules", configdir);
		if ((mime = attach_file(msg, buf, &mailcap[DEFAULT_MAILCAP], DEFAULT_ENCODING, ATT_NOUPDATE)) != NULL)
			set_mime_descr(mime, "Filtering rules file");

		sprintf(buf, "%s/.xfdefaults", configdir);
		if ((mime = attach_file(msg, buf, &mailcap[DEFAULT_MAILCAP], DEFAULT_ENCODING, ATT_NOUPDATE)) != NULL)
			set_mime_descr(mime, "XFdefaults file");

		sprintf(buf, "%s/.xfmfolders", configdir);
		if ((mime = attach_file(msg, buf, &mailcap[DEFAULT_MAILCAP], DEFAULT_ENCODING, ATT_NOUPDATE)) != NULL)
			set_mime_descr(mime, "Folders file");

		sprintf(buf, "%s/.xfmfolders-imap", configdir);
		if ((mime = attach_file(msg, buf, &mailcap[DEFAULT_MAILCAP], DEFAULT_ENCODING, ATT_NOUPDATE)) != NULL)
			set_mime_descr(mime, "IMAP folders file");

		sprintf(buf, "%s/.xfmailrc", tmpdir);
		save_cfg_file(buf, 1);
		if ((mime = attach_file(msg, buf, &mailcap[DEFAULT_MAILCAP], DEFAULT_ENCODING, ATT_NOUPDATE)) != NULL)
			set_mime_descr(mime, "Configuration file");

		if (update_mime(msg) == -1)
			display_msg(MSG_WARN, "Bug report", "Failed to attach configuration files");

		unlink(buf);

		edit_msg(msg);
		set_edit_cursor(msg, 0, 3);
		refresh_folders();
	break;

	case 4:
		if (!display_msg(MSG_QUEST, "Are you sure you want to subscribe?", "(mail will be sent to Majordomo@Burka.NetVision.net.il)"))
			break;

		msg = create_message(outbox);
		sprintf(buf, "Majordomo@Burka.NetVision.net.il");
		msg->header->To = get_address(buf, ADDR_IGNORE_COMMAS);
		update_message_text(msg, "subscribe xfmail\n");
		if ((send_message(msg) == -1))
			display_msg(MSG_WARN, "subscribe", "Failed to send message to Majordomo@Burka.NetVision.net.il");
		else
			fl_show_message("MAILING LIST", "Subscribe request sent to", "Majordomo@Burka.NetVision.net.il");
		refresh_folders();
	break;

	case 5:
		if (!display_msg(MSG_QUEST, "Are you sure you want to unsubscribe?", "(mail will be sent to Majordomo@Burka.NetVision.net.il)"))
			break;

		msg = create_message(outbox);
		sprintf(buf, "Majordomo@Burka.NetVision.net.il");
		msg->header->To = get_address(buf, ADDR_IGNORE_COMMAS);
		update_message_text(msg, "unsubscribe xfmail\n");
		if ((send_message(msg) == -1))
			display_msg(MSG_WARN, "unsubscribe", "Failed to send message to Majordomo@Burka.NetVision.net.il");
		else
			fl_show_message("MAILING LIST", "Unsubscribe request sent to", "Majordomo@Burka.NetVision.net.il");
		refresh_folders();
	break;

	case 6:
		helpchapter(33);
	break;

	default:
	break;
		}
    fl_activate_form(main_form);
}

void
cb_menu_file(FL_OBJECT *obj, long arg)
{
int	num;
const char *fname;
FILE *afd;

	if (obj)
		num=fl_get_menu(obj);
	else
		num = arg;

	switch(num) {
		case 1:
			b_savecfg(0);
			save_book();
			save_rules();
			save_folders_conf(NULL, F_MH|F_MBOX);
			if (imap_isconnected())
				save_folders_conf("imap", F_IMAP);
		break;

		case 2:
			if (!current_message)
				break;
			fl_set_fselector_title("Choose file to append");
			if (!(fname = fl_show_file_selector("Save as","","","message")))
				break;

			if (!(afd = fopen(fname, "a"))) {
				display_msg(MSG_WARN, "add", "Can not open %s", fname);
				break; }

			current_message->print(current_message, afd, 0);
			fclose(afd);
		break;

		case 3:
				clean_exit(0);
		break;

		default:

		break;
	}
}

void
cb_button_save(FL_OBJECT *obj, long arg)
{
int header;
FILE *ffd;
const char *fname;

 if (!current_message)
	return;

 if (fl_get_button_numb(obj) == 3)
	header = 1;
 else
	header = 0;

 fl_set_fselector_title("Choose file to save as");
 if (!(fname = fl_show_file_selector(header ? "Save message with header as" : "Save message as","","","message")))
	return;

 if ((ffd = fopen(fname, "a+")) == NULL) {
	display_msg(MSG_WARN, "save", "Can not open %s", fname);
	return;
					}

 if (header)
	(*current_message->print)(current_message, ffd, 0);
 else
	(*current_message->print_body)(current_message, ffd);

 fclose(ffd);

 return;
}

void
cb_button_abort(FL_OBJECT *obj, long arg)
{
 abortbutton = 1;
}

int
abortpressed()
{
 my_check_forms2();
 if (abortbutton) {
	abortbutton = 0;
	return 1; }

 return 0;
}

int
x11error_handle(display, event)
Display *display;
XErrorEvent *event;
{
char errbuf[255] = "";

 XGetErrorText(display, event->error_code, errbuf, sizeof(errbuf) - 1);
 if (!xfcompose)
	save_folders_conf(NULL, F_MH|F_MBOX);
 close_procs();
 save_book();
 close_abook(NULL, NULL);
 cb_msg_autosave(NULL, 0);
 b_savecfg(0);
 log_close_fd();

 display_msg(MSG_STDERR,*errbuf ? errbuf : "Non-fatal X11 error occured", "Report the bug with all the relevant information using the \"Bug report\" facility");

 return 0;
}

int
x11ioerror_handle(display)
Display *display;
{
 if (!xfcompose)
	save_folders_conf(NULL, F_MH|F_MBOX);
 close_procs();
 save_book();
 close_abook(NULL, NULL);
 cb_msg_autosave(NULL, 0);
 b_savecfg(0);
 log_close_fd();

 display_msg(MSG_STDERR, "Fatal X11 error occured", "Configuration and unsaved messages has been saved, application terminated");
 abort();
 return 0;
}

void
crash_handle(s)
int s;
{
	if (!xfcompose)
		save_folders_conf(NULL, F_MH|F_MBOX);
	close_procs();
	save_book();
	close_abook(NULL, NULL);
	cb_msg_autosave(NULL, 0);
	b_savecfg(0);
	log_close_fd();

	display_msg(MSG_MSG, "The application crashed due to fatal error\nAll unfinished messages were saved", "Report the bug with all the relevant information\nusing the \"Bug report\" facility");
	abort();
}

RETSIGTYPE
clean_exit(s)
int s;
{
char buf[255];

	if (!init)
		exit(0);

	close_procs();
	save_book();
	close_abook(NULL, NULL);
	msg_form_shutdown();

	if (main_form)	{
	 if (xofft > main_form->x)
		xofft = 0;
	 if (yofft > main_form->y)
		yofft = 0;
	 sprintf(buf, "%d %d %d %d", main_form->x - xofft, main_form->y - yofft, main_form->w, main_form->h);
	 b_setcfg_flags("placement", CF_NOTCHANGED);
	 b_putcfg_str(conf_name, "placement", buf);
	 b_setcfg_flags("sfolder", CF_NOTCHANGED);
	 b_putcfg_str(conf_name,"sfolder",get_folder_full_name(current_folder));
	 b_putcfg_int(conf_name, "logging", logging);
			}
	b_savecfg(1);

	set_cursor(main_form, XC_watch);
	my_deactivate();
	close_all_folders();
	if (b_getcfg_int(conf_name, "emptytrash", 1))
	  empty_trash_folders();

	if (!xfcompose)
		save_folders_conf(NULL, F_MH|F_MBOX);
	set_cursor(main_form, 0);
	imap_close(1);
	discard_all_folders();
	if (main_form)	{
	 fl_freepup(mpup);
	 fl_freepup(spup);
	 fl_hide_form(main_form);
	 fl_free_form(main_form);
			}
	log_close_fd();
	exit(0);
}

void
delete_messages()
{
int num, utitle, i;
struct _mail_msg *msg;

		if (!current_folder || !current_folder->messages)
			return;

		if (busy)
			return;

		busy = 1;

		my_deactivate();
		set_cursor(main_form, XC_watch);
		utitle = 0;
	   	for (num = 1;num <= fl_get_browser_maxline(b_messages); num++)   {
			if (fl_isselected_browser_line(b_messages, num)) {
			if ((msg = get_msg_by_index(current_folder, num - 1)))
				{
			if (msg == current_message)
				current_message = msg->next;

			if (!(msg->status & LOCKED) &&
				!(msg->status & MNOTEXISTS)) {
			  if ((msg->status & DELETED) ||
				(msg->status & DELPERM)) {
				msg->status &= ~DELETED;
				msg->status &= ~DELPERM; }
			  else
				msg->status |= DELETED;
			  if (msg->flags & UNREAD)
				utitle = 1;
						    	  }
				}
								          }
									    }
		current_folder->update(current_folder);
		redraw_fld_line(current_folder);
		for( i = 0; i < folders_num; i++) 	{
		 if (mailbox[i]->status & FSKIP)
			continue;
		 if (mailbox[i]->status & NOTRASH)
			redraw_fld_line(mailbox[i]);    }

		if (current_message == NULL) 	{
			current_message = get_msg_by_index(current_folder, current_index);
			if (current_message == NULL) 	{
				current_message = current_folder->messages;
				current_index = 0;
							}
						}

		restore_msg_win();

		if (utitle)
			update_title();
		set_cursor(main_form, 0);
		my_activate();
		busy = 0;

		return;
}

struct _mail_msg *
move_message_byrule(msg)
	struct _mail_msg	*msg;
{
struct _mail_folder		*old_folder;
int ind, i;

	if (!msg || msg->status & LOCKED)
		return msg;

	i = (msg == current_message) ? 1 : 0;
	ind = get_msg_index(msg->folder, msg);

	old_folder = msg->folder;

	msg->status |= NOTINCOMING;
	if (apply_rule(msg, 0) == -1) 	{
		msg->status &= ~NOTINCOMING;
		return msg;		}

	msg = get_msg_by_index(old_folder, ind);
	if (i) 	{
		current_message = msg;
		current_index = msg ? ind : 0;
		}

	refresh_folders();

	return msg;
}

struct _mail_msg *
move_message(msg, fld)
	struct _mail_msg	*msg;
	struct _mail_folder	*fld;
{
struct _mail_folder		*old_folder;
int ind, i;

	if (!msg)
		return msg;

	i = (msg == current_message) ? 1 : 0;

	if (!(msg->status & LOCKED) &&
		!(msg->status & MNOTEXISTS)) {

		ind = get_msg_index(msg->folder, msg);

		old_folder = msg->folder;

		if (!fld)
			fld = choose_folder();

		if (!fld)
			return msg;

		if (fld == old_folder)
			return msg;

		fld->move(msg, fld);
		if ((fld->status & NOTRASH) || (old_folder->status & NOTRASH))
			update_title();

		msg = get_msg_by_index(old_folder, ind);
		while (msg &&
		        ((msg->status & MOVED) ||
			(msg->status & DELETED) ||
			(msg->status & DELPERM) ||
			(msg->status & LOCKED)) )
			msg = msg->next;
		if ((old_folder == current_folder) && i) {
			current_message = msg;
			current_index = msg ? ind : 0;
							  }

		redraw_fld_line(old_folder);
		redraw_fld_line(fld);
		if ((current_folder == fld) || (current_folder == old_folder))
			restore_msg_win();
	}
	return msg;
}

void
copy_messages(fld)
struct _mail_folder *fld;
{
int num;
struct _mail_msg *msg;

   if (!current_folder)
	return;

   if (busy)
	return;

   busy = 1;

   set_cursor(main_form, XC_watch);
   my_deactivate();	

   for (num = 1;num <= fl_get_browser_maxline(b_messages); num++)
    {
	if (fl_isselected_browser_line(b_messages, num)) {
	 if ((msg = get_msg_by_index(current_folder, num - 1)))
		{
		if (!fld) {
			fld = choose_folder();
			if (!fld) 	  {
	  			  my_activate();	
	  			  set_cursor(main_form, 0);
	  			  busy = 0;
				  return; }
			  }
		msg->status |= COPIED;
		msg->folder = fld;
		}
							   }
   }
   current_folder->update(current_folder);
   redraw_fld_line(current_folder);
   if (fld)
	redraw_fld_line(fld);
   my_activate();
   if (fld == current_folder)
	redraw_msg_win();
   update_title();
   set_cursor(main_form, 0);
   busy = 0;
}

void
move_messages(fld)
struct _mail_folder *fld;
{
int num, utitle;
struct _mail_msg *msg;

		   if (!current_folder)
			return;

		   if (fld && fld->status & FRONLY)
			return;

		   if (busy)
			return;
		   busy = 1;

		   utitle = 0;
		   set_cursor(main_form, XC_watch);
		   my_deactivate();	
		   for (num = 1;num <= fl_get_browser_maxline(b_messages); num++) {
			if (fl_isselected_browser_line(b_messages, num)) {
			if ((msg = get_msg_by_index(current_folder, num - 1)))
				{
				if ((msg->status & LOCKED) ||
					(msg->status & MNOTEXISTS) ||
					(msg->folder->status & FRONLY))
					continue;

				if (msg->flags & UNREAD)
					utitle = 1;

				if (!fld) {
					fld = choose_folder();
					fl_check_only_forms();
					if (!fld || (fld->status & FRONLY)) {
					  my_activate();
		   			  set_cursor(main_form, 0);
		   			  busy = 0;
					  return;			    }
					  }

				if (current_message == msg)
					current_message = NULL;

				msg->status |= MOVED;
				msg->folder = fld;
				}
								      }
									    }
		   current_folder->update(current_folder);
		   redraw_fld_line(current_folder);
		   if (fld)
			redraw_fld_line(fld);
		   if (current_message == NULL) {
			current_message = get_msg_by_index(current_folder, current_index);
			if (current_message == NULL) {
				current_message = current_folder->messages;					current_index = 0;
						     }
						}

		   restore_msg_win();	

		   if (utitle)
			update_title();
		   my_activate();
		   set_cursor(main_form, 0);
		   busy = 0;
}

void
update_title()
{
static int pres = -1;
int res, i;
char name[64];

	if (!main_form)
		return;

	res = 0;
	for ( i = 0; i < folders_num; i++) {
	   if (mailbox[i] &&
		!(mailbox[i]->status & NOTRASH) &&
		!(mailbox[i]->flags & FNCOUNT))
	    res += mailbox[i]->unread_num;
					    }

	if (res == pres)
		return;

	if (res) {
		sprintf(name, "%d unread (XFMail)", res);
		if (pres) {
			fl_set_form_title(main_form, name);
			XSetIconName(fl_display, main_form->window, name);
			  }
		else
			set_main_icon(1, name);
		}
	else	
		set_main_icon(0, "XFMail");

	pres = res;
	return;
}

void
new_mail_notify()
{
struct _proc_info pinfo;
#ifdef	USE_SOUND
char *p;
#endif

 switch(b_getcfg_int(conf_name, "beep", 1)) {
  case 1:
	fl_ringbell(100);
  break;

#ifdef	USE_SOUND
  case 2:
	p = b_getcfg_str(conf_name, "play", "");
	if (p && strlen(p)) {
	    if (play_sound(p, 100) == -1)
		fl_ringbell(100);
		            }
  break;

  case 3:
	init_pinfo(&pinfo);
	p = b_getcfg_str(conf_name, "play", "");
	if (p && *p) {
	    if (exec_child(p, &pinfo) == -1)
		fl_ringbell(100);
	             }
  break;
#endif	/* USE_SOUND */
						}
}

void
get_new_mail(local_only)
int local_only;
{
static int retrieving = 0;
int i, res, spoolres, popres, imapres, notify;
char spool[255];

	notify = 0;
	res = 0;
	spoolres = 0;
	popres = 0;
	imapres = 0;

	if (busy ||
		main_form->deactivated ||
		retrieving)	{
		fl_set_timer(inc_timer, b_getcfg_int(conf_name,"inctime",180));
		return;		}

	if ((supress_errors == 1) && is_iconized())
		goto m_count;
			
	my_deactivate();
	busy = 1;
	retrieving = 1;
	set_cursor(main_form, XC_watch);
	sprintf(spool, "%s/%s", _PATH_MAILDIR, user_n);
	if (b_getcfg_int(conf_name, "spoolretr", 1)) {
	strcpy(spool, b_getcfg_str(conf_name, "spool", spool));
	if ((spoolres=mbox_inc_mail(spool, 
	 !b_getcfg_int(conf_name, "spoolnotrunc", 0),
	 &notify)) < 0)       {
		display_msg(MSG_WARN, "inc", "Failed to retrieve mail from spool file");
		spoolres = 0; }
	res += spoolres;
							}

	if (local_only)
		goto endretr;

	if (b_getcfg_int(conf_name, "popretr", 0)) {
	 if ((popres = pop_inc(&notify)) < 0)
		popres = 0;
	 res += popres;
						   }

	if (b_getcfg_int(conf_name, "imapretr", 0)) {
	 if ((imapres = imap_inc(&notify)) < 0)
		imapres = 0;
	 res += imapres;
						    }

	for (i = 0; i< folders_num;i++) {
	  if (mailbox[i]->status & FSKIP)
		continue;
	  if ((mailbox[i]->status & OPENED) ||
		(mailbox[i]->flags & FCHECK)) 	{
	     if (mailbox[i]->refresh(mailbox[i]) > 0)	{
			redraw_fld(mailbox[i]);
			notify = 1;			}
						}
					}

	if (!res && notify)	{
		new_mail_notify();
		my_activate();
		goto m_count;	}

endretr:
	if (current_folder)
		current_folder->update(current_folder);
	my_activate();
	if (res) {
		current_message = get_msg_by_index(current_folder, current_index);
		save_book();
		refresh_folders();
		redraw_fld_win();
		restore_msg_win();
		if (notify)
			new_mail_notify();
		if (res && notify &&
		    b_getcfg_int(conf_name, "incresults", 1))
		 display_msg(MSG_MSG, "New mail received", "%d total\n(%d - spool %d - POP %d - IMAP)", res, spoolres, popres, imapres);
		else
		 display_msg(MSG_LOG, "new mail", "%d total (%d - spool %d - POP %d - IMAP)", res, spoolres, popres, imapres);
		}
	else
		refresh_folders();

m_count:
	update_title();

	fl_set_timer(inc_timer, b_getcfg_int(conf_name,"inctime",180));
	set_cursor(main_form, 0);
	busy = 0;
	retrieving = 0;

	return;
}

void
cb_menu_messages(FL_OBJECT *obj, long arg)
{
int num, i;
struct _mail_msg *msg;
	
	if (arg == 0)
		num=fl_get_menu(obj);
	else
		num = arg;

	switch(num) {
		case 1:		/* View */
			view_msg(current_message, 1);
		break;

		case 2:		/* Edit */
			edit_msg(current_message);
			redraw_fld_line(current_folder);
			redraw_msg(current_message);
		break;

		case 3:		/* Delete */
			delete_messages();
		break;

		case 4:		/* Move */
			move_messages(NULL);
		break;

		case 5:		/* Copy */
			copy_messages(NULL);
		break;

		case 6:		/* Mark */
	   	for (num = 1;num <= fl_get_browser_maxline(b_messages); num++)
			{
			if (fl_isselected_browser_line(b_messages, num)) 
			 {
			  if ((msg = get_msg_by_index(current_folder, num - 1)))
			  {
			    if (!(msg->status & LOCKED))
				msg->flags |= MARKED;
			  }
			 }
			}

		current_folder->update(current_folder);
		restore_msg_win();
		break;

		case 7:		/* Unmark */
	   	for (num = 1;num <= fl_get_browser_maxline(b_messages); num++)
			{
			if (fl_isselected_browser_line(b_messages, num)) 
			 {
			  if ((msg = get_msg_by_index(current_folder, num - 1)))
			   {
			    if (!(msg->status & LOCKED)) {
				msg->flags &= ~MARKED;
				msg->status &= ~MARKTMP; }
			   }
			 }
			}

		current_folder->update(current_folder);
		restore_msg_win();
		break;

		case 8:		/* Mark Read/Unread */
	   	for (num = 1;num <= fl_get_browser_maxline(b_messages); num++)
			{
			if (fl_isselected_browser_line(b_messages, num)) 
			 {
			  if ((msg = get_msg_by_index(current_folder, num - 1))
				&& !(msg->status & LOCKED)) {
			    if  (msg->flags & UNREAD) {
			  	msg->flags &= ~UNREAD;
			        if (msg->folder->unread_num)
				  msg->folder->unread_num--;
				} else 	{
			  	msg->flags |= UNREAD;
			  	msg->folder->unread_num++;
					}
							   }
			 }
			}

		current_folder->update(current_folder);
		restore_msg_win();
		redraw_fld_line(current_folder);
		update_title();
		break;

		case 9:		/* Print */
			set_cursor(main_form, XC_watch);
			my_deactivate();
			lpr_message(current_message);
			my_activate();
			set_cursor(main_form, 0);
		break;

		case 10:	/* Bounce (resend) */
			if (!current_message)
				break;

			current_message->status |= LOCKED;
			if (!(msg = outbox->copy(current_message, outbox))) {
				display_msg(MSG_WARN, "bounce", "Can not copy message");
				current_message->status &= ~LOCKED;
				break;					    }
			current_message->status &= ~LOCKED;
			msg->status &= ~LOCKED;
			msg->status |= MSGNEW;

			msg->get_header(msg);
			add_field(msg, BOUNCE_ORGMSG, get_msg_url(current_message));
			discard_address(msg->header->To);
			discard_address(msg->header->Cc);
			discard_address(msg->header->Bcc);
			msg->header->To = NULL;
			msg->header->Cc = NULL;
			msg->header->Bcc = NULL;
			msg->status |= CHANGED;
			msg->update(msg);

			edit_msg(msg);
			redraw_fld_line(outbox);
			refresh_folders();
		break;

		case 11:	/* Apply rules */
		set_cursor(main_form, XC_watch);
		my_deactivate();
	   	for (num = 1;num <= fl_get_browser_maxline(b_messages); num++)
			{
			if (fl_isselected_browser_line(b_messages, num)) 
			 {
			  if ((msg = get_msg_by_index(current_folder, num - 1)))
				{
				if (!(msg->status & LOCKED) &&
					!(msg->status & MNOTEXISTS))
					apply_rule(msg, 1);
				}
			 }
			}

		current_folder->update(current_folder);
		my_activate();
		refresh_folders();
		set_cursor(main_form, 0);
		break;

		case 12:	/* Select all */
		fl_freeze_form(main_form);
	   	for (num = 1;num <= fl_get_browser_maxline(b_messages); num++)
			fl_select_browser_line(b_messages, num);
		fl_unfreeze_form(main_form);
		break;

		case 13:	/* Select marked */
		fl_freeze_form(main_form);
	   	for (num = 1;num <= fl_get_browser_maxline(b_messages); num++)
		  if ((msg = get_msg_by_index(current_folder, num - 1)) &&
			((msg->flags & MARKED)||(msg->status & MARKTMP)))
			fl_select_browser_line(b_messages, num);
		  else
			fl_deselect_browser_line(b_messages, num);
		fl_unfreeze_form(main_form);
		break;

		case 14:	/* Delete from POP server */
		if (current_message == NULL)
			break;
		set_cursor(main_form, XC_watch);
		my_deactivate();
		if (pop_init() == -1) {
			set_cursor(main_form, 0);
			my_activate();
			break;		}

		i = 0;
	   	for (num = 1;num <= fl_get_browser_maxline(b_messages); num++)
			{
			if (abortpressed())
				break;

			if (fl_isselected_browser_line(b_messages, num)) 
			 {
			  if ((msg = get_msg_by_index(current_folder, num - 1)))
				{
				fl_check_only_forms();
				if (pop_delmsg_by_uidl(msg) != -1) {
					i++;
					redraw_msg(msg);
								   }
				}
			 }
			}

		if (i)
		  display_msg(MSG_MSG, "POP", "Deleted %d messages from POP server", i);
		else
		  display_msg(MSG_WARN, "POP", "No messages were deleted");

		my_activate();
		set_cursor(main_form, 0);
		pop_end();

		break;

		case 15:	/* Refresh */
		set_cursor(main_form, XC_watch);
		my_deactivate();
	   	for (num = 1;num <= fl_get_browser_maxline(b_messages); num++)
			{
			if (fl_isselected_browser_line(b_messages, num)) 
			 {
			  if ((msg = get_msg_by_index(current_folder, num - 1)))
				{
				msg->refresh(msg);
				redraw_msg(msg);
				}
			 }
			}

		my_activate();
		set_cursor(main_form, 0);
		break;

		case 16:	/* Options */
		if (current_message == NULL)
			break;
		set_cursor(main_form, XC_watch);
		my_deactivate();
		message_conf(current_message);
		my_activate();
		set_cursor(main_form, 0);
		break;

		case 17:	/* Pipe */
		if (current_message == NULL)
			break;
		pipe_msg(current_message,(char *)fl_show_input("Pipe to:", ""));
		break;

		default:
		break;
		    }
}

int
is_iconized()
{
XWindowAttributes xattr;

   if (!main_form)
	return 1;

   if (b_getcfg_int(conf_name, "incwhenicon", 1)) {
	xattr.map_state = IsUnmapped;
	if (XGetWindowAttributes(fl_display, main_form->window, &xattr))
		{
	 	if (xattr.map_state != IsUnmapped) 
			return 1;
		}
						  		    }

   return 0;
}

void
send_all()
{
struct _mail_msg *msg;
int offl, opened;

   fl_set_timer(send_timer, b_getcfg_int(conf_name,"sendtime",0));

   if (busy || main_form->deactivated)
	return;

   if (supress_errors && is_iconized())
	return;

   busy = 1;
   offl = offline;
   offline = 0;
   opened = 0;

   if (!(outbox->status & OPENED)) {
	if (outbox->open(outbox, 0) == -1)
		{
		display_msg(MSG_WARN, "send all", "Can not open %s", OUTBOX);
   		offline = offl;
   		busy = 0;
		return;
		}
	else
		opened = 1;
				}

  set_cursor(main_form, XC_watch);
  my_deactivate();

  msg = outbox->messages;
  while(msg) {
	msg->flags |= NOT_SENT;
	msg = msg->next;
	}

  outbox->update(outbox);

  if (opened)
	outbox->close(outbox);

  my_activate();
  set_cursor(main_form, 0);

  offline = offl;
  refresh_folders();

  busy = 0;
  return;
}

void
cb_menu_send(FL_OBJECT *obj, long arg)
{
struct _mail_msg *msg;
int	num;

	if (arg == 0)
		num=fl_get_menu(obj);
	else
		num = arg;

	my_deactivate();
	switch(num) {
		case 1:
			set_cursor(main_form, XC_watch);
			msg = create_message(outbox);
			if (current_folder && current_folder->From)	{
				discard_address(msg->header->From);
				msg->header->From = copy_address(current_folder->From);
									}

			edit_msg(msg);
			refresh_folders();
			set_cursor(main_form, 0);
		break;

		case 2:
			set_cursor(main_form, XC_watch);
			edit_msg(get_reply_msg(current_message, NULL, 0));
			refresh_folders();
			redraw_msg(current_message);
			set_cursor(main_form, 0);
		break;

		case 3:
			set_cursor(main_form, XC_watch);
			edit_msg(get_reply_msg(current_message, NULL, 2));
			refresh_folders();
			redraw_msg(current_message);
			set_cursor(main_form, 0);
		break;

		case 4:
			set_cursor(main_form, XC_watch);
			edit_msg(get_fwd_msg(current_message));
			refresh_folders();
			redraw_msg(current_message);
			set_cursor(main_form, 0);
		break;

		case 5:
			send_all();
		break;

		default:
		break;
		  }
	my_activate();
}

void
cb_menu_folders(FL_OBJECT *obj, long arg)
{
int	num,res, i, opened;
char	*str, *p;
struct _mail_folder *fld, *ofld;
struct _mail_msg *msg;
char oldname[MAX_FOLD_NAME_LEN];

	if (busy)
		return;

	busy = 1;
	
	if (arg == 0)
		num = fl_get_menu(obj);
	else
		num = arg;

	switch(num) {
		case 1:
			set_cursor(main_form, XC_watch);
			my_deactivate();
			fld = create_folder(NULL, 0);
			redraw_fld_win();
			my_activate();
			set_cursor(main_form, 0);
			break;
		case 2:
			set_cursor(main_form, XC_watch);
			my_deactivate();
			create_subfolder(chfld ? chfld : current_folder, NULL);
			redraw_fld_win();
			my_activate();
			set_cursor(main_form, 0);
			break;
		case 3:
			fld = chfld ? chfld : current_folder;

			res=display_msg(MSG_QUEST|MSG_DEFNO, "WARNING", "Folder %s with all messages will be deleted", current_folder->name(fld));
			if (res) {
				set_cursor(main_form, XC_watch);
				my_deactivate();
				if (fld == current_folder)
				{
				 if (fld->delete(fld) == 0) {
				  current_folder = inbox;
				  current_message = inbox->messages;
				  current_index = 0;
				  current_folder->open(current_folder, 0);
				  mark_to_us(current_folder);
							    }
				}
				else
				    fld->delete(fld);
				my_activate();
				set_cursor(main_form, 0);
				redraw_folders();
			}
			save_folders_conf(NULL, F_MH|F_MBOX);
			break;
		case 4:
			fld = chfld ? chfld : current_folder;
			str = (char *)fl_show_input("Enter new name:",fld->sname);

			if (!str || !*str) {
				busy = 0;
				break;     }

			fl_deactivate_all_forms();
			p = str;
			while (*p != '\0') {
			  if (!isgraph(*p)) {
				display_msg(MSG_WARN, "rename", "Illegal character in folder name");
				fl_activate_all_forms();
				busy = 0;
				break;
					    }
			  p++;	
					   }

			strcpy(oldname, get_folder_full_name(fld));
			if (fld->rename(fld, str) == -1) {
				display_msg(MSG_WARN, "rename", "Can not rename folder %s to %s", fld->sname, str);
				fl_activate_all_forms();
				break;	}

			rule_rename_folder(fld, oldname);
			redraw_fld_win();
			fl_activate_all_forms();
			save_folders_conf(NULL, F_MH|F_MBOX);
			break;

		case 5:
			set_cursor(main_form, XC_watch);
			my_deactivate();

			fld = chfld ? chfld : choose_folder();

			if (!fld) {
				my_activate();
				set_cursor(main_form, 0);
				break;
				  }

			current_folder->close(current_folder);
			ofld = current_folder;

			if (fld->open(fld, 0) == -1)    {
				display_msg(MSG_WARN, "OPEN", "Can not open folder");
				my_activate();
				set_cursor(main_form, 0);
				break;			}

			current_folder = fld;
			current_message = current_folder->messages;
			current_index = 0; 
			mark_to_us(current_folder);
			redraw_fld_line(current_folder); 
			redraw_fld_line(ofld); 
			redraw_msg_win();

			my_activate();
			set_cursor(main_form, 0);

			break;

		case 6:
			set_cursor(main_form, XC_watch);
			my_deactivate();

			fld = chfld ? chfld : choose_folder();

			if (!fld) {
				my_activate();
				set_cursor(main_form, 0);
				break;
				  }

			current_folder->close(current_folder);
			ofld = current_folder;

			if (fld->open(fld, FOPEN_UNREAD) == -1)    {
				display_msg(MSG_WARN, "OPEN", "Can not open folder");
				my_activate();
				set_cursor(main_form, 0);
				break;				   }

			current_folder = fld;
			current_message = current_folder->messages;
			current_index = 0; 
			mark_to_us(current_folder);
			redraw_fld_line(current_folder); 
			redraw_fld_line(ofld);
			redraw_msg_win();

			my_activate();
			set_cursor(main_form, 0);

			break;

		case 7:
			set_cursor(main_form, XC_watch);
			my_deactivate();
			empty_trash_folders();
			my_activate();
			set_cursor(main_form, 0);
			display_fld_status(current_folder);
			break;

		case 8:
			set_cursor(main_form, XC_watch);
			my_deactivate();
			fld = chfld ? chfld : current_folder;
			opened = 0;
			if (!(fld->status & OPENED)) {
			  fld->open(fld, FOPEN_UNREAD);
			  opened = 1;		     }

			msg = fld->messages;
			while (msg) {
			   if (msg->flags & UNREAD) {
				msg->flags &= ~UNREAD;
				if (fld->unread_num)
					fld->unread_num--;
				msg->update(msg);
						   }
				msg = msg->next;
				    }

			redraw_fld(fld);
			if (opened)
				fld->close(fld);
			set_cursor(main_form, 0);
			my_activate();
			update_title();
			break;

		case 9:
			search_msgs();
			break;

		case 10:
			set_cursor(main_form, XC_watch);
			my_deactivate();
			for (i = 0; i< folders_num;i++) {
			   if (abortpressed())
				break;

			   if ((mailbox[i] != NULL) && (mailbox[i] != current_folder)) {
				display_msg(MSG_STAT, NULL, "Rescanning %s", mailbox[i]->name(mailbox[i]));
				if (mailbox[i]->rescan(mailbox[i]) == -1)
					break;
	}
							}
			redraw_folders();
			update_title();
			my_activate();
			set_cursor(main_form, 0);
			break;

		case 11:
			fl_deactivate_all_forms();
			folder_conf(chfld ? chfld : current_folder);
			fl_activate_all_forms();
			break;

		case 12:
			expand_collapse_tree(chfld ? chfld : current_folder, 1);
			restore_fld_win();
			break;

		case 13:
			fld = chfld ? chfld : current_folder;
			if (!fld || (fld->type != F_IMAP) ||
			    !display_msg(MSG_QUEST, "EXPUNGE", "Are you sure?"))
				break;
			imap_folder_expunge(fld);
			remove_nonexistent(fld);
			if (fld == current_folder)
				current_message = current_folder->messages;
			redraw_fld(fld);
			update_title();
			break;

		default:
			break;
	}

	busy = 0;
}

void
cb_button_edit(FL_OBJECT *obj, long arg)
{
	edit_msg(current_message);
	refresh_folders();
}

void
cb_button_exit(FL_OBJECT *obj, long arg)
{
	if (b_getcfg_int(conf_name, "cexit", 0) &&
		!display_msg(MSG_QUEST, "EXIT", "Are you sure?"))
		return;

	clean_exit(0);
}

void
cb_button_newmail(FL_OBJECT *obj, long arg)
{
struct _mail_msg *msg;

	msg = create_message(outbox);
	if (current_folder && current_folder->From)	{
		discard_address(msg->header->From);
		msg->header->From = copy_address(current_folder->From);
							}
	edit_msg(msg);
	refresh_folders();
}

void
cb_button_print(FL_OBJECT *obj, long arg)
{
	set_cursor(main_form, XC_watch);
	lpr_message(current_message);
	set_cursor(main_form, 0);
}

void
cb_button_view(FL_OBJECT *obj, long arg)
{
	view_msg(current_message, 1);
}

void
cb_button_reply(FL_OBJECT *obj, long arg)
{
	set_cursor(main_form, XC_watch);
	my_deactivate();
	if (fl_get_button_numb(obj) == 3)
	 edit_msg(get_reply_msg(current_message, NULL, 0));
	else
	 edit_msg(get_reply_msg(current_message, NULL, 1));
	refresh_folders();
	redraw_msg(current_message);
	my_activate();
	set_cursor(main_form, 0);
}

void
cb_button_forward(FL_OBJECT *obj, long arg)
{
	set_cursor(main_form, XC_watch);
	my_deactivate();
	edit_msg(get_fwd_msg(current_message));
	redraw_msg(current_message);
	refresh_folders();
	my_activate();
	set_cursor(main_form, 0);
}

void
cb_button_move(FL_OBJECT *obj, long arg)
{
struct _mail_folder *fld;

	if (fl_get_button_numb(obj) == 3) {
		if ((fld = pup_choose_folder(main_form)) == NULL)
			return;
					  }
	else
		fld = NULL;

	move_messages(fld);
}

void
cb_button_retr(FL_OBJECT *obj, long arg)
{
   if (fl_get_button_numb(obj) == 3)
	get_new_mail(1);
   else
	get_new_mail(0);
}

void
cb_button_delete(FL_OBJECT *obj, long arg)
{
 if (fl_get_button_numb(obj) != 3)
  delete_messages();
 else	{
  if (!current_folder || (current_folder->type != F_IMAP) ||
    !display_msg(MSG_QUEST, "EXPUNGE", "Are you sure?"))
	return;
  imap_folder_expunge(current_folder);
  remove_nonexistent(current_folder);
  current_message = current_folder->messages;
  redraw_fld(current_folder);
  update_title();
	}
}

void
cb_button_send(FL_OBJECT *obj, long arg)
{
int num, offl;
struct _mail_msg *msg;
int answer;

	if (!current_folder)
		return;

	if (busy)
		return;

	answer = 0;

	offl = offline;
	if (current_folder == outbox)
		offline = 0;

	set_cursor(main_form, XC_watch);
	for (num = 1;num <= fl_get_browser_maxline(b_messages); num++)   {
	  if (fl_isselected_browser_line(b_messages, num)) {

		if (!answer && !display_msg(MSG_QUEST, "Send", "Are you sure you want to send selected message(s)?")) 	{
		   set_cursor(main_form, 0);
		   offline = offl;
		   return;		}

		answer = 1;

		if ((msg = get_msg_by_index(current_folder, num - 1)))
			msg->flags |= NOT_SENT;
		else
			continue;

		if ((msg->status & LOCKED) ||
			(msg->status & MNOTEXISTS))
			continue;

							   }
									 }

	current_folder->update(current_folder);
	current_message = current_folder->messages;
	current_index = 0;
	offline = offl;
	refresh_folders();
	set_cursor(main_form,0);
	return;
}

void
cb_timer(FL_OBJECT *obj, long arg)
{
if (supress_errors)
	return;
supress_errors = 1;
get_new_mail(0);
supress_errors = 0;
}

void
cb_send_timer(FL_OBJECT *obj, long arg)
{
if (supress_errors)
	return;
supress_errors = 1;
send_all();
supress_errors = 0;
}

void
empty_trash_folders()
{
int i;

  for( i = 0; i < folders_num; i++)      {
    if (mailbox[i]->status & NOTRASH) {
     mailbox[i]->empty(mailbox[i]);
     if (mailbox[i]->num_msg)
	display_msg(MSG_WARN, "Empty Trash", "Can not empty %s",
		mailbox[i]->name(mailbox[i]));
     redraw_fld_line(mailbox[i]);
     if (current_folder == mailbox[i])  {
	current_index = 0;
	current_message = NULL;
	redraw_msg_win();		}
				     }
					 }
}

void
cb_imap_timer(FL_OBJECT *obj, long arg)
{
if (busy || main_form->deactivated || supress_errors)	{
	fl_set_timer(imap_timer, b_getcfg_int(conf_name, "imaptime", 600));
	return;						}

busy = 1;
my_deactivate();
imap_timer_cb();
my_activate();
if (current_folder && (current_folder->type == F_IMAP) &&
	(current_folder->status & FRESCAN))	{
	current_message = current_folder->messages;
	current_index = 0;
	redraw_fld(current_folder);		}
busy = 0;
}

void
cb_trash_timer(FL_OBJECT *obj, long arg)
{
fl_set_timer(obj, b_getcfg_int(conf_name,"trashtime",0) * 60);
if (busy || main_form->deactivated)
	return;

if (is_iconized())
	return;

if (supress_errors)
	return;

supress_errors = 1;
busy = 1;
my_deactivate();
empty_trash_folders();
my_activate();
busy = 0;
supress_errors = 0;
fl_set_timer(obj, b_getcfg_int(conf_name,"trashtime",0) * 60);
}

void
select_found()
{
struct _mail_msg *msg;

 fl_freeze_form(main_form);
 fl_deselect_browser(b_messages);
 msg = current_folder->messages;
 while (msg)            {
  if (msg->status & MARKTMP)
        fl_select_browser_line(b_messages, get_msg_index(current_folder, msg) +
1);
  msg = msg->next;      }
 fl_unfreeze_form(main_form);
}

FL_FORM *create_main_form(void)
{
  FL_OBJECT *obj;
  FL_FORM *f_mail;
  int menubox_bottom = 3;
  int menus_y_offset = menubox_bottom;
  int buttons_y_bottom = menubox_bottom + 25;
  int browserbottoms = 64;
  int browserheights = 518;

  f_mail = fl_bgn_form(FL_NO_BOX, 778, 615);
  obj = fl_add_box(FL_FLAT_BOX,0,0,778,615,"");

  obj = fl_add_browser(FL_HOLD_BROWSER,3, browserbottoms,fbrowsersize,browserheights,"");
  fl_set_object_resize(obj,FL_RESIZE_Y);
  fl_set_object_gravity(obj,NorthWestGravity,SouthGravity);
  fl_set_browser_fontsize(obj, b_getcfg_int(conf_name, "FoldersFSize", FL_NORMAL_SIZE));
  fl_set_browser_fontstyle(obj, b_getcfg_int(conf_name, "FoldersFStyle", FL_FIXEDBOLD_STYLE));
  fl_set_object_lsize(obj, b_getcfg_int(conf_name, "FoldersFSize", FL_NORMAL_SIZE));
  fl_set_object_lstyle(obj, b_getcfg_int(conf_name, "FoldersFStyle", FL_FIXEDBOLD_STYLE));
  fl_set_object_color(obj,b_getcfg_int(conf_name, "FoldersBgCol", FL_TOP_BCOL), b_getcfg_int(conf_name, "FoldersFgCol", FL_YELLOW));
  fl_set_object_callback(obj,cb_folders,0);
  fl_set_browser_dblclick_callback(obj, cb_folders_dbl, 0);
  /* fl_set_browser_hscrollbar(obj, FL_OFF); */
  obj->input = TRUE;
  b_folders=obj;

  obj = fl_add_browser(FL_MULTI_BROWSER,5 + fbrowsersize,browserbottoms,770 - fbrowsersize,browserheights,"");
  fl_set_object_resize(obj,FL_RESIZE_ALL);
  fl_set_object_gravity(obj,NorthWestGravity,SouthEastGravity);
  fl_set_browser_fontsize(obj, b_getcfg_int(conf_name, "MessagesFSize", FL_NORMAL_SIZE));
  fl_set_browser_fontstyle(obj, b_getcfg_int(conf_name, "MessagesFStyle", FL_FIXED_STYLE));
  fl_set_object_color(obj,b_getcfg_int(conf_name, "MessagesBgCol", FL_TOP_BCOL), b_getcfg_int(conf_name, "MessagesFgCol", FL_YELLOW));
  fl_set_object_callback(obj,cb_messages,0);
  fl_set_browser_dblclick_callback(obj, cb_messages_dbl, 0);
  obj->input = TRUE;
  b_messages=obj;

  obj = fl_add_button(FL_HIDDEN_BUTTON, 3 + fbrowsersize, browserbottoms, 2, browserheights, "");
  fl_set_object_resize(obj,FL_RESIZE_Y);
  fl_set_object_gravity(obj,NorthWestGravity,SouthGravity);
  fl_set_object_callback(obj,cb_fbutton,0);
  fl_set_object_posthandler(obj, cb_fbutton_handler);
  f_button = obj;

  status = obj = fl_add_text(FL_NORMAL_TEXT,3,585,772,27,"");
  fl_set_object_lsize(obj, FL_SMALL_SIZE);
  fl_set_object_resize(obj,FL_RESIZE_X);
  fl_set_object_gravity(obj,SouthWestGravity,SouthEastGravity);
  fl_set_object_boxtype(obj,FL_DOWN_BOX);
  fl_set_object_color(obj,FL_MCOL,FL_BLUE);
  fl_set_object_lcol(obj,FL_BLUE);
 
  obj = fl_add_frame(FL_UP_FRAME,3,menubox_bottom,772,20,"");

  fl_set_object_resize(obj,FL_RESIZE_X);
  fl_set_object_gravity(obj,NorthWestGravity,0);

  obj = fl_add_menu(FL_PULLDOWN_MENU,10,menus_y_offset,30,20,"File");
    menu_file=obj;
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT);
    fl_set_menu(obj,"Save options|Save to File (Alt+S)|Exit (Alt+X)");
    fl_set_object_callback(obj,cb_menu_file,0);
    fl_set_object_shortcut(obj, "#L", 1);

    fl_set_menu_item_shortcut(obj, 1, "Oo#o");
    fl_set_menu_item_shortcut(obj, 2, "Ss#s");
    fl_set_menu_item_shortcut(obj, 2, "Xx#x");

  fl_set_object_resize(obj,FL_RESIZE_NONE);
  fl_set_object_gravity(obj,NorthWestGravity,0);

  obj = fl_add_menu(FL_PULLDOWN_MENU,50,menus_y_offset,70,20,"Message");
    menu_message=obj;
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_menu(obj,MESG_MENU);
    fl_set_object_callback(obj,cb_menu_messages,0);
    fl_set_object_shortcut(obj, "#G", 1);

    fl_set_menu_item_shortcut(obj, 1, "Vv#v");
    fl_set_menu_item_shortcut(obj, 2, "Ee#e");
    fl_set_menu_item_shortcut(obj, 3, "Dd#d");
    fl_set_menu_item_shortcut(obj, 4, "Mm#m");
    fl_set_menu_item_shortcut(obj, 5, "Cc#c");
    fl_set_menu_item_shortcut(obj, 6, "Rr#r");
    fl_set_menu_item_shortcut(obj, 7, "Uu#u");
    fl_set_menu_item_shortcut(obj, 8, "Kk#k");
    fl_set_menu_item_shortcut(obj, 9, "Pp#p");
    fl_set_menu_item_shortcut(obj,10, "Bb#b");
    fl_set_menu_item_shortcut(obj,11, "Aa#a");
    fl_set_menu_item_shortcut(obj,12, "Ss#s");
    fl_set_menu_item_shortcut(obj,13, "Ll#l");
    fl_set_menu_item_shortcut(obj,14, "Tt#t");
    fl_set_menu_item_shortcut(obj,15, "Rr#r");
    fl_set_menu_item_shortcut(obj,16, "Oo#o");
    fl_set_menu_item_shortcut(obj,17, "Ii#i");

  fl_set_object_resize(obj,FL_RESIZE_NONE);
  fl_set_object_gravity(obj,NorthWestGravity,0);

  obj = fl_add_menu(FL_PULLDOWN_MENU,120,menus_y_offset,70,20,"Folder");
    menu_folders=obj;
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_menu(obj,FOLD_MENU);
    fl_set_object_callback(obj,cb_menu_folders,0);
    fl_set_object_shortcut(obj, "#O", 1);

    fl_set_menu_item_shortcut(obj, 1, "Cc#c");
    fl_set_menu_item_shortcut(obj, 2, "Ff#f");
    fl_set_menu_item_shortcut(obj, 3, "Dd#d");
    fl_set_menu_item_shortcut(obj, 4, "Rr#r");
    fl_set_menu_item_shortcut(obj, 5, "Oo#o");
    fl_set_menu_item_shortcut(obj, 6, "Pp#p");
    fl_set_menu_item_shortcut(obj, 7, "Ee#e");
    fl_set_menu_item_shortcut(obj, 8, "Uu#u");
    fl_set_menu_item_shortcut(obj, 9, "Ss#s");
    fl_set_menu_item_shortcut(obj,10, "Aa#a");
    fl_set_menu_item_shortcut(obj,11, "Tt#t");
    fl_set_menu_item_shortcut(obj,12, "Xx#x");
    fl_set_menu_item_shortcut(obj,13, "Gg#g");

  fl_set_object_resize(obj,FL_RESIZE_NONE);
  fl_set_object_gravity(obj,NorthWestGravity,0);

  obj = fl_add_menu(FL_PULLDOWN_MENU,190,menus_y_offset,40,20,"Send");
    menu_send=obj;
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_menu(obj,SEND_MENU);
    fl_set_object_callback(obj,cb_menu_send,0);

    fl_set_menu_item_shortcut(obj, 1, "Cc#c");
    fl_set_menu_item_shortcut(obj, 2, "Ss#s");
    fl_set_menu_item_shortcut(obj, 3, "Rr#r");
    fl_set_menu_item_shortcut(obj, 4, "Ff#f");
    fl_set_menu_item_shortcut(obj, 5, "Aa#a");

  fl_set_object_resize(obj,FL_RESIZE_NONE);
  fl_set_object_gravity(obj,NorthWestGravity,0);

  obj = fl_add_menu(FL_PULLDOWN_MENU,250,menus_y_offset,40,20,"Misc");
    menu_misc=obj;
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_menu(obj,"Address Book|Config Misc|Config Display|Appearance|Signature|Rules|Retrieve Mail (Alt+N)|IMAP connect|Log");
    fl_set_object_callback(obj,cb_menu_misc,0);
    fl_set_object_shortcut(obj, "#I", 1);

    fl_set_menu_item_shortcut(obj, 1, "Aa#a");
    fl_set_menu_item_shortcut(obj, 3, "Cc#c");
    fl_set_menu_item_shortcut(obj, 5, "Ss#s");
    fl_set_menu_item_shortcut(obj, 6, "Rr#r");
    fl_set_menu_item_shortcut(obj, 7, "mM#m");
    fl_set_menu_item_shortcut(obj, 9, "Ll#l");

  fl_set_object_resize(obj,FL_RESIZE_NONE);
  fl_set_object_gravity(obj,NorthWestGravity,0);

  obj = fl_add_menu(FL_PULLDOWN_MENU,725,menus_y_offset,40,20,"Help");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_lalign(obj,FL_ALIGN_RIGHT);
    fl_set_menu(obj,"Contents|About|Bug report|Subscribe to mailing list|Unsubscribe from mailing list|What's new");
    fl_set_object_callback(obj,cb_menu_help,0);

    fl_set_menu_item_shortcut(obj, 1, "Cc#c");
    fl_set_menu_item_shortcut(obj, 2, "Aa#a");
    fl_set_menu_item_shortcut(obj, 3, "Bb#b");
    fl_set_menu_item_shortcut(obj, 4, "Ss#s");
    fl_set_menu_item_shortcut(obj, 5, "Uu#u");
    fl_set_menu_item_shortcut(obj, 6, "Ww#w");

  fl_set_object_resize(obj,FL_RESIZE_NONE);
  fl_set_object_gravity(obj,NorthGravity,EastGravity);

    /*
     * Create button pad.
     */

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,20,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,exit_xpm);
  obj->u_vdata = "Exit XFMail";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_exit,0);
	fl_set_button_shortcut(obj, "^XXx#X", 0);

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,90,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,edit_xpm);
  obj->u_vdata = "Edit message";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_edit,0);
	fl_set_button_shortcut(obj, "^EEe#E", 0);

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,125,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,newmail_xpm);
  obj->u_vdata = "Compose new";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_newmail,0);
	fl_set_button_shortcut(obj, "^CCc#C", 0);

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,175,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,view_xpm);
  obj->u_vdata = "View message";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_view,0);
	fl_set_button_shortcut(obj, "^VVv#V^M ", 0);

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,210,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,print_xpm);
  obj->u_vdata = "Print message";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_print,0);
	fl_set_button_shortcut(obj, "^PPp#P", 0);

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,260,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,reply_xpm);
  obj->u_vdata = "Reply to message";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_reply,0);
	fl_set_button_shortcut(obj, "^RRr#R", 0);

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,295,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,forward_xpm);
  obj->u_vdata = "Forward message";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_forward,0);
	fl_set_button_shortcut(obj, "^FFf#F", 0);

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,345,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,move_xpm);
  obj->u_vdata = "Move to another folder";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_move,0);
	fl_set_button_shortcut(obj, "Mm#M", 0);

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,381,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,delete_xpm);
  obj->u_vdata = "Delete";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_delete,0);
	fl_set_button_shortcut(obj, "^DDd#D", 0);

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,430,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,retr_xpm);
  obj->u_vdata = "Check new mail";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_retr,0);
	fl_set_button_shortcut(obj, "^NNn#N", 0);

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,465,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,send_xpm);
  obj->u_vdata = "Send message";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_send,0);
	fl_set_button_shortcut(obj, "^KKk#K", 0);

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,515,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,save_xpm);
  obj->u_vdata = "Save message";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_save,0);
	fl_set_button_shortcut(obj, "^SSs#S", 0);

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,565,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,abort_xpm);
  obj->u_vdata = "Abort";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_button_abort,0);
	fl_set_button_shortcut(obj, "^AAa#A", 0);
  abrt = obj;

  obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,600,buttons_y_bottom,35,33,"");
  fl_set_pixmapbutton_data(obj,help_xpm);
  obj->u_vdata = "Help";
	fl_set_object_posthandler(obj, post_handler);
	fl_set_object_resize(obj,FL_RESIZE_NONE);
	fl_set_object_gravity(obj,NorthWestGravity,0);
	fl_set_object_callback(obj,cb_help_button,0);
	fl_set_button_shortcut(obj, "^HHh#H", 0);

  inc_timer = obj = fl_add_timer(FL_HIDDEN_TIMER,0,0,1,2,"");
	fl_set_object_callback(obj,cb_timer,0);

  send_timer = obj = fl_add_timer(FL_HIDDEN_TIMER,0,0,1,2,"");
	fl_set_object_callback(obj,cb_send_timer,0);

  trash_timer = obj = fl_add_timer(FL_HIDDEN_TIMER,0,0,1,2,"");
	fl_set_object_callback(obj,cb_trash_timer,0);

  imap_timer = obj = fl_add_timer(FL_HIDDEN_TIMER,0,0,1,2,"");
	fl_set_object_callback(obj,cb_imap_timer,0);

  ttip_timer = obj = fl_add_timer(FL_HIDDEN_TIMER,0,0,1,2,"");
	fl_set_object_callback(obj,cb_ttip_timer,0);

  pgp_timer = obj = fl_add_timer(FL_HIDDEN_TIMER,0,0,1,2,"");
	fl_set_object_callback(obj,PGP_Timer_Call,0);

  fl_end_form();
  return f_mail;
}

int
main_close(form, data)
FL_FORM *form;
void *data;
{
 if (form == main_form)
	clean_exit(0);

 return FL_IGNORE;
}

void
init_forms()
{
	choose_init();
	pop_account_init();
	search_init();
	log_init();
}

char *
getmyhostname()
{
char host_n[64], *p, **ha;
struct hostent *hp;
static char myname[127] = { '\0' };

if (strlen(myname) > 1)
	return myname;

if (cfg_exist("hostname")) 	{
 p = b_getcfg_str(conf_name, "hostname", "");
 if (p && strlen(p) && strchr(p, '.')) 	{
	strncpy(myname, p, 126);
	p[126] = '\0';
	return myname;			}
 b_delcfg_str(conf_name, "hostname");
				}

 if (gethostname(host_n, 63) == -1) 
	strcpy(myname, "localhost");
 else
	strcpy(myname, host_n);

 if ((hp = gethostbystring(host_n)) != NULL) {
	if (hp->h_name && strchr(hp->h_name, '.'))
	  strcpy(myname, hp->h_name);
	else	{
	  for (ha = hp->h_aliases;(ha != NULL) && (*ha != NULL); ha++)
	  {
		if (strchr(*ha, '.') != NULL)
			{
			(void)strncpy(myname, *ha, 126);
			myname[126] = '\0';
			break;
                        }
	  }
		}

	 				   }

 if (!strchr(myname, '.')) {
	display_msg(MSG_WARN, "XFMail can not determine your host's canonical name!", "Make sure that your E-Mail address in Config/Misc dialog is correct");
enhost:
	p = (char *)fl_show_input("Enter full name of your host (including domain)", myname);
	if (!p || !*p || !strchr(p, '.')) {
		display_msg(MSG_WARN, "HOST", "Invalid hostname , please reenter!");
		goto enhost;		  }

	strncpy(myname, p, 126);
	myname[126] = '\0';
	b_putcfg_str(conf_name, "hostname", myname);
			  }

 return myname;
}

void Done_Info_Call(FL_OBJECT *obj, long param)
{
char geom[16];

 if (!info_obj)
	return;

 sprintf(geom, "%d %d", info_obj->Help_Form->w, info_obj->Help_Form->h);
 b_putcfg_str(conf_name, "infogeom", geom);

 fl_hide_form(info_obj->Help_Form);
 fl_free_form(info_obj->Help_Form);
 fl_free(info_obj);
 info_obj = NULL;

 return;
}

void
disp_infowindow(ptr, type)
void *ptr;
int type;
{
FL_OBJECT *obj;
char buf[255];
int i, w, h;

 if (!ptr)
	return;

 if (info_obj)  {
        fl_activate_form(info_obj->Help_Form);
        XRaiseWindow(fl_display, info_obj->Help_Form->window);
	return; }

 info_obj = (FD_Help_Form *) fl_calloc(1, sizeof(FD_Help_Form));
    
 info_obj->Help_Form = fl_bgn_form(FL_NO_BOX, 430, 290);
 obj = fl_add_box(FL_UP_BOX,0,0,430,290,"");
 info_obj->Help_Browser = obj =fl_add_browser(FL_NORMAL_BROWSER,0,0,430,245,"");
    fl_set_object_color(obj,FL_MCOL,FL_YELLOW);
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_gravity(obj, FL_NorthWest, FL_SouthEast);
    fl_set_object_callback(obj,Help_Browser_Call,0);
    fl_set_browser_hscrollbar(obj, FL_OFF);

 info_obj->Done_Help = obj = fl_add_button(FL_RETURN_BUTTON,10,250,70,30,"Ok");
    fl_set_object_gravity(obj, FL_SouthWest, FL_NoGravity);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj, Done_Info_Call,0);
 fl_end_form();

 b_setcfg_flags("infogeom", CF_NOTCHANGED);
 w = 400;
 h = 200;
 sscanf(b_getcfg_str(conf_name, "infogeom", ""), "%d %d", &w, &h);

 fl_set_initial_placement(info_obj->Help_Form, main_form->x, main_form->y,w, h);
 fl_set_form_minsize(info_obj->Help_Form, 400, 200);


 switch (type) 	{
  case INFO_MSG:
  {
  struct _mail_msg *msg = (struct _mail_msg *)ptr;
  struct _mime_msg *mime;
  struct _mail_addr *addr;
  struct _news_addr *naddr;

   sprintf(buf, "Message number: %d", msg->num);
   fl_add_browser_line(info_obj->Help_Browser, buf);
   if (msg->type & M_MH)
    sprintf(buf, "Message type: MH");
   else
   if (msg->type & M_IMAP)
    sprintf(buf, "Message type: IMAP");
   else
   if (msg->type & M_NEWS)
    sprintf(buf, "Message type: NEWS");
   else
   if (msg->type & M_MBOX)
    sprintf(buf, "Message type: MBOX");
   else
    sprintf(buf, "Message type: UNKNOWN");
   fl_add_browser_line(info_obj->Help_Browser, buf);

   if (msg->folder) {
   sprintf(buf, "Located in folder %-.32s (%-.127s)", msg->folder->sname ? msg->folder->sname : msg->folder->name(msg->folder), msg->folder->fold_path);
   fl_add_browser_line(info_obj->Help_Browser, buf);
		    }
   sprintf(buf, "Unique ID in folder: %lu", msg->uid);
   fl_add_browser_line(info_obj->Help_Browser, buf);
   sprintf(buf, "Total length: %lu bytes", msg->msg_len);
   fl_add_browser_line(info_obj->Help_Browser, buf);
   if (msg->msg_body && msg->msg_body_len) {
    sprintf(buf, "%lu bytes of message text are in memory", msg->msg_body_len);
    fl_add_browser_line(info_obj->Help_Browser, buf);
					   }
   sprintf(buf, "Priority: %d (%s)", get_msg_priority(msg),
	get_msg_priority_name(msg));
   fl_add_browser_line(info_obj->Help_Browser, buf);

   sprintf(buf, "Header information:");
   if (msg->status & H_SHORT) {
    fl_add_browser_line(info_obj->Help_Browser, "Only part of the header was in memory (reloaded)");
    my_deactivate();
    set_cursor(main_form, XC_watch);
    msg->get_header(msg);
    set_cursor(main_form, 0);
    my_activate();	     }

   fl_add_browser_line(info_obj->Help_Browser, buf);
   sprintf(buf, " Header length: %d bytes", msg->header->header_len);
   fl_add_browser_line(info_obj->Help_Browser, buf);
   sprintf(buf, " Was sent at: %s", get_arpa_date(msg->header->snt_time));
   fl_add_browser_line(info_obj->Help_Browser, buf);
   sprintf(buf, " Was received at: %s", get_arpa_date(msg->header->rcv_time));
   fl_add_browser_line(info_obj->Help_Browser, buf);
   sprintf(buf, " Subject: %-.64s", msg->header->Subject ? msg->header->Subject : "NO SUBJECT");
   fl_add_browser_line(info_obj->Help_Browser, buf);

   addr = msg->header->From;
   if (addr) {
    fl_add_browser_line(info_obj->Help_Browser, " From:");
    i = 0;
    while (addr)  {
     fl_add_browser_line(info_obj->Help_Browser, get_full_addr_line(addr));
     addr = addr->next_addr;
     i++;
     if (addr && (i > 20)) {
      fl_add_browser_line(info_obj->Help_Browser, "  ...");
      break;		  }
		 }
	     }

   addr = msg->header->To;
   if (addr) {
    fl_add_browser_line(info_obj->Help_Browser, " To:");
    i = 0;
    while (addr)  {
     fl_add_browser_line(info_obj->Help_Browser, get_full_addr_line(addr));
     addr = addr->next_addr;
     i++;
     if (addr && (i > 20)) {
      fl_add_browser_line(info_obj->Help_Browser, "  ...");
      break;		  }
		 }
	     }

   addr = msg->header->Cc;
   if (addr) {
    fl_add_browser_line(info_obj->Help_Browser, " Cc:");
    i = 0;
    while (addr)  {
     fl_add_browser_line(info_obj->Help_Browser, get_full_addr_line(addr));
     addr = addr->next_addr;
     i++;
     if (addr && (i > 20)) {
      fl_add_browser_line(info_obj->Help_Browser, "  ...");
      break;		  }
		 }
	     }

   addr = msg->header->Bcc;
   if (addr) {
    fl_add_browser_line(info_obj->Help_Browser, " Bcc:");
    i = 0;
    while (addr)  {
     fl_add_browser_line(info_obj->Help_Browser, get_full_addr_line(addr));
     addr = addr->next_addr;
     i++;
     if (addr && (i > 20)) {
      fl_add_browser_line(info_obj->Help_Browser, "  ...");
      break;		  }
		 }
	     }

   addr = msg->header->Sender;
   if (addr) {
    fl_add_browser_line(info_obj->Help_Browser, " Sender:");
    i = 0;
    while (addr)  {
     fl_add_browser_line(info_obj->Help_Browser, get_full_addr_line(addr));
     addr = addr->next_addr;
     i++;
     if (addr && (i > 20)) {
      fl_add_browser_line(info_obj->Help_Browser, "  ...");
      break;		  }
		 }
	     }

   naddr = msg->header->News;
   if (naddr) {
    fl_add_browser_line(info_obj->Help_Browser, " Newsgroups:");
    i = 0;
    while (naddr)  {
     fl_add_browser_line(info_obj->Help_Browser, naddr->name);
     naddr = naddr->next;
     i++;
     if (naddr && (i > 20)) {
      fl_add_browser_line(info_obj->Help_Browser, "  ...");
      break;		  }
		 }
	     }

   fl_add_browser_line(info_obj->Help_Browser, "Attributes:");
   if (msg->flags & SIGNED)
    fl_add_browser_line(info_obj->Help_Browser, " - Signature attached");
   if (msg->flags & UNREAD)
    fl_add_browser_line(info_obj->Help_Browser, " - Unread");
   if (msg->flags & NOT_SENT)
    fl_add_browser_line(info_obj->Help_Browser, " - Scheduled to be sent");
   if (msg->flags & MARKED)
    fl_add_browser_line(info_obj->Help_Browser, " - Marked by user");
   if (msg->status & C_DELIVERY)
    fl_add_browser_line(info_obj->Help_Browser, " - Needs delivery confirmation");
   if (msg->status & C_READ)
    fl_add_browser_line(info_obj->Help_Browser, " - Needs read confirmation");
   if (msg->flags & M_TEMP)
    fl_add_browser_line(info_obj->Help_Browser, " - Temporary message (will be deleted after reading)");
   if (msg->flags & H_ONLY)
    fl_add_browser_line(info_obj->Help_Browser, " - Message body is on remote server");
   if (msg->flags & ANSWERED)
    fl_add_browser_line(info_obj->Help_Browser, " - Reply to the message was sent");
   if (msg->flags & FORWARDED)
    fl_add_browser_line(info_obj->Help_Browser, " - Forwarded to other users");
   if (msg->flags & PGP_SIGNED)
    fl_add_browser_line(info_obj->Help_Browser, " - Signed with PGP");
   if (msg->flags & PGP_ENCRYPTED)
    fl_add_browser_line(info_obj->Help_Browser, " - Encrypted with PGP");
   if (msg->flags & M_SFAILED)
    fl_add_browser_line(info_obj->Help_Browser, " - Sending of this message failed");
   if (msg->flags & M_DONTEXPIRE)
    fl_add_browser_line(info_obj->Help_Browser, " - Never expires");
   if (msg->status & LOCKED)
    fl_add_browser_line(info_obj->Help_Browser, " - Locked (used by viewer/editor)");
   if (msg->status & DELETED)
    fl_add_browser_line(info_obj->Help_Browser, " - Deleted or scheduled to be deleted");
   if (msg->status & MOVED)
    fl_add_browser_line(info_obj->Help_Browser, " - Scheduled to be moved to another folder");
   if (msg->status & COPIED)
    fl_add_browser_line(info_obj->Help_Browser, " - Scheduled to be copied to another folder");
   if (msg->status & CHANGED)
    fl_add_browser_line(info_obj->Help_Browser, " - Message text has been modified");
   if (msg->status & S_THREAD)
    fl_add_browser_line(info_obj->Help_Browser, " - Message is a head of thread");
   if (msg->status & RECENT)
    fl_add_browser_line(info_obj->Help_Browser, " - Newly received message");
   if (msg->status & DELPERM)
    fl_add_browser_line(info_obj->Help_Browser, " - Deleted (or scheduled to be deleted) permanently (without moving to trash)");
   if (msg->status & MARKTMP)
    fl_add_browser_line(info_obj->Help_Browser, " - Marked by search");
   if (msg->status & MSGNEW)
    fl_add_browser_line(info_obj->Help_Browser, " - New message");
   if (msg->status & NOTINCOMING)
    fl_add_browser_line(info_obj->Help_Browser, " - Not an incoming message");
   if (msg->status & MMODIFIED)
    fl_add_browser_line(info_obj->Help_Browser, " - Modified");
   if (msg->status & MREFRESH)
    fl_add_browser_line(info_obj->Help_Browser, " - Refresh needed");
   if (msg->status & MNOREFRESH)
    fl_add_browser_line(info_obj->Help_Browser, " - Don't refresh from server");
   if (msg->status & MOUTGOING)
    fl_add_browser_line(info_obj->Help_Browser, " - Outgoing message");
   if (msg->status & MNOTEXISTS)
    fl_add_browser_line(info_obj->Help_Browser, " - Does not exists");
   if (msg->status & MTOOBIG)
    fl_add_browser_line(info_obj->Help_Browser, " - Message is too large");
   if (msg->status & IMAPDELETED)
    fl_add_browser_line(info_obj->Help_Browser, " - Marked as deleted on IMAP server");
   if (msg->status & MTOUS)
    fl_add_browser_line(info_obj->Help_Browser, " - Sent directly to us");
   if (msg->status & MFROMUS)
    fl_add_browser_line(info_obj->Help_Browser, " - Sent by us");
   sprintf(buf, "Flags: %04X Header: %04X", msg->flags, msg->header->flags);
   fl_add_browser_line(info_obj->Help_Browser, buf);

   if (!(msg->flags & H_ONLY))
	mime_scan(msg);
   if (is_mime_msg(msg)) {
    fl_add_browser_line(info_obj->Help_Browser, "MIME attachments:");
    mime = msg->mime;
    i = 1;
    while (mime) {
     if (!(mime->flags & ATTACHMENT)) {
	mime = mime->mime_next;
	continue;		      }

     sprintf(buf, " - Attachment #%d", i);
     fl_add_browser_line(info_obj->Help_Browser, buf);
     if (mime->m_start < mime->m_end) 	{
      sprintf(buf, " Start offset: %lu bytes", mime->m_start);
      fl_add_browser_line(info_obj->Help_Browser, buf);
      sprintf(buf, " End offset: %lu bytes", mime->m_end);
      fl_add_browser_line(info_obj->Help_Browser, buf);
      sprintf(buf, " Total length: %lu bytes", mime->m_end - mime->m_start);
      fl_add_browser_line(info_obj->Help_Browser, buf);
					}

     if (mime->src_info) {
      sprintf(buf, " File to be attached: %-127s", mime->src_info);
      fl_add_browser_line(info_obj->Help_Browser, buf);
			 }

     if (mime->mailcap)  {
      sprintf(buf, " Attachment type: %s/%s", mime->mailcap->type_text, mime->mailcap->subtype_text);
      fl_add_browser_line(info_obj->Help_Browser, buf);
      sprintf(buf, " Can view using internal viewer: %s", mime->mailcap->view ? "YES" : "NO");
      fl_add_browser_line(info_obj->Help_Browser, buf);
      sprintf(buf, " Can view using external viewer: %s", mime->mailcap->ext_mcap ? "YES" : "NO");
      fl_add_browser_line(info_obj->Help_Browser, buf);
			 }

     if (mime->encoding) {
      sprintf(buf, " Encoding: %s", mime->encoding->encoding_name);
      fl_add_browser_line(info_obj->Help_Browser, buf);
			 }

     if (mime->charset) {
      sprintf(buf, " Charset: %s (%s)", mime->charset->charset_name, mime->charset->charset_descr);
      fl_add_browser_line(info_obj->Help_Browser, buf);
			 }

     if (mime->c_id) {
      sprintf(buf, " %s: %-127s", MIME_C_ID, mime->c_id);
      fl_add_browser_line(info_obj->Help_Browser, buf);
		     }

     if (mime->c_descr) {
      sprintf(buf, " %s: %-127s", MIME_C_DESCR, mime->c_descr);
      fl_add_browser_line(info_obj->Help_Browser, buf);
		     }

     if (mime->c_len) {
      sprintf(buf, " %s: %lu", MIME_C_LENGTH, mime->c_len);
      fl_add_browser_line(info_obj->Help_Browser, buf);
		     }

     if (mime->boundary) {
      sprintf(buf, " Multipart boundary: %-127s", mime->boundary);
      fl_add_browser_line(info_obj->Help_Browser, buf);
		         }

     mime = mime->mime_next;
     i++;
		 }
					  }
   fl_show_form(info_obj->Help_Form, FL_PLACE_FREE,FL_TRANSIENT,"Message info");
  }
  break;

  case INFO_FOLDER:
  {
  struct _mail_folder *fld = (struct _mail_folder *)ptr;

   sprintf(buf, "Folder short name: %s", fld->sname ? fld->sname : (fld->name)(fld));
   fl_add_browser_line(info_obj->Help_Browser, buf);
   if (fld->descr) {
    sprintf(buf, "Folder description: %-127s", fld->descr);
    fl_add_browser_line(info_obj->Help_Browser, buf);
		   }
   if (fld->type & F_MH)
    sprintf(buf, "Folder type: MH");
   else
   if (fld->type & F_IMAP)
    sprintf(buf, "Folder type: IMAP");
   else
   if (fld->type & F_NEWS)
    sprintf(buf, "Folder type: NEWS");
   else
   if (fld->type & F_MBOX)
    sprintf(buf, "Folder type: MBOX");
   else
    sprintf(buf, "Folder type: UNKNOWN");
   fl_add_browser_line(info_obj->Help_Browser, buf);
   if (fld->spec)	{
    fl_add_browser_line(info_obj->Help_Browser, "Type specific info:");
    if (fld->type & F_MBOX)	{
	sprintf(buf, "Processed folder size: %d",
	((struct _mbox_spec *)fld->spec)->fsize);
	fl_add_browser_line(info_obj->Help_Browser, buf);
	if (((struct _mbox_spec *)fld->spec)->ffd)
	 sprintf(buf, "Opened with mode: %s",
		((struct _mbox_spec *)fld->spec)->mode);
	else
	 sprintf(buf, "Not opened");
	fl_add_browser_line(info_obj->Help_Browser, buf);
				}
			}
   sprintf(buf, "Folder path: %-127s", fld->fold_path);
   fl_add_browser_line(info_obj->Help_Browser, buf);
   sprintf(buf, "Total messages: %d", fld->num_msg);
   fl_add_browser_line(info_obj->Help_Browser, buf);
   sprintf(buf, "Total unread messages: %d", fld->unread_num);
   fl_add_browser_line(info_obj->Help_Browser, buf);
   sprintf(buf, "Hierarchy delimiter: %c", fld->hdelim);
   fl_add_browser_line(info_obj->Help_Browser, buf);
   sprintf(buf, "Unique ID: %ld", fld->getuid(fld));
   fl_add_browser_line(info_obj->Help_Browser, buf);
   if (fld->color != -1) {
    sprintf(buf, "Color: %d", fld->color);
    fl_add_browser_line(info_obj->Help_Browser, buf);
			 }
   if (fld->sort != -1) {
    sprintf(buf, "Sort: %d", fld->sort);
    fl_add_browser_line(info_obj->Help_Browser, buf);
			}
   if (fld->expire > 0) {
    sprintf(buf, "Delete messages older then %d days", fld->expire);
    fl_add_browser_line(info_obj->Help_Browser, buf);
			}

   if (fld->From)	{
    sprintf(buf, "Default From: %s", get_full_addr_line(fld->From));
    fl_add_browser_line(info_obj->Help_Browser, buf);
			}

   if (fld->pfold)	{
    sprintf(buf, "Subfolder of: %-127s", fld->pfold->fold_path);
    fl_add_browser_line(info_obj->Help_Browser, buf);
    sprintf(buf, "Nesting level: %d", fld->level + 1);
    fl_add_browser_line(info_obj->Help_Browser, buf);
			}

   if (fld->subfold) 	{
    for (i = 0; i < MAX_SUBFOLDERS; i++) {
     if (fld->subfold[i]) {
	sprintf(buf, "Parent of: %-127s", fld->subfold[i]->fold_path);
	fl_add_browser_line(info_obj->Help_Browser, buf);
			 }
					 }
			}

   fl_add_browser_line(info_obj->Help_Browser, "Attributes:");
   if (fld->status & SYSTEM)
    fl_add_browser_line(info_obj->Help_Browser, " - System folder (can not be deleted or renamed)");
   if (fld->status & SORTED)
    fl_add_browser_line(info_obj->Help_Browser, " - Messages are sorted");
   if (fld->status & OPENED)
    fl_add_browser_line(info_obj->Help_Browser, " - Opened");
   if (fld->status & SEARCH)
    fl_add_browser_line(info_obj->Help_Browser, " - Contains messages found by search");
   if (fld->flags & CACHED)
    fl_add_browser_line(info_obj->Help_Browser, " - Cached");
   if (fld->status & FRONLY)
    fl_add_browser_line(info_obj->Help_Browser, " - Read-only");
   if (fld->status & NOINFR)
    fl_add_browser_line(info_obj->Help_Browser, " - Can not have subfolders");
   if (fld->status & FHIDDN)
    fl_add_browser_line(info_obj->Help_Browser, " - Hidden (how can you see this???)");
   if (fld->status & NOTRASH)
    fl_add_browser_line(info_obj->Help_Browser, " - Trash folder");
   if (fld->status & FRESCAN)
    fl_add_browser_line(info_obj->Help_Browser, " - Should be rescanned");
   if (fld->status & FSHORTH)
    fl_add_browser_line(info_obj->Help_Browser, " - Scan short headers");
   if (fld->flags & FNCOUNT)
    fl_add_browser_line(info_obj->Help_Browser, " - Unread messages not counted in total");
   if (fld->flags & FMARKED)
    fl_add_browser_line(info_obj->Help_Browser, " - Marked");
   if (fld->status & FMRKTMP)
    fl_add_browser_line(info_obj->Help_Browser, " - Marked temporarily");
   if (fld->status & FRECNT)
    fl_add_browser_line(info_obj->Help_Browser, " - Contains new messages");
   if (fld->flags & FSHRECP)
    fl_add_browser_line(info_obj->Help_Browser, " - Show recipient");
   if (fld->status & FUNREAD)
    fl_add_browser_line(info_obj->Help_Browser, " - Only unread messages shown");
   if (fld->flags & FCHECK)
    fl_add_browser_line(info_obj->Help_Browser, " - Check periodically");
   if (fld->status & FREMOTE)
    fl_add_browser_line(info_obj->Help_Browser, " - Remote folder");
   else
    fl_add_browser_line(info_obj->Help_Browser, " - Local folder");
   if (fld->status & FLOCKED)
    fl_add_browser_line(info_obj->Help_Browser, " - Locked");
   if (fld->status & FREWRTE)
    fl_add_browser_line(info_obj->Help_Browser, " - Will be rewritten");
   if (fld->status & FNOCLSE)
    fl_add_browser_line(info_obj->Help_Browser, " - Can not be closed");
   if (fld->status & FDUMMY)
    fl_add_browser_line(info_obj->Help_Browser, " - Dummy folder");
   if (fld->flags & FEXPND)
    fl_add_browser_line(info_obj->Help_Browser, " - Show subfolders");
   if (fld->status & FSKIP)
    fl_add_browser_line(info_obj->Help_Browser, " - Don't show in folder list");
   if (fld->status & FALIAS)
    fl_add_browser_line(info_obj->Help_Browser, " - Short name is an alias");
   if (fld->status & FNSCAN)
    fl_add_browser_line(info_obj->Help_Browser, " - Don't rescan");
   if (fld->status & FEXPNG)
    fl_add_browser_line(info_obj->Help_Browser, " - EXPUNGE pending");
   if (fld->flags & FRKEEP)
    fl_add_browser_line(info_obj->Help_Browser, " - Keep reply message");
   if (fld->flags & FNVALD)
    fl_add_browser_line(info_obj->Help_Browser, " - Don't validate messages");
   fl_show_form(info_obj->Help_Form, FL_PLACE_FREE, FL_TRANSIENT,"Folder info");
  }
  break;

  default:
   fl_free_form(info_obj->Help_Form);
   fl_free(info_obj);
   info_obj = NULL;
  break;
		}

 return;
}

int
main(argc, argv)
int argc;
char **argv;
{
int i, cnfdir = 0;
int x, y, w, h;
char menu[255];
char from[255], cfgfile[255] = "", buf[512];
char gecos[32];
char *p;
struct passwd *pwd;
struct stat sb;
DIR *dirp;
Display *pDisplay;
Window root;
struct _mail_addr *addr;

printf("XFMail %s%s [%s] - X11 e-mail client for %s\n", VERSION, DEBUGVERSION, PATCHLEVEL, XF_OS);
printf("(C) 1995,1996,1997 Gennady B. Sorokopud\n");
printf("Compiled at %s\n", COMPILED);

for (i = 1; i < argc; i++)
 {
  if (*argv[i] != '-')
	continue;

  if (strncmp(argv[i] + 1, "help", 1) == 0)
	usage(argv[0], 1);

  if (strncmp(argv[i] + 1, "cfgfile", 7) == 0)	{
   if (++i == argc)
	usage(argv[0], 1);
   strncpy(cfgfile, argv[i], 254);
   configdir[254] = '\0';
   continue;
						}

  if (strncmp(argv[i] + 1, "cfgdir", 6) == 0)	{
   if (++i == argc)
	usage(argv[0], 1);
   strncpy(configdir, argv[i], 254);
   configdir[254] = '\0';
   continue;
						}
 }

umask(077);
p = getenv("TMPDIR");
strcpy(tmpdir, p ? p : "/tmp");

signal(SIGHUP,  SIG_IGN);
signal(SIGQUIT, SIG_IGN);
signal(SIGPIPE, SIG_IGN);

#ifndef DEBUG
signal(SIGSEGV, crash_handle);
signal(SIGBUS, crash_handle);
#endif

#ifdef	HAVE_SETLOCALE
if (setlocale(LC_ALL, "") == NULL) {
  fprintf(stderr, "Locale isn't supported\n");
  if (setlocale(LC_ALL, NULL) == NULL)	{
	fprintf(stderr, "setlocale() failed, can not continue\n");
	exit(1);			}
  fprintf(stderr,"Using %s locale instead.\n",
	setlocale(LC_CTYPE, NULL));
				   }
if (!XSupportsLocale())
  fprintf(stderr, "WARNING: Xlib: locale %s not supported\n.",
	setlocale(LC_CTYPE, NULL));
else	{
  if (XSetLocaleModifiers("") == NULL)
	fprintf(stderr,"WARNING: Cannot set locale modifiers.\n");
	}
#endif

setpwent();
if ((pwd = getpwuid(getuid())) == NULL)
  fprintf(stderr,"WARNING: Can not access your password entry. Who are you?\n");

p = getenv("USER");
if (!p && !pwd)  {
	fprintf(stderr, "Can not determine your username (set USER environment variable to fix this)\n");
	exit(1); }
strncpy(user_n, p ? p : pwd->pw_name, 31);

p = getenv("HOME");
if (!p && !pwd)  {
	fprintf(stderr, "Can not determine your home directory (set HOME environment variable to fix this)\n");
	exit(1); }
strncpy(homedir, p ? p : pwd->pw_dir, 240);
gecos[0] = '\0';
strncpy(gecos, pwd ? pwd->pw_gecos : user_n, 31);
gecos[31] = '\0';
user_n[31] = '\0';
homedir[240] = '\0';
for (i = 0; i < strlen(gecos); i++) {
    if (!isalpha(gecos[i]) && (gecos[i] != ' ') && (gecos[i] != '.')) {
	 gecos[i] = '\0';
	 break;
								      }
				    }

if (!*configdir) {
if ((p = getenv("XFMAILDIR")) != NULL)
 strncpy(configdir, p, 254);
else
 sprintf(configdir, "%s/.xfmail", homedir);
configdir[254] = '\0';
	         }

if (stat(configdir, &sb) == -1) {
 if (mkdir(configdir, 0700) == -1) {
	fprintf(stderr, "init: can not create %s", configdir);
	exit(1);		   }

 cnfdir = 1;
				}
else
{
 if (!(sb.st_mode & S_IFDIR)) 	{
	fprintf(stderr, "init: %s is not a directory", configdir);
	exit(1);		}
}

if (!(dirp = opendir(configdir))) {
	fprintf(stderr, "init: can not access %s", configdir);
	exit(1);		  }

closedir(dirp);

sprintf(buf, "%s/.xfmrules", homedir);
if (stat(buf, &sb) == 0) {
  cnfdir = 2;
  sprintf(from, "%s/.xfmrules", configdir);
  do_move(buf, from);

  sprintf(from, "%s/.xfmailrc", homedir);
  sprintf(buf, "%s/.xfmailrc", configdir);
  do_move(from, buf);

  sprintf(from, "%s/.xfmime", homedir);
  sprintf(buf, "%s/.xfmime", configdir);
  do_move(from, buf);

  sprintf(from, "%s/.xfdefaults", homedir);
  sprintf(buf, "%s/.xfdefaults", configdir);
  do_move(from, buf);

			  }

p = *cfgfile ? cfgfile : getenv("XFMAILRC");
sprintf(conf_name, "%s/%s", configdir, p ? p : ".xfmailrc");

if (b_loadcfg(conf_name) < 0)
	fprintf(stderr, "init: Can not load configuration file %s", conf_name);

read_xfdefaults();

if (!fl_initialize(&argc,argv, "XFMail", xfmail_cmdopt, Ncopt)) {
	fprintf(stderr, "Failed to initialize display\n");
	exit(1);					        }
XSetErrorHandler(x11error_handle);
XSetIOErrorHandler(x11ioerror_handle);

fl_get_app_resources(xfres, Nropt);
fl_set_app_nomainform(1);

init = 1;

if (cfg_exist("from"))
	cfg_check_version();

pDisplay = FL_ObjectDisplay(fl_default_window());
root = RootWindowOfScreen(DefaultScreenOfDisplay(pDisplay));

XpmCreatePixmapFromData(pDisplay, root, icon_mail_xpm,
                         &iconPix, &iconPix_sh, NULL);
XpmCreatePixmapFromData(pDisplay, root, icon_nomail_xpm,
                         &iconPix_noMail, &iconPix_noMail_sh, NULL);
XpmCreatePixmapFromData(pDisplay, root, mail_edit,
                         &icon_MailEdit, &icon_MailEdit_sh, NULL);
XpmCreatePixmapFromData(pDisplay, root, abook_xpm,
                         &icon_ABook, &icon_ABook_sh, NULL);
mailcur = fl_create_bitmap_cursor(mailcur_bits, mailcur_mask_bits,
	mailcur_width, mailcur_height, mailcur_width/2 , 0);

restore_fonts();
restore_charsets();

fl_set_goodies_font(b_getcfg_int(conf_name, "GoodiesFontFStyle", FL_NORMAL_STYLE), b_getcfg_int(conf_name, "GoodiesFontFSize", FL_DEFAULT_SIZE));

if (xfdefs.popfsize > 0)
	fl_setpup_fontsize(xfdefs.popfsize);
if (xfdefs.popfstyle > 0)
	fl_setpup_fontstyle(xfdefs.popfstyle);
if (xfdefs.popcursor > 0)
	fl_setpup_default_cursor(xfdefs.popcursor);
if ((xfdefs.popbgcol > 0) && (xfdefs.popfgcol > 0))
	fl_setpup_color(xfdefs.popbgcol, xfdefs.popfgcol);
else
if (xfdefs.popbgcol > 0)
	fl_setpup_color(xfdefs.popbgcol, FL_BLACK);
else
if (xfdefs.popfgcol > 0)
	fl_setpup_color(FL_COL1, xfdefs.popfgcol);

fbrowsersize = b_getcfg_int(conf_name, "fbrowser", 180);
if ((fbrowsersize < 80) || (fbrowsersize > 300))
	fbrowsersize = 180;

b_setcfg_flags("fbrowser", CF_NOTCHANGED);

init_forms();
init_procs();
init_cinfo();

if (xfcompose)	{
 nomainwindow = 1;
 startup = STARTUP_COMPOSE;
		}

if (!nomainwindow)	{
 main_form = create_main_form();

 sscanf(b_getcfg_str(conf_name, "placement", "100 100 800 415"), "%d%d%d%d", &x, &y, &w, &h);
 if (*xfgeom)	{
 parse_geometry(xfgeom, &x, &y, &w, &h);
 fl_set_initial_placement(main_form, x, y, w, h);
		}
 else	{
  if (b_getcfg_int(conf_name, "wplace", 1))
	fl_set_initial_placement(main_form, x, y, w, h);
  else
	fl_set_form_size(main_form, w, h);
	}

 if (b_getcfg_int(conf_name, "starticon", 0))
	xficonic = 1;

 fl_set_form_minsize(main_form, 600, 300);
 fl_set_form_icon(main_form, iconPix_noMail, iconPix_noMail_sh);
 fl_set_atclose(main_close, NULL);
 fl_show_form(main_form, xficonic ? FL_PLACE_ICONIC|FL_FREE_SIZE : FL_FREE_SIZE,
	FL_FULLBORDER, "XFMail");

 xofft = main_form->x - x;
 yofft = main_form->y - y;

 fl_deactivate_form(main_form);
 set_cursor(main_form, XC_watch);

 if (b_getcfg_int(conf_name, "startlog", 0)) 
	log_win(); 
 else
	fl_set_menu_item_mode(menu_misc, 9, FL_PUP_BOX);

 sprintf(menu, "Send%%F%%t|%s", SEND_MENU);
 spup = fl_defpup(main_form->window, menu, send_pup_cb);

 sprintf(menu, "Message%%F%%t|%s|Send%%m", MESG_MENU);
 mpup = fl_defpup(main_form->window, menu, mesg_pup_cb, spup);

 sprintf(menu, "Folder%%F%%t|%s", FOLD_MENU);
 fpup = fl_defpup(main_form->window, menu, fold_pup_cb);

 fl_setpup_shadow(mpup, 0);
 fl_setpup_shadow(spup, 0);
 fl_setpup_shadow(fpup, 0);
 fl_setpup_softedge(mpup, 0);
 fl_setpup_softedge(spup, 0);
 fl_setpup_softedge(fpup, 0);
			}

if (cnfdir == 1)
 display_msg(MSG_MSG, "init", "Directory %s has been created", configdir);
else
if (cnfdir == 2) {
 sprintf(from, "%s/.xfbook", b_getcfg_str(conf_name, "addrdir", homedir));
 sprintf(buf, "%s/.xfbook", configdir);
 do_move(from, buf);

 sprintf(buf, "mv %s/.xfbook.* %s/", b_getcfg_str(conf_name, "addrdir", homedir), configdir);
 system(buf);

 display_msg(MSG_MSG, "init", "Directory %s has been created\nand XFMail moved all configuration files into it", configdir);
		}

sprintf(sender_name, "%s@%s", user_n, getmyhostname());

/* running at the first time */
if (!cfg_exist("from")) {

if (strlen(gecos) > 1)
	sprintf(from, "%s <%s@%s>", gecos, user_n, getmyhostname());
else
	sprintf(from, "%s@%s", user_n, getmyhostname());

b_getcfg_str(conf_name, "from", from);

about(0);

xfm_config_new(1);		/* misc_conf() */

if (!cfg_exist("spool"))
	xfm_config_new(5);	/* inc_conf()  */

if (!cfg_exist("smtphost"))
	xfm_config_new(4);	/* smtp_conf() */

if (b_getcfg_int(conf_name, "popretr", 0))
	xfm_config_new(6);	/* pop_conf() */

if (b_getcfg_int(conf_name, "imapretr", 0))
	xfm_config_new(7);	/* imap_conf() */

b_putcfg_str(conf_name, "xfversion", VERSION);

b_savecfg(0);
}
else 	{
struct _mail_addr *ma;

 if (((ma = get_address(b_getcfg_str(conf_name, "from", ""), ADDR_GET_FIRST)) == NULL) ||
	((p = strchr(ma->addr, '@')) == NULL) ||
	(strchr(p, '.') == NULL)) {
	display_msg(MSG_WARN, "Your E-Mail address (From field)", "is invalid, please fix it");
	xfm_config_new(1);
				   }

 if (ma)
	discard_address(ma);
	}

logging = b_getcfg_int(conf_name, "logging", logging);
msg_form_init();

display_msg(MSG_LOG, "startup", "Opening all folders");

sort_type = b_getcfg_int(conf_name, "sort", BY_SNT_TIME|MSG_DESCEND|MSG_THREAD);
folder_sort = b_getcfg_int(conf_name, "fsort", BY_NAME|MSG_ASCEND);

sprintf(maildir, "%s/Mail", homedir);
my_deactivate();
supress_questions = 1;
if (open_all_folders(b_getcfg_str(conf_name, "maildir", maildir), xfcompose)
	== -1)	{
	display_msg(MSG_FATAL, "init", "initialzation failed");
	exit(1);}
supress_questions = 0;
my_activate();

display_msg(MSG_LOG, "startup", "Loading folder configuration");
if (load_folders_conf(NULL) == -1) {
	display_msg(MSG_FATAL, "init", "Failed to load folder configuration");
	exit(1);		   }

display_msg(MSG_LOG, "startup", "Cleaning temp folders");
ftemp->empty(ftemp);
fmbox->empty(fmbox);

display_msg(MSG_LOG, "startup", "Initializing cache");
init_cache();

display_msg(MSG_LOG, "startup", "Loading rules database");
if (load_rules() == -1)
	display_msg(MSG_WARN, "init", "Failed to load rules");

display_msg(MSG_LOG, "startup", "Loading default address book");
if (load_book(NULL) == -1)
	display_msg(MSG_WARN, "init", "Failed to load address book");

display_msg(MSG_LOG, "startup", "Loading signatures");
load_signatures();

display_msg(MSG_LOG, "startup", "Loading mailcap");
load_mailcap();

display_msg(MSG_LOG, "startup", "Loading keymap");
load_keymap();

if (!b_getcfg_int(conf_name,"popstorpwd", 0))
	b_setcfg_flags("popasswd", DONT_STORE|CF_UNSECURE);
else
	b_setcfg_flags("popasswd", CF_UNSECURE);

if (!b_getcfg_int(conf_name,"imapstorpwd", 0))
	b_setcfg_flags("imapwd", DONT_STORE|CF_UNSECURE);
else
	b_setcfg_flags("imapwd", CF_UNSECURE);

if (!b_getcfg_int(conf_name,"nntpstorpwd", 0))
	b_setcfg_flags("nntpasswd", DONT_STORE|CF_UNSECURE);
else
	b_setcfg_flags("nntpasswd", CF_UNSECURE);

b_setcfg_flags("placement", CF_NOTCHANGED);
b_setcfg_flags("msgformsize", CF_NOTCHANGED);
b_setcfg_flags("sfolder", CF_NOTCHANGED);

switch (startup) {
 case STARTUP_NORMAL:
  show_msg[STAT_LEN] = b_getcfg_int(conf_name, "statlen", 2);
  show_msg[DATE_LEN] = b_getcfg_int(conf_name, "datelen", 13);
  show_msg[SIZE_LEN] = b_getcfg_int(conf_name, "sizelen", 5);
  show_msg[FROM_LEN] = b_getcfg_int(conf_name, "fromlen", 18);
  show_msg[SUBJ_LEN] = b_getcfg_int(conf_name, "subjlen", 100);

  show_fld[FOLD_LEN] = b_getcfg_int(conf_name, "foldlen", 11);
  show_fld[FNUM_LEN] = b_getcfg_int(conf_name, "fnumlen", 4);
  show_fld[FUNR_LEN] = b_getcfg_int(conf_name, "funrlen", 4);

  sscanf(b_getcfg_str(conf_name, "msgcolors", ""), "%d%d%d%d",
 &color_msg[MSG_CURR_CLR],&color_msg[MSG_UNREAD_CLR],&color_msg[MSG_MARK_CLR],
 &color_msg[MSG_NORMAL_CLR]);

  sscanf(b_getcfg_str(conf_name, "fldcolors", ""), "%d%d%d%d%d%d%d%d",
 &color_fld[FLD_DUMMY_CLR], &color_fld[FLD_SEARCH_CLR],&color_fld[FLD_MARK_CLR],
 &color_fld[FLD_RECENT_CLR],&color_fld[FLD_SYSTEM_CLR],&color_fld[FLD_IMAP_CLR],
 &color_fld[FLD_CURR_CLR],  &color_fld[FLD_NORMAL_CLR]);

  my_deactivate();
  if (!(current_folder = get_folder_by_name(b_getcfg_str(conf_name, "sfolder", INBOX))))
	current_folder = inbox;
  current_folder->open(current_folder, 0);
  mark_to_us(current_folder);
  current_message = current_folder->messages;
  current_index = 0;
  offline = b_getcfg_int(conf_name, "smtpoffl", 0);

  fl_set_timer(inc_timer, b_getcfg_int(conf_name,"inctime",180));
  fl_set_timer(send_timer, b_getcfg_int(conf_name,"sendtime",0));
  fl_set_timer(trash_timer, b_getcfg_int(conf_name,"trashtime",0) * 60);

  if (b_getcfg_int(conf_name, "imapautocon", 0))
   if (imap_init() == 0) 	{
    fl_replace_menu_item(menu_misc, 8, "IMAP disconnect");
    redraw_folders();		}

  supress_errors = 2;
  if (b_getcfg_int(conf_name,"inconstart", 0))
	get_new_mail(0);
  supress_errors = 0;

  set_cursor(main_form, 0);
  fl_set_object_prehandler(b_messages,preemptive_handler);
  fl_set_object_posthandler(b_messages,msg_posthandler);
  fl_set_object_posthandler(b_folders,fld_posthandler);

  my_activate();
  redraw_folders();
  fl_set_idle_callback(idle_cb, NULL);
 break;

 case STARTUP_COMPOSE:
  current_folder = outbox;
  current_folder->open(current_folder, 0);
  if ((current_message = create_message(outbox)) == NULL)
	clean_exit(0);

  if (*xfmsg)	{
   if (xfwithhdr) {
    if (set_message_file(current_message, xfmsg) == -1)
	clean_exit(0);
		  }
   else	{
    if (set_message_text(current_message, xfmsg) == -1)
	clean_exit(0);
	}
		}

  while (argc-- > 1)	{
   if ((addr = get_address(argv[argc], ADDR_GET_FIRST)) == NULL)
	continue;
   addr->next_addr = current_message->header->To;
   current_message->header->To = addr;
			}
  offline = 0;
  edit_msg(current_message);
 break;
		}

signal(SIGINT,  clean_exit);
signal(SIGTERM, clean_exit);

initdone = 1;
display_msg(MSG_STAT, NULL, "Ready");
display_msg(MSG_LOG, "startup", "Done");
update_title();

while(1)
	fl_do_forms();

clean_exit(0);
}

/* temporary hack in order to fix do_keyboard() crashes */
void
do_keyboard_hack()
{
XEvent xev;
FL_FORM *hackform = main_form ? main_form : get_viewedit_form();

 if (hackform == NULL)
	return;

 xev.xcrossing.type = EnterNotify;
 xev.xcrossing.serial = 10000;
 xev.xcrossing.send_event = False;
 xev.xcrossing.display = fl_display;
 xev.xcrossing.window = hackform->window;
 xev.xcrossing.root = fl_root;
 xev.xcrossing.subwindow = None;
 xev.xcrossing.time = CurrentTime;
 xev.xcrossing.x = 0;
 xev.xcrossing.y = 0;
 xev.xcrossing.x_root = hackform->x;
 xev.xcrossing.y_root = hackform->y;
 xev.xcrossing.mode = NotifyNormal;
 xev.xcrossing.detail = NotifyAncestor; 
 xev.xcrossing.same_screen = True;
 xev.xcrossing.focus = True;
 xev.xcrossing.state = 0;
 XSendEvent(fl_display, hackform->window, False, 0, &xev);

 xev.xbutton.type = ButtonPress;
 xev.xbutton.state = 0;
 xev.xbutton.button = 1;
 xev.xbutton.same_screen = True;
 XSendEvent(fl_display, hackform->window, False, 0, &xev);

 return;
}

