#include "include.h"
#include "complex.c"

/************************************************************************************/

int decomp(im)
double im;
{
if (im>0) {return(coul_back);}
	else {return(coul_for);} 
}

/************************************************************************************/

int lmandelbrot(z0) 
lcomplex z0;          
 
{
	register int k;
	lcomplex z;
	FLOAT_SIZE temp,temp2,temp3;
                                
	temp2=(FLOAT_SIZE)0.0;
	temp3=(FLOAT_SIZE)0.0;
	z.re=(FLOAT_SIZE)0.0;
	z.im=(FLOAT_SIZE)0.0;
	
	for (k=0;(k<iter)&&((temp2+temp3)<(FLOAT_SIZE)bailout);++k){ 
		temp=z.re;
		temp2=temp*temp;
		temp3=z.im*z.im;
		z.re=temp2-temp3+z0.re;
		z.im=2*z.im*temp+z0.im; 
/*		printf("%Le %Le \n",z.re,z.im);*/
		/*z=z*z+z0;*/
		}  
 
	return(k);
}			
/************************************************************************************/

int mandelbrot(z0) 
complex z0;          
 
{
	register int k;
	complex z;
	double temp,temp2=0.0,temp3=0.0;
                                
	z.re=0;
	z.im=0;
	for (k=0;(k<iter)&&(temp2+temp3<bailout);++k){   
		temp=z.re;
		temp2=temp*temp;
		temp3=z.im*z.im;
		z.re=temp2-temp3+z0.re;
		z.im=2*z.im*temp+z0.im; 
/*		z=c_add(z0,c_sqr(z));*/
		/*z=z*z+z0;*/
		}   
        if (type_dessin==DECOMPOSITION) {return(decomp(z.im));}
	return(k);
}			

/*******************************************************************************************************************************/

int newton(z0)
complex z0;      
{
	register int k=0;
	complex z,zz;
	double escape=1E-6;  

	z=z0;               
	zz.re=10.0;
	zz.im=10.0;
	for (k=0;(k<iter)&&(c_module2(c_sub(z,zz))>escape);++k){
		zz=z;
		/* z=((degre-1)*pow(z,ip)+1)/(degre*pow(z,ip-1)); */
		z=c_div(dc_add(1.0,dc_mult((double)ip-1.0,ci_pow(z,ip))),dc_mult((double)ip,ci_pow(z,ip-1)));
		}
        if (type_dessin==DECOMPOSITION) {return(decomp(z.im));}
	return(k);
}			

/*******************************************************************************************************************************/

int julia(zz,c)
complex zz,c; 
{
	register int k;
	complex z;  
	double temp,temp2=0.0,temp3=0.0;
                                
	z.re=zz.re;
	z.im=zz.im;
	for (k=0;(k<iter)&&(temp2+temp3<bailout);k++){   
		temp=z.re;
		temp2=temp*temp;
		temp3=z.im*z.im;
		z.re=temp2-temp3+c.re;
		z.im=2*z.im*temp+c.im; 
/*		z=c_add(c,c_sqr(z));*/
		/*z=z*z+z0;*/
		}   
       if (type_dessin==DECOMPOSITION) {return(decomp(z.im));}
	return(k);
}			
/*******************************************************************************************************************************/

int mandel3(z0)
complex z0;   
{
	register int k;
	complex z;
                                
	z=znull;
	for (k=0;(k<iter)&&(c_module2(z)<bailout);++k){
		/* z=z*z*z+z0; */
		z=c_add(z0,c_mult(z,c_sqr(z)));
		}   
        if (type_dessin==DECOMPOSITION) {return(decomp(z.im));}
	return(k);
}			
  
/*******************************************************************************************************************************/
		
int julia3(zz,c)
complex zz,c; 
{
	register int k;
	complex z;  

 	z=zz;      
	for (k=0;((k<iter)&&(c_module2(z)<bailout));++k){
		/* z=z*z*z+c;  */
		z=c_add(c,c_mult(z,c_sqr(z)));
		}
        if (type_dessin==DECOMPOSITION) {return(decomp(z.im));}
	return(k);
}			

/*******************************************************************************************************************************/
		
int mandellambda(z0)
complex z0; 
{
	register int k=0;
	complex z; 
	double zim2,zre2; 
	double temp1,temp2;

 	z.im=0;      
	z.re=0.5;
	zim2=0;
	zre2=z.re*z.re;
	for (k=0;(k<iter)&&(zim2+zre2<bailout);k++){ 
		zre2=z.re*z.re;
		zim2=z.im*z.im;
		temp1=z.re-zre2+zim2;
		temp2=z.im-2*z.re*z.im;
		z.re=z0.re*temp1-z0.im*temp2;
		z.im=z0.im*temp1+z0.re*temp2;  
		/* z=z0z(1-z)  */
		/*z=c_mult(z0,c_mult(z,dc_add(-1.0,z)));   */
		}
        if (type_dessin==DECOMPOSITION) {return(decomp(z.im));}    
	return(k); 
}			

/*******************************************************************************************************************************/

/*int mandellambda(z0)
complex z0; 
{
	register int k=0;
	complex z;
	double temp;  

 	z=znull;      
	z.re=z0.re;
	z.im=z0.im;
	for (k=0;(k<iter)&&(c_module2(z)<bailout);k++){       
		/* z=z0z(1-z)  */
/*		temp=z.re;
		z.re=z.re*z.re-z.im*z.im+z0.re; 
		z.im=2*temp*z.im+0.2+z0.im;  
		}
        if (type_dessin==DECOMPOSITION) {return(decomp(z.im));}    
	return(k);
/*		z.re=(z.re*z.re-z.im*z.im)*z0.re+z.re; 
		z.im=2*temp*z.im+z0.im+z0.re;  
*/
/*}			

/*******************************************************************************************************************************/

/*int lambda(zz,c)
complex zz,c; 
{
	register int k;
	complex z;  

 	z.re=zz.re;      
 	z.im=zz.im;      
	for (k=0;(k<iter)&&(c_module2(z)<bailout);++k){
		/* z=cz(1-z)  ou (z-1)?*/
/*		z=c_mult(c,c_mult(z,dc_add(-1.0,z)));
		}
        if (type_dessin==DECOMPOSITION) {return(decomp(z.im));}
	return(k);
}			

/*******************************************************************************************************************************/

int lambda(zz,c)
complex zz,c; 
{
	register int k=0;
	complex z; 
	double zim2,zre2; 
	double temp1,temp2;

 	z.im=zz.im;      
	z.re=zz.re;
	zim2=0;
	zre2=z.re*z.re;
	for (k=0;(k<iter)&&(zim2+zre2<bailout);k++){ 
		zre2=z.re*z.re;
		zim2=z.im*z.im;
		temp1=z.re-zre2+zim2;
		temp2=z.im-2*z.re*z.im;
		z.re=c.re*temp1-c.im*temp2;
		z.im=c.im*temp1+c.re*temp2;  
		/* z=cz(1-z)  ou (z-1)?*/
		/*z=c_mult(c,c_mult(z,dc_add(-1.0,z)));*/
		}
        if (type_dessin==DECOMPOSITION) {return(decomp(z.im));}
	return(k);
}			

/*******************************************************************************************************************************/

int spider(pixel,c)
complex pixel;
{
    
    int counter;
    complex z,w,x; 
    x.re=2.0;
    x.im=0.0;
    w=pixel;
    z=pixel;
/*    z=c_add(pixel,c);*/
    for (counter = 1; counter <= iter;counter++)
   {
      z=c_add(c_sqr(z),w);
      w=c_add(c_div(w,x),z); 
      if (c_module2(z)>bailout)  
                       return(counter);
         }
      return(0); 
   }

/*******************************************************************************************************************************/

int barnsley1(pixel,constant)
complex pixel,constant;

{       
       int counter;
        complex z,x;
 
       z=pixel;
       x.re=1.0;
       x.im=0.0;
       for (counter=1;counter <=iter;counter++)
   {
       if (z.re >= 0)  z=c_mult(constant,c_sub(z,x));
        else  z=c_mult(c_conj(constant),c_add(z,x));
       if (c_module2(z)>bailout)  
                     return(counter);
        }
    return(0);
}

/*******************************************************************************************************************************/

int barnsley2(pixel,constant)
complex pixel,constant;

{       
       int counter;
       complex z,x;
 
       z=pixel;
       x.re=1.0;
       x.im=0.0;
       for (counter=1;counter <=iter;counter++)
   {
       if ( (z.re*constant.im+constant.re*z.im)>= 0)   
                          z=(c_mult(c_sub(z,x),constant));
       else             
                          z=(c_mult(c_add(z,x),constant));
       if (c_module2(z)>bailout)  
                     return(counter);
        }
    return(0);
}

/*******************************************************************************************************************************/

int barnsley3(pixel,constant)
complex pixel,constant;

{       
       int counter;
       complex z;
       double temp1,temp2; 
       z=pixel;

       for (counter=1;counter <=iter;counter++)
   {
       temp1= z.re*z.re-z.im*z.im -1;
       temp2= 2*z.re*z.im;
       if ( z.re >= 0) 
                  {  z.re=temp1;
                     z.im=temp2;
                   }
       else
                  { temp1=temp1+constant.re*z.re;
                    temp2=temp2+constant.im*z.re;
                    z.re=temp1;
                    z.im=temp2;
                  }
       if (c_module2(z)>bailout)  
                     return(counter);
        }
    return(0);
}

/*******************************************************************************************************************************/

int glass(pixel,constant)  
complex pixel,constant;
{
    int counter;
    complex z,w;
    w=pixel;
    z.re=.5;
    z.im=0;
    z=c_add(z,constant);
    for (counter = 1; counter <= 255;counter++)
    {
      z=c_sub(c_mult(w,z),c_mult(w,c_sqr(z))); 
      if (c_module2(z)>bailout)  
                       return(counter);
         }
      return(0); 
}


/*******************************************************************************************************************************/


int jcos(pixel,constant)  
complex pixel,constant; 

 {  int counter;
    complex z;

    z=pixel;
    for (counter = 1;counter <= iter;counter++)
    {  
      z=c_mult(constant,c_cos(z));
      if (fabs(z.im) > 50.0)  
                       return(counter);
         }
   return(0);
   }

/*******************************************************************************************************************************/

int jsin(pixel,constant)  
complex pixel,constant; 

 {  int counter;
    complex z;

    z=pixel;
    for (counter = 1;counter <= iter;counter++)
    {  
      z=c_mult(constant,c_sin(z));
      if (fabs(z.im) > 50)  
                       return(counter);
         }
   return(0);
   }


/*******************************************************************************************************************************/

int jexp(pixel,constant)
complex pixel,constant;

{
    int counter;
    complex z;

    z=pixel;
    for (counter = 1; counter <= iter;counter++)
     {
      z=c_mult(constant,c_exp(z));
      if (z.re > 50)  
                       return(counter);
         }
      return(0);
}

/*******************************************************************************************************************************/

int noel1(pixel,constant)
complex pixel,constant;

{
    int counter;
    complex temp,zprev,z;

    z=pixel;
    zprev=constant;
    for (counter = 0; counter < iter;counter++)
    { 
      temp=z;
      z=c_add(c_sqr(z),zprev);
      zprev=temp;
      if (c_module2(z)>bailout)  
                       return(counter);
         }
      return(0); 
   }

/*******************************************************************************************************************************/

int noel2(pixel,constant)
complex pixel,constant;

{
    int counter;
    complex z,zp1,zp2,temp;

    z=c_add(pixel,constant);
    zp1.re=zp1.im=0.0;
    zp2=constant;
    for (counter = 1; counter <= iter;counter++)
     {
      temp=z;
      z=c_sub(c_sqr(z),zp2);
      zp2=zp1;
      zp1=c_conj(temp);
      if (c_module2(z)>bailout)  
                       return(counter);
         }
      return(0); 
   }

/*******************************************************************************************************************************/

int phoenix(pixel,constant)
complex pixel,constant;

{
    int counter;
    complex z,x,y,c,temp;

    z=constant;
    c=pixel;
    y.re=y.im=0.0; 
    for (counter = 1; counter <= iter;counter++)
    {
      x.re=c.im;
      x.im=0.0;
      temp=c_mult(y,x);
      y=z;
      x.re=c.re;
      x.im=0.0; 
      z=c_add(c_add(c_sqr(z),temp),x); 
      if (c_module2(z)>bailout)  
                       return(counter);
         }
      return(0); 
   }

/*******************************************************************************************************************************/

int tetrate(pixel,constant)
complex pixel,constant;

{    
      complex z,c;
      int counter;
 
      c=pixel;
      z=c_add(constant,pixel);
      for(counter=1;counter<=iter;counter++)
    { 
      z=c_raise(c,z,0);
      if(c_module2(z)>bailout)
                 return(counter);
     }
   
   return(0);

}
