/*
  
Copyright (C) 10/1995 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/


#define info_file
#include "main.h"
#include "callbacks.h"
#include "util.h"


/********************************************************************************
 * creates (first call) and pops up an info window
 ********************************************************************************/
void PopupInfo(void){
  static int flag = 0;      /* indicates first call */
  static Widget popup = 0;  /* popup shell widget   */
  Widget dummy;
  short x,y;                /* position             */
  
  if(flag == 0 || popup == 0){
    popup = XtCreatePopupShell("info",
			       transientShellWidgetClass,
			       mainWindow.toplevel, 
			       NULL, 0);
    XtAddCallback(popup, XmNdestroyCallback, DestroyCB, (XtPointer)popup);
    XtVaSetValues(popup,
		  XmNallowShellResize, True,
		  XtNborderWidth,1,
		  NULL);
    dummy = XtVaCreateManagedWidget("info-text", xmPushButtonWidgetClass,
				    popup,
				    XmNalignment, XmALIGNMENT_BEGINNING,
				    NULL);
    XtAddCallback(dummy, XmNactivateCallback, PopdownCB, (XtPointer)popup);
    XtAddCallback(dummy, XmNactivateCallback, DelShadowCB, (XtPointer)2);
    
    flag = 1;
  }
  XtVaGetValues(mainWindow.toplevel,                              /* set pos */
		XmNx, &x, XmNy, &y, NULL);
  XtVaSetValues(popup,
		XmNx, x, XmNy, y, NULL);
  XtPopup(popup,XtGrabNone);
}
