#ifndef _UNSET_H
#define _UNSET_H
/* this header contains definitions of
 * MAIL variables to be unset when initializing.
 *
 * NOTE:
 * This may be site specific, depending on your
 * mailer. This set is known to be good for
 * 4.3BSD Mail, 4.4BSD Mail, Sun (4.1.3 and Solaris),
 * Linux, HP, DEC, IBM, and Silicon Graphics. Its
 * probably OK for your mailer too.
 *
 * MODIFICATIONS:
 * If you would like an option unset, modify the
 * below optionsStruct array (options).
 * The first field is always FALSE, the second is 
 * the string to compare, and the third is the
 * number of characters to compare (using strncmp) to
 * see if the string matches.
 * !! Make sure you set the numOptions define
 *    to match the number of entries in the array.
 *
 *
 */ 
typedef struct optionsStruct {
                Boolean         found;
                char            *name;
                int             len;
} optionsStruct;
 
/* this structure contains a list of options to unset */
#define numOptions 4
static optionsStruct options[numOptions] = {
                {FALSE, "crt", 3},
                {FALSE, "cmd", 3},
                {FALSE, "replyall", 8},
                {FALSE, "Replyall", 8},
} ;
#endif
