/*
** @(#) xmailregexp.h
**
** xmail - X window system interface to the mail program
**
** Copyright 1991,1992 by National Semiconductor Corporation
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of National Semiconductor Corporation not
** be used in advertising or publicity pertaining to distribution of the
** software without specific, written prior permission.
**
** NATIONAL SEMICONDUCTOR CORPORATION MAKES NO REPRESENTATIONS ABOUT THE
** SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS"
** WITHOUT EXPRESS OR IMPLIED WARRANTY.  NATIONAL SEMICONDUCTOR CORPORATION
** DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  IN NO
** EVENT SHALL NATIONAL SEMICONDUCTOR CORPORATION BE LIABLE FOR ANY SPECIAL,
** INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
** LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** Author:  Michael C. Wagnitz - National Semiconductor Corporation
**
*/

#define	XM_C_START		0
#define	XM_C_EXEC		1
#define	XM_C_FILE		2
#define	XM_C_DELETE	3
#define	XM_C_NEWMAIL	4

#ifndef PARSER
extern PatternRec command_pattern[];
#else
PatternRec command_pattern[] = {
    { "^Start",						NULL }, /* 0 */
    {  NULL,						  "" }, /* indx chg */
    { "^[-n]",						NULL }, /* 1 */
    { "^[pPcCsSw] .*",					NULL }, /* 1 */
    { "^hold .*",					NULL }, /* 1 */
    { NULL,						  "" },
    { "^file [^%].*",					NULL }, /* 2 */
    { NULL,						  "" },
    { "^[du].*",					NULL }, /* 3 */
    { NULL,						  "" },
    { "^file %",					NULL }, /* 4 */
    { "^inc",						NULL }, /* 4 */
    { NULL,						NULL },
   };
#endif

#define	XM_O_BELL		0
#define	XM_O_EXEC		1
#define	XM_O_PRINT		2
#define	XM_O_FILE		3

#ifndef PARSER
extern PatternRec output_pattern[];
#else
PatternRec output_pattern[] = {
    { "^At ",						NULL }, /* 0 */
    { "^No ",						NULL }, /* 0 */
    { "^Unknown ",					NULL }, /* 0 */
    { "^Referencing ",					NULL }, /* 0 */
    { "^Cannot ",					NULL }, /* 0 */
    { "^Not ",						NULL }, /* 0 */
    { "^May ",						NULL }, /* 0 */
    { "^\"[^\"]*\" \\[Appended\\] ",			NULL }, /* 0 */
    { "^\"[^\"]*\" \\[New file\\] ",			NULL }, /* 0 */
    { "^\"[^\"]*\" No such file or directory",		NULL }, /* 0 */
    { "^\"[^\"]*\" Invalid argument",			NULL }, /* 0 */
    { "^\"[^\"]*\" Permission denied",			NULL }, /* 0 */
    { "^\"[^\"]*\" The file access permissions do not",	NULL }, /* 0 */
    { "^\"[^\"]*\" Not a directory",			NULL }, /* 0 */
    { "^[0-9][0-9]*: Inappropriate message",		NULL }, /* 0 */
    { "^[0-9][0-9]*: Invalid message number",		NULL }, /* 0 */
    { "^[^:]*: No such file or directory",		NULL }, /* 0 */
    { "^[^:]*: A file or directory in the path name",	NULL }, /* 0 */
    { "^[^:]*: Not a directory",			NULL }, /* 0 */
    { "^[^:]*: not a regular file",			NULL }, /* 0 */
    { "^[^:]*: Cannot write to a directory",		NULL }, /* 0 */
    { "^[^:]*: empty file",				NULL }, /* 0 */
    { "^[^ ]* unreadable",				NULL }, /* 0 */
    { "^[^ ]* not found",				NULL }, /* 0 */
    { "^[^:]*: [^:]*: Permission denied",		NULL }, /* 0 */
    { "^[^:]*: Permission denied",			NULL }, /* 0 */
    { NULL,						  "" },
    { "^From ",						NULL }, /* 1 */
    { "^Message ",					NULL }, /* 1 */
    { NULL,						  "" },
    { "^Pipe to: \"[^\"]*\"",				NULL }, /* 2 */
    { NULL,						  "" },
    { "^Held ",						NULL }, /* 3 */
    { "^\"[^\"]*\": [0-9][0-9]* message.*",		NULL }, /* 3 */
    { "^\"[^\"]*\" complete",				NULL }, /* 3 */
    { "^[^:]*: .*",					NULL }, /* 3 */
    { NULL,						NULL }, /* 3 */
};
#endif
