/*
  Xquote Copyright (c)1997 Mark Buser,
  All Rights Reserved.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xquote, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.3 $ $Date: 1997/10/15 23:36:33 $
*/

#include <stdio.h>

#include <Xm/XmAll.h>

#include "optupdate.h"
#include "pixmap.h"
#include "xutil.h"

static Widget text;

void aboutText( char *news )
{
  XmTextSetString( text, news ); 
}

/* ARGSUSED */
void procAbout( Widget w, int which, XtPointer call_data )
{
  XtPopdown( GetTopShell(w) );
}

/* ARGSUSED */
void aboutCB( Widget w, XtPointer client_data, XtPointer call_data ) 
{
  static Widget About_dialog;
  Widget pane, frame, form, button;
  Dimension height, width, border;
  Arg args[12];
  int n;

  if (About_dialog == NULL) {
    About_dialog = XtVaCreatePopupShell( "About", 
                                        xmDialogShellWidgetClass,
                                        GetTopShell(w),
                                        NULL );

    /*
    ** This allows the frame to work and the buttons to not cause
    ** the dialog to auto unmanage.  Where is this documented?
    */
    pane = XtVaCreateWidget ( "AboutPane", xmPanedWindowWidgetClass,
                              About_dialog,
                              XmNsashWidth, 1,
                              XmNsashHeight, 1,
                              NULL );

    form = XtVaCreateWidget ( "Aboutform", 
                            xmFormWidgetClass, pane, 
                            NULL );


    frame =   XtVaCreateManagedWidget( "Aboutframe",
                            xmFrameWidgetClass, form,
			    XmNtopAttachment, XmATTACH_FORM,
			    XmNleftAttachment, XmATTACH_FORM,
                            NULL);
    XtVaCreateManagedWidget ( "label_0",
                        xmLabelWidgetClass, frame,
                        XmNlabelType, XmPIXMAP,
                        XmNlabelPixmap, GetPixmap(PICON, NORMAL),
                        XmNlabelInsensitivePixmap, GetPixmap(PICON, NORMAL),
                        NULL );

    XtVaCreateManagedWidget ( "label_1",
                        xmLabelWidgetClass, form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, frame,
			XmNrightAttachment, XmATTACH_FORM,
                        NULL );

    frame = XtVaCreateManagedWidget( "newsFrame",
                        xmFrameWidgetClass, form,
                        XmNtopAttachment, XmATTACH_WIDGET,
                        XmNtopWidget, frame,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNrightAttachment, XmATTACH_FORM,
                        NULL);
    XtVaCreateManagedWidget ( "newsLabel",
                        xmLabelWidgetClass, frame,
                        XmNchildType, XmFRAME_TITLE_CHILD,
                        NULL );
    /* Scrolled text holding news */
    n = 0;
    XtSetArg(args[n], XmNscrollVertical,        True); n++;
    XtSetArg(args[n], XmNscrollHorizontal,      False); n++;
    XtSetArg(args[n], XmNeditMode,              XmMULTI_LINE_EDIT); n++;
    XtSetArg(args[n], XmNeditable,              False); n++;
    XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
    XtSetArg(args[n], XmNautoShowCursorPosition,  False); n++;
    XtSetArg(args[n], XmNwordWrap,  True); n++;
    text = XmCreateScrolledText( frame, "newsText", args, n);
    XtManageChild (text);

    XtManageChild (form);

    /* Button to add ok */
    form = XtVaCreateWidget ( "ButForm", xmFormWidgetClass, pane, NULL );
    button = XtVaCreateManagedWidget ( "button_0",
                              xmPushButtonWidgetClass, form,
                              XmNtopAttachment, XmATTACH_FORM,
                              XmNbottomAttachment, XmATTACH_FORM,
                              XmNleftAttachment, XmATTACH_POSITION,
                              XmNrightAttachment, XmATTACH_POSITION,
                              XmNshowAsDefault, True,
                              XmNdefaultButtonShadowThickness, 1,
                              NULL );
    XtAddCallback ( button, XmNactivateCallback,
                    (XtCallbackProc) procAbout, (XtPointer) 0 );
    XtManageChild (form);
    XtManageChild (pane);

    /* Prevent pane from changing size */
    XtVaGetValues ( About_dialog, 
                    XmNwidth, &width,
                    XmNheight, &height,
                    XmNborderWidth, &border,
                    NULL );

    XtVaSetValues ( About_dialog,
                    XmNminWidth,  width +  border,
                    XmNmaxWidth,  width +  border,
                    XmNminHeight, height + border,
                    XmNmaxHeight, height + border,
                    NULL );
  }

  XtManageChild (About_dialog);
  XtPopup (About_dialog, XtGrabNone);
  triggerUpdate (TRIGGER_NEWS, (XtIntervalId) NULL);
}
