/*
  Xquote is copyright 1997 by Mark Buser.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xquote, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.2 $ $Date: 1997/04/06 19:08:25 $
*/

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <Xm/XmAll.h>
#include "server.h"

/* 
** Find first text not in an HTML tag, skip any blanks, return pointer
** to this "clear" text or NULL if no "clear" text.
*/
static char *skipTag ( char *html )
{
  char *look, *end;
  char *result;

  look = html;
  end = html + strlen(html);
  do {
    result = strchr ( look, '>' );  /* find end of tag */
    if (result) {
      result++;                     /* increment past tag */
      while ( result < end && isspace(result[0]))
        result++;                   /* skip white space */

      if ( result < end && (isalnum(result[0]) || strspn(result, "+-")) )    
	return(result);             /* send "clear" text back */
      else
	look = result;
    }
  } while (look && look < end );

  return (NULL);
}

QUERY_STRUCT *findPattern( char *start)
{
  QUERY_STRUCT *result;
  char *cur;

  char *pattern;
  char *nextpattern;

  int i, count, size;

  result = (QUERY_STRUCT *) XtCalloc ( 1, sizeof(QUERY_STRUCT) );
  if (result == (QUERY_STRUCT *)NULL)
    return (result);

  for (i=PRICE; i < NUM_QUERY_VALUES; i++) {
    result->values[i] = NULL; 

    pattern = XtNewString(getServer(i));
    if (pattern) {
      cur = start;
      nextpattern = strtok (pattern, ",");
      do {
	if (strcasecmp(nextpattern, "SKIPH") == 0)
	  cur = skipTag(cur);

	else if (strcasecmp(nextpattern, "SKIPC") == 0)
	  cur++;

	else if (strcasecmp(nextpattern, "DIGIT") == 0) {
          count = strspn (cur, "0123456789,.-+");
	  if (count) {
	    result->values[i] = XtCalloc (count+1, sizeof(char));
	    sprintf ( result->values[i], "%.*s", count, cur);
	    cur += count;
	  }
	} 

	else if (strcasecmp(nextpattern, "OPTHFRACT") == 0) {
	  /* Assume digits <tag> / <tag> digits */
	  char *fract;

          count = strspn (cur, "0123456789,.-+");
	  if (count) {                        /* found a fraction */
	    fract = XtCalloc (count +3, sizeof(char));
	    sprintf (fract, " %.*s/", count, cur);
	    size = strlen(fract);

            cur = skipTag(cur);  /* skiptag will not stop at '/' */
            count = strspn (cur, "0123456789,.");
	    if (count) {                      /* flag as error if 0? */
	      fract = XtRealloc (fract, (size+count+1) * sizeof(char));
	      strncat ( fract, cur, count);
	      fract[size+count] = '\0';
	      size = strlen(fract);
            }
	    if (result->values[i]) {
	      result->values[i] = XtRealloc ( result->values[i], 
		          (strlen(result->values[i]) + size +1) * sizeof(char));
	      strcat ( result->values[i], fract);
	    } else
	      result->values[i] = XtNewString ( fract );
	    XtFree (fract);
	  }
        }

	else if (strcasecmp(nextpattern, "OPTFRACT") == 0) {
	  /* Assume digits / digits */
	  int tag, size = 0;

	  /* check for [0-9/ ]? instead of tag? */
	  tag = strcspn (cur, "<&");
	  if (tag) {
	    if (result->values[i]) {
	      size = strlen (result->values[i]);
	      result->values[i] = XtRealloc ( result->values[i], 
			                      (size + tag +1) * sizeof(char));
	    } else
	      result->values[i] = XtCalloc ( tag +1, sizeof(char) );
	    strncat ( result->values[i], cur, tag);
	    result->values[i][size+tag] = '\0';
	  }
        }

	else if (strcasecmp(nextpattern, "STRING") == 0) {
	  int tag;
	  tag = strcspn (cur, "<&");
	  if (tag) {
	    result->values[i] = XtCalloc (tag +1, sizeof(char));
	    sprintf ( result->values[i], "%.*s", tag, cur);
	  }
	}
	   
	else if (strcasecmp(nextpattern, "NULL") == 0)
	  break;

	else {  /* pattern search */
	  cur = strstr (cur, nextpattern);
	  if (cur)
	    cur += strlen (nextpattern);
	}

      } while ( cur && (nextpattern=strtok(NULL, ",")) );
      XtFree (pattern);
    }
  }
  return (result);
}

/* Free a QUERY_STRUCT contents and the structure itself */
void freePattern (QUERY_STRUCT *data)
{
  int i;

  if (data) {
    for (i=PRICE; i < NUM_QUERY_VALUES; i++)
      XtFree (data->values[i]);
    XtFree ((char *)data);
  }
  return;
}

char *findNews ( char *html )
{
  char *cur, *end, *partial; 
  char *result = NULL;
  int tag, len = 0;
  
  cur = html;

  if ( (cur = strstr (cur, "NAME=\"News\"")) ) /* Find News */
    cur += strlen ("NAME=\"News\"");
  end = strstr (cur, "pagetop.gif");           /* End of section */

  do {
    cur = strstr (cur, "pushpin.gif");         /* Find headline */
    if (cur)
      cur += strlen ("pushpin.gif");
    else
      break;

    cur = skipTag(cur);                        /* Skip to date */

    tag = strcspn (cur, "<&");                 /* Copy to next tag */
    if (tag) {
      partial = XtCalloc (tag +2, sizeof(char));
      sprintf( partial, "%.*s\n", tag, cur);

      result = XtRealloc (result, len + strlen(partial) +1);

      if (len == 0)
        strcpy( result, partial );
      else
        strcat( result, partial );
      len += strlen(partial);

      XtFree( partial );
    }
  } while (cur < end);

  return (result);
}
