/*
  Xquote is copyright 1997 by Mark Buser.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xquote, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.2 $ $Date: 1997/04/06 19:05:38 $
*/
#ifndef SERVER_H
#define SERVER_H

#define TITLE   0
#define URL     1
#define PRICE   2
#define CHANGE  3
#define VOLUME  4
#define DAILYL  5
#define DAILYH  6
#define EXDIV   7
#define L52     8
#define H52     9
#define PE      10
#define DIV     11
#define YIELD   12
#define DATE    13
#define TIME    14
#define NAME    15
#define NUM_QUERY_VALUES NAME+1

typedef struct query_struct {
  char *values[NUM_QUERY_VALUES];
} QUERY_STRUCT;

typedef struct server_struct {
  char *title;
  int num_types;
  QUERY_STRUCT **types;
} SERVER_STRUCT;


int readServerDatabase(Widget, char *);
void setCurServer (int);
int getCurServer ();
void setServerType (int);
char *getServerTitle (int);
char *getServer (int);
int numServer ();
int numServerType ();
void serverCB (Widget, XtPointer, XtPointer);

void getProxy ( char **, int *);
void setProxy ( char *, char *);
#endif
