/*
  Xquote is copyright 1997 by Mark Buser.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xquote, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.5 $ $Date: 1997/09/24 00:32:05 $
*/
#include <errno.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include <Xm/Xm.h>

#include "status.h"
#include "util.h"

void syntax(int argc, char **argv)
{
  if (argc != 1)
    fprintf (stderr, "%s: unknown option \"%s\"\n", argv[0], argv[1]);
  fprintf (stderr, "usage: %s [options ...]\n", argv[0]);
  fprintf (stderr, 
           "where options include:\n\n"
           "-help               to print this message,\n"
           "-install            to install a private colormap,\n"
           "-tape               tape display with no menu bar,\n"
           "-restore filename   to restore a saved state,\n"
           "or any valid X toolkit option.\n\n");
}


/* All I want is the lousy max path length, why is this a good thing? */
#ifdef PATH_MAX
static int pathmax = PATH_MAX;
#else
static int pathmax = 0;
#endif

#define PATH_MAX_GUESS 1024

int path_length ()
{
   if (pathmax == 0) {
     if ((pathmax = pathconf ("/", _PC_PATH_MAX)) < 0) 
       pathmax = PATH_MAX_GUESS;
     else
       pathmax++;
   }

   return (pathmax);
}

/*
** Host Specific Support
*/

/* Supplied by Cube-X */
#ifdef NeXT

extern char *getwd (char *pathname);

char *getcwd ( char *buf, size_t size)
{
  char realBuffer[MAXPATHLEN+1];
  int length;

  if (getwd(realBuffer) == NULL) {
    errno = EACCES;
    return NULL;
  }
  length = strlen(realBuffer);
  if (length >= size) {
    errno = ERANGE;
    return NULL;
  }
  strcpy (buf, realBuffer);
  return buf;
}

char *strdup ( const char *src)
{
  char *copy = (char *) malloc(strlen(src)+1);
  if (copy)
    strcpy(copy, src);
  return copy;
}
#endif


/* Unixware needs this. Supplied by Thanh Ma. */
#ifdef NEED_STRCASECMP

int
strncasecmp(char *s1, char *s2,int n)
{
    register int c1, c2,l=0;

    while (*s1 && *s2 && l<n) {
    c1 = tolower(*s1);
    c2 = tolower(*s2);
    if (c1 != c2)
        return (c1 - c2);
    s1++;
    s2++;
    l++;
    }
    return (int) (0);
}

int
strcasecmp(char *s1, char *s2)
{
    register int c1, c2;

    while (*s1 && *s2) {
    c1 = tolower(*s1);
    c2 = tolower(*s2);
    if (c1 != c2)
        return (c1 - c2);
    s1++;
    s2++;
    }
    return (int) (*s1 - *s2);
}
#endif


#if defined(__FreeBSD__) || defined (NEED_STRPTIME)

/* Weird, FreeBSD and IRIX 5 don't have this, but do have strftime. 
** This is a crippled implementation, only supporting the formats
** actually used in the rest of Xquote.  Note that the return _value_
** does not conform to the man page either.
*/
char *strptime ( char* buf, char *fmt, struct tm *tm )
{
  char err_msg[128];

  if ( strcmp( fmt, "%m/%d/%y" ) == 0 ) 
    sscanf ( buf, "%d/%d/%d", &tm->tm_mon, &tm->tm_mday, &tm->tm_year );

  else if (strcmp ( fmt, "%m/%d/%Y" ) == 0 ) {
    sscanf ( buf, "%d/%d/%d", &tm->tm_mon, &tm->tm_mday, &tm->tm_year );
    tm->tm_year -= 1900;

  } else if (strcmp ( fmt, "%m %d %y" ) == 0 ) 
    sscanf ( buf, "%d %d %d", &tm->tm_mon, &tm->tm_mday, &tm->tm_year );

  else {
    sprintf ( err_msg, "Xquote internal error: strptime.  Unsupported\n"
                      "format: \"%s\".  See Reporting Bugs.", fmt);
    write_status( err_msg, ERR);
  }

  tm->tm_mon--;  /* Months are from 0-11, mdays from 1-31, years since 1900 */

  return NULL;  /* completely bogus return value, but I don't use it */
}
#endif


#ifdef NEED_STRERROR
/* Supplied by Benoit Pirenne <bpirenne@eso.org> */

#include <errno.h>

extern char *sys_errlist[];
extern int  sys_nerr;
 
char *strerror (errnum)
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE Retrieve the corresponding msg for an given errno
.REMARK  Only useful on SunOS. Service provided on Solaris!
----------------------------------------------------------------------------*/
int errnum;                   /* IN: errno value */
{
    char *p;
 
    if ( errnum <= 0 ) p = "";
    else
      if ( errnum <= sys_nerr)
        p = sys_errlist[errnum];
 
    return p;
}
#endif
