/*
  Xquote Copyright (c)1997 Mark Buser,
  All Rights Reserved.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xquote, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.10 $ $Date: 1997/10/16 00:18:24 $
*/

#include <stdio.h>
#include <time.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <Xm/XmAll.h>

#ifdef EDITRES
#include <X11/Xmu/Editres.h>
#endif

#include "about.h"
#include "color.h"
#include "file.h"
#include "help.h"
#include "optdetail.h"
#include "option.h"
#include "pixmap.h"
#include "server.h"
#include "session.h"
#include "status.h"
#include "tape.h"
#include "view.h"
#include "util.h"
#include "xquoteP.h"
#include "xutil.h"

/* Externs */
extern Widget Detail_dialog;

/* Globals */
XFontStruct *large;

Widget Toplevel;
Widget Menubar;
Widget Viewmenu;
Widget Heading;
Widget Scroll;
Widget Container;
Widget Tape;
Widget StatusLabel;
Widget ProgressBar;

char *version = "Xquote 1.1";

static MENUITEMS file[] = {
 { "button_0",    XmVaPUSHBUTTON, fileCB },
 { "button_1",    XmVaPUSHBUTTON, fileCB },
 { "separator_0", XmVaSEPARATOR,  NULL },
 { "button_2",    XmVaPUSHBUTTON, fileCB },
 { "button_3",    XmVaPUSHBUTTON, fileCB },
 { "button_4",    XmVaPUSHBUTTON, fileCB },
 { "separator_1", XmVaSEPARATOR,  NULL },
 { "button_5",    XmVaPUSHBUTTON, fileCB },
};

static MENUITEMS option[] = {
 { "button_0",    XmVaPUSHBUTTON, optionCB },
 { "button_1",    XmVaPUSHBUTTON, optionCB },
 { "button_2",    XmVaPUSHBUTTON, optionCB },
 { "button_3",    XmVaPUSHBUTTON, optionCB },
 { "button_4",    XmVaPUSHBUTTON, optionCB }
};

static MENUITEMS view[] = {
 { "button_0",    XmVaRADIOBUTTON, viewCB },
 { "button_1",    XmVaRADIOBUTTON, viewCB },
};

static MENUITEMS help[] = {
 { "button_0",    XmVaPUSHBUTTON, aboutCB },
 { "button_1",    XmVaPUSHBUTTON, helpCB }
};

void main (int argc, char **argv)
{

  XtAppContext app;

  /* application resources */
  AppData appdata;

  /* Main Window Widgets */
/*  Widget Toplevel; */
  Widget Mainform;
/* Widget Menubar; */
    Widget Filemenu;
/*  Widget Viewmenu; */
   Widget Workform;
/*  Widget Heading; */
/*  Widget Scroll; */
/*   Widget Container; */
/*  Widget Tape; */
     Widget popup;
    Widget StatusForm;
     Widget StatusFrame;
/*    Widget StatusLabel; */
     Widget ProgressFrame;
/*    Widget ProgressBar; */

  /* Display */
  Display *dpy;

  /* Window */
  Window win;

  /* Color resources */
  Colormap cmap;
  GC       gc;

  /* Font resources */
  XmFontContext fontContext;

  /* array of resources */
  int n;
  Arg args[15];

  Widget w;  /* temporary widget handle */

  /* Initialize toolkit */
  XtSetLanguageProc (NULL, NULL, NULL);

#if XtSpecificationRelease > 5
  /* R6 session shell supports session management */
  Toplevel = XtVaOpenApplication( &app, "Xquote",
                                  options, XtNumber(options), 
                                  &argc, argv, 
                                  getFallbackResource(), 
                                  sessionShellWidgetClass, NULL);
  /* These callbacks are required */
  XtAddCallback (Toplevel, XtNsaveCallback, sessSave, 0);
  XtAddCallback (Toplevel, XtNcancelCallback, sessResume, 0);
  XtAddCallback (Toplevel, XtNsaveCompleteCallback, sessResume, 0);
  XtAddCallback (Toplevel, XtNdieCallback, sessDie, 0);

#else
  /* Old style WM_SAVE_YOURSELF property method of save state notification */
  Toplevel = XtVaAppInitialize( &app, "Xquote",
                                options, XtNumber(options), &argc, argv, 
                                getFallbackResource(), NULL);
  {
     Atom XaWmSaveYourself = XmInternAtom ( XtDisplay (Toplevel), 
		                            "WM_SAVE_YOURSELF", False);
     XmAddWMProtocols ( Toplevel, &XaWmSaveYourself, 1);
     XmAddWMProtocolCallback ( Toplevel, XaWmSaveYourself, sessSave, 0);
  }
#endif

  XmRepTypeInstallTearOffModelConverter();
  XtVaGetApplicationResources ( Toplevel, 
                                &appdata, 
                                resources, 
                                XtNumber( resources ),
                                NULL );

  /* If help, print syntax and exit */
  if (appdata.help) {
    syntax (argc, argv);
    exit(0);
  }

  /* Build database of quote servers and how to access data */
  if (readServerDatabase (Toplevel, argv[0]) == 0) {
    fprintf ( stderr, 
	      "%s - No servers in database! This means that Xquote.ad\n"
	      "is missing or corrupt, AND Xquote was built with a corrupt\n"
	      "defaults.h; recommend getting new source and rebuilding.\n",
	      argv[0] );
    exit(1);
  }

#ifdef EDITRES
  XtAddEventHandler( Toplevel, 0, True, _XEditResCheckMessages, NULL);
#endif

  dpy = XtDisplay( Toplevel );
  win = RootWindowOfScreen (XtScreen(Toplevel));
  cmap = DefaultColormapOfScreen (XtScreen(Toplevel));
  gc = XCreateGC ( dpy, win, 0, NULL );

  if (appdata.install)
    cmap = NewColormap (dpy, cmap );

  cmap = InitColor ( Toplevel, cmap, NULL );
  if ( cmap == (Colormap)NULL) {
     fprintf( stderr, "Error: can't create XColor colormap, exiting.\n");
     exit(1);
  }

  /* Set the colormap */
  XtVaSetValues ( Toplevel, XmNcolormap, cmap, NULL );

  /* Get fonts for ticker tape */
  large = NULL;
  if ( XmFontListInitFontContext ( &fontContext, appdata.font_list ) == True ) {
    XmFontListEntry entry;
    XmFontType      fonttype =  XmFONT_IS_FONT;
    char *tag;

    while ( (entry = XmFontListNextEntry ( fontContext )) != NULL ) {

       tag = XmFontListEntryGetTag ( entry );
       if ( strcmp( tag, "large") == 0 )
         large = (XFontStruct *) XmFontListEntryGetFont ( entry, &fonttype );

       if ( tag != NULL )
         XtFree (tag);

    }

    XmFontListFreeFontContext ( fontContext );
  }
  /**********************/

  /* Create the main window */
  Mainform = XtVaCreateWidget( "Mainform", xmFormWidgetClass, Toplevel,        
                                XmNresizable,             True,
        		        NULL );

  /* Load up all of the pixmaps. Why here? Because Toplevel may have a
  ** bogus background color.  We can't load a "good" colormap till after
  ** its up.  This is the first widget with a likely allocated bg color. 
  */
  cmap = InitPixmaps( Mainform, cmap);
  if ( cmap == (Colormap)NULL) {
     fprintf( stderr, "Error: can't create Pixmap colormap, exiting.\n");
     exit(1);
  }


  /* Set the icon */
  MakeIconWindow ( Toplevel );

  /**********************/
 
  if (!appdata.tape) {
    /* Create menu bar and pulldown menus */
    n = 0;
    XtSetArg(args[n], XmNtopAttachment,   XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment,   XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment,   XmATTACH_FORM); n++;
    Menubar =  XmCreateMenuBar ( Mainform, "Menubar", args, n );

    XtVaCreateManagedWidget("button_0",xmCascadeButtonGadgetClass,Menubar,NULL);
    XtVaCreateManagedWidget("button_1",xmCascadeButtonGadgetClass,Menubar,NULL);
    XtVaCreateManagedWidget("button_2",xmCascadeButtonGadgetClass,Menubar,NULL);
    XtVaCreateManagedWidget("button_3",xmCascadeButtonGadgetClass,Menubar,NULL);

    /* Set help menu */
    if ( (w = XtNameToWidget (Menubar, "button_3")) )
      XtVaSetValues( Menubar, XmNmenuHelpWidget, w, NULL);

    /* 
    ** File menu 
    */
    Filemenu = makeMenuPulldown (Menubar, "Filemenu", 0, file, XtNumber(file));
    if ( (w = XtNameToWidget (Filemenu, "button_3")) )
      XtSetSensitive (w, False);
    if ( (w = XtNameToWidget (Filemenu, "button_4")) )
      XtSetSensitive (w, False);
    /* 
    ** Option menu 
    */
    makeMenuPulldown ( Menubar, "Optionmenu", 1, option, XtNumber(option) );
    /*
    ** View menu
    */
    Viewmenu = makeMenuPulldown (Menubar, "Viewmenu", 2, view, XtNumber(view));
    /* 
    ** Help menu 
    */
    makeMenuPulldown ( Menubar, "Helpmenu", 3, help, XtNumber(help) );

    XtManageChild (Menubar);
  }
   
  /**********************/

  /* Create work area form */
  if (!appdata.tape)
    Workform = XtVaCreateWidget ( "Workform", xmFormWidgetClass, Mainform, 
			        XmNtopAttachment,    XmATTACH_WIDGET,
                                XmNtopWidget,        Menubar,
			        XmNleftAttachment,   XmATTACH_FORM,
			        XmNrightAttachment,  XmATTACH_FORM,
                                XmNbottomAttachment, XmATTACH_FORM,
			        NULL );
  else
    Workform = XtVaCreateWidget ( "Workform", xmFormWidgetClass, Mainform, 
			        XmNtopAttachment,    XmATTACH_FORM,
			        XmNleftAttachment,   XmATTACH_FORM,
			        XmNrightAttachment,  XmATTACH_FORM,
                                XmNbottomAttachment, XmATTACH_FORM,
			        NULL );
  /**********************/

  /*
  ** Workform displays either the scrolled window or tape display
  */
  if (!appdata.tape) {
    /* 
    ** Make a scrolled window
    */
    /* Rowcolumn holding ticker header */
    Heading = XtVaCreateWidget ( "Heading", xmRowColumnWidgetClass, Workform,
                               XmNnumColumns, 1,
                               XmNorientation, XmHORIZONTAL,
                               XmNpacking, XmPACK_COLUMN,
                               XmNtopAttachment, XmATTACH_FORM,
                               XmNleftAttachment, XmATTACH_FORM,
                               XmNrightAttachment, XmATTACH_FORM,
                               NULL );
    XtManageChild (Heading);

    /* Scrolled rowcolumn holding data */
    Scroll = XtVaCreateManagedWidget ( "Scroll", 
                                 xmScrolledWindowWidgetClass, Workform,
                                 XmNscrollingPolicy, XmAUTOMATIC,
                                 XmNtopAttachment, XmATTACH_WIDGET,
                                 XmNtopWidget, Heading,
                                 XmNleftAttachment, XmATTACH_FORM,
                                 XmNrightAttachment, XmATTACH_FORM,
                                 NULL);
#if 0
    XtAddCallback ( Graphvscroll, 
                    XmNtraverseObscuredCallback, graphTraverse,
                    NULL );
#endif
    Container = XtVaCreateWidget ( "Container", xmRowColumnWidgetClass, Scroll,
                                   NULL );
    XtManageChild (Container);
  }


  /*
  ** Drawing Area to hold ticker tape
  */
  Tape = XtVaCreateWidget ( "Tape",
                            xmDrawingAreaWidgetClass, Workform,
                            XmNtopAttachment, XmATTACH_FORM,
                            XmNleftAttachment, XmATTACH_FORM,
                            XmNrightAttachment, XmATTACH_FORM,
                            NULL );
  XtAddCallback( Tape, XmNexposeCallback,
                 (XtCallbackProc) drawTape, (XtPointer) NULL);
#if 0
  XtAddCallback( Graph, XmNinputCallback,
                   (XtCallbackProc) redrawDrawing, (XtPointer) NULL);
#endif

  /* Tell tape some things it needs to know */
  initTape (Tape, gc);

  /* Make popup menu mirroring option menu, except no detail dialog */
  popup = makeMenuPulldown ( Tape, "Optionmenu", 0, 
		             option, XtNumber(option)-1 );
  XtAddEventHandler (Tape, ButtonPressMask, False, 
                     (XtEventHandler)PostIt, popup );

  /* Build the detail dialog now so we can set heading label */ 
  Detail_dialog = createDetailDialog ();
  detailSetState ( 0xF );

  /*
  ** Status line and progress bar
  */
  StatusForm = XtVaCreateWidget( "StatusForm", xmFormWidgetClass, Workform,
                           XmNleftAttachment, XmATTACH_FORM,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNbottomAttachment, XmATTACH_FORM,
                           NULL );

  StatusFrame = XtVaCreateManagedWidget( "StatusFrame",
                                   xmFrameWidgetClass, StatusForm,
                                   XmNtopAttachment, XmATTACH_FORM,
                                   XmNleftAttachment, XmATTACH_FORM,
                                   XmNbottomAttachment, XmATTACH_FORM,
                                   NULL);

  StatusLabel = XtVaCreateManagedWidget("StatusLabel",
                                        xmLabelWidgetClass, StatusFrame,
                                        NULL);


  if (appdata.tape)
    XtVaSetValues ( StatusFrame, XmNrightAttachment, XmATTACH_WIDGET, NULL);
  else {
    ProgressFrame = XtVaCreateManagedWidget( "ProgressFrame",
                                   xmFrameWidgetClass, StatusForm,
                                   XmNtopAttachment, XmATTACH_FORM,
                                   XmNrightAttachment, XmATTACH_FORM,
                                   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);

    /* Keep ProgressFrame from horizontal resize */
    XtVaSetValues ( StatusFrame,
                  XmNrightAttachment, XmATTACH_WIDGET,
                  XmNrightWidget, ProgressFrame,
                  NULL);

    ProgressBar = XtVaCreateManagedWidget("ProgressBar",
                           xmScrollBarWidgetClass, ProgressFrame,
                           XmNeditable, False,
                           XmNminimum, 0,
                           XmNmaximum, 100,
                           XmNorientation, XmHORIZONTAL,
                           XmNshowArrows, XmNONE,
                           XmNsliderSize, 100,
                           XmNwidth, 100,
                           XmNshadowThickness, 0,
                           NULL);
  }

  /* Keep Form from vertical resize */
  if (!appdata.tape)
    XtVaSetValues ( Scroll,
                    XmNbottomAttachment, XmATTACH_WIDGET,
                    XmNbottomWidget, StatusForm,
                    NULL);
  XtVaSetValues ( Tape,
                  XmNbottomAttachment, XmATTACH_WIDGET,
                  XmNbottomWidget, StatusForm,
                  NULL);

  write_status_line ( version );

  if (appdata.tape)
    XtManageChild (Tape);

  XtManageChild( StatusForm );
  XtManageChild( Workform );
  XtManageChild( Mainform );

  XtRealizeWidget ( Toplevel );

  if (appdata.restore)
    restoreState (appdata.restore);

  /* Update here since restore may have changed the detail settings */
  detailAddMainWindow();

  XtAppMainLoop ( app );
}
