.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH XScreenSaver 1 "16-Jan-98" "X Version 11"
.SH NAME
xscreensaver - graphics hack and screen locker, launched when the user is idle
.SH SYNOPSIS
.B xscreensaver
[\-display \fIhost:display.screen\fP] [\-timeout \fIint\fP] [\-cycle \fIint\fP] [\-nice \fIint\fP] [\-lock] [\-no\-lock] [\-lock\-timeout \fIint\fP] [\-demo] [\-visual \fIvisual\fP] [\-install] [\-no\-install] [\-verbose] [\-silent] [\-xidle\-extension] [\-no\-xidle\-extension] [\-sgi\-extension] [\-no\-sgi\-extension] [\-mit\-extension] [\-no\-mit\-extension] [\-xrm \fIresources\fP]
.SH DESCRIPTION
The \fIxscreensaver\fP program waits until the keyboard and mouse have been 
idle for a period, and then runs a graphics demo chosen at random.  It 
turns off as soon as there is any mouse or keyboard activity.

This program can lock your terminal in order to prevent others from using it,
though its default mode of operation is merely to display pretty pictures on
your screen when it is not in use.  

The benefit that this program has over the combination of the
.BR xlock (1)
and
.BR xautolock (1)
programs is the ease with which new graphics hacks can be installed.  You
don't need to recompile (or even re-run) this program to add a new display
mode.
.SH GETTING STARTED
For the impatient, try this:
.EX
        xscreensaver &
        xscreensaver-command -demo
.EE
After a few seconds, the screen should go black, and a dialog box should
appear in the upper right corner.  This is \fIDemo Mode\fP.
.SH DEMO MODE
If \fIxscreensaver\fP receives the \fBDEMO\fP ClientMessage, which is done
by running the
.BR xscreensaver\-command (1)
program with the \fB\-demo\fP option, the screensaver will black the screen
and pop up a dialog box from which you can examine and experiment with the
client programs.

The dialog box contains a scrolling list, a text field, and a number of 
buttons.  

Double-clicking on one of the programs in the list will run it.  The dialog
box will disappear, allowing the program access to the full screen.  Clicking
the mouse again will bring the dialog box back.

Single-clicking in the list will place the indicated program and its args
in the text field to be edited.  Edit the arguments and hit return to run
the program with the parameters you have specified.  (Note that these are
one-time changes and won't be remembered; to make the changes permanent,
you need to edit your X resource file.)

The buttons are:
.TP 8
.B Run Next
Clicking this button will run the next program in the list after the 
currently-selected one, and will scroll around to the top when it reaches
the bottom.
.TP 8
.B Run Previous
Opposite of Run Next; at the top, it scrolls around to the bottom.
.TP 8
.B Edit Parameters
This pops up a second dialog box, in which you have the option to 
interactively change most of the screensaver's operational parameters,
such as its timeouts, and whether it should lock the screen.  Changing 
these parameters here will affect only the running \fIxscreensaver\fP 
process; to make the changes permanent, you need to edit your X resource
file.  (See below.)
.TP 8
.B Exit Demo Mode
Returns to normal screensaver operation.
.TP 8
.B Reinitialize
This causes the X resource database to be re-read, to pick up any changes
you might have made.  This works by causing the screensaver process to exit
and then restart itself with the same command-line arguments.  This is just
like the \fI\-restart\fP argument to 
.BR xscreensaver\-command (1)
except that when executed from this button, the screensaver will 
automatically return to demo mode after restarting.
.SH OPTIONS
.I xscreensaver
accepts the following command line options:
.TP 8
.B \-timeout \fIminutes\fP
The screensaver will activate after the keyboard and mouse have been idle
for this many minutes.  Default 10.
.TP 8
.B \-cycle \fIminutes\fP
After the screensaver has been running for this many minutes, the currently
running graphics hack sub-process will be killed (with \fBSIGTERM\fP), and a
new one started.  If this is 0, then the graphics hack will not be changed:
only one demo will run until the screensaver is deactivated by user activity.
Default 10.
.TP 8
.B \-nice \fIinteger\fP
The sub-processes created by \fIxscreensaver\fP will be ``niced'' to this
level, so that they are given lower priority than other processes on the
system, and don't increase the load unnecessarily.  The default is 20.  

(Higher numbers mean lower priority; see 
.BR nice (1)
for details.)
.TP 8
.B \-lock
Enable locking: before the screensaver will turn off, it requires you to
type the password of the person who launched the screensaver, or the root
password.  (Note: this doesn't work if the screensaver is launched
by
.BR xdm (1)
because it can't know the user-id of the logged-in user.)
.TP 8
.B \-no\-lock
Disable locking.  This is the default.
.TP 8
.B \-lock\-timeout \fIminutes\fP
This is how long after the screensaver activates that locking is enabled.
For example, if this is 5, and \fI\-timeout\fP is 10, then after 10 minutes,
the screen would blank.  If there was user activity at 12 minutes, no password
would be required.  But, if there was user activity at 15 minutes or later 
(\fI\-lock\-timeout\fP minutes after activation) then a password would be
required.  The default is 0, meaning that if locking is enabled, then
a password will be required as soon as the screensaver activates.
.TP 8
.B \-demo
Enter the interactive demo mode immediately after startup.  Normally
demo mode is invoked via the
.BR xscreensaver\-command (1)
program, but this is a shortcut for new users.  See below for a description
of how demo-mode works.
.TP 8
.B \-visual \fIvisual\fP
Specify which X visual to use by default.  Legal values are:
.RS 8
.TP 8
.B default
Use the screen's default visual (the visual of the root window.)  
This is the default.
.TP 8
.B best
Use the visual which supports the most colors.  Note, however, that the
visual with the most colors might be a TrueColor visual, which does not
support colormap animation.  Some programs have more interesting behavior
when run on PseudoColor visuals than on TrueColor.
.TP 8
.B mono
Use a monochrome visual, if there is one.
.TP 8
.B gray
Use a grayscale or staticgray visual, if there is one and it has more than
one plane (that is, it's not monochrome.)
.TP 8
.B color
Use the best of the color visuals, if there are any.
.TP 8
.I class
where \fIclass\fP is one of \fBStaticGray\fP, \fBStaticColor\fP, 
\fBTrueColor\fP, \fBGrayScale\fP, \fBPseudoColor\fP, or \fBDirectColor\fP.
Selects the deepest visual of the given class.
.TP 8
.I number
where \fInumber\fP (decimal or hex) is interpreted as a visual id number, 
as reported by the
.BR xdpyinfo (1)
program; in this way you can have finer control over exactly which visual
gets used, for example, to select a shallower one than would otherwise
have been chosen.

.RE
.RS 8
Note that this option specifies only the \fIdefault\fP visual that will
be used: the visual used may be overridden on a program-by-program basis.
See the description of the \fBprograms\fP resource, below.
.RE
.TP 8
.B \-install
Install a private colormap while the screensaver is active, so that the
graphics hacks can get as many colors as possible.  This is the 
default.  (This only applies when the screen's default visual is being
used, since non-default visuals get their own colormaps automatically.)
This can also be overridden on a per-hack basis: see the discussion of
the \fBdefault\-n\fP name in the section about the \fBprograms\fP resource.
.TP 8
.B \-no\-install
Use the default colormap.
.TP 8
.B \-verbose
Print diagnostics.
.TP 8
.B \-silent

.TP 8
.B \-xidle\-extension
Use the \fBXIDLE\fP server extension to decide whether the user is idle.
This is the default if \fIxscreensaver\fP has been compiled with support
for this extension.  On X11R4 or X11R5 systems, the XIdle method is faster 
and more reliable than what will be done otherwise, so use it if you can.
.TP 8
.B \-no\-xidle\-extension
Don't use the \fBXIDLE\fP server extension.
.TP 8
.B \-sgi\-extension
Use the SGI \fBSCREEN_SAVER\fP server extension to decide whether the user
is idle.  This is the default if \fIxscreensaver\fP has been compiled with
support for this extension (which is the default on SGI systems.).  If it
is available, the \fBSCREEN_SAVER\fP method is faster and more reliable than
what will be done otherwise, so use it if you can.
.TP 8
.B \-no\-sgi\-extension
Don't use the SGI \fBSCREEN_SAVER\fP server extension.
.TP 8
.B \-mit\-extension
Use the \fBMIT\-SCREEN\-SAVER\fP server extension to decide whether the user
is idle.  This is the default if \fIxscreensaver\fP has been compiled with
support for this extension.  However, this extension is flaky, so it's use 
is not really recommended.  (It also makes the \fIfade\fP option not work
properly.)
.TP 8
.B \-no\-mit\-extension
Don't use the \fBMIT\-SCREEN\-SAVER\fP server extension.
.SH X RESOURCES
\fIxscreensaver\fP understands the following resources:
.PP
.TP 8
.B timeout\fP (class \fBTime\fP)
Same as the \fI\-timeout\fP command-line option.  Default 10 minutes.
.TP 8
.B cycle\fP (class \fBTime\fP)
Same as the \fI\-cycle\fP command-line option.  Default 10 minutes.
.TP 8
.B nice\fP (class \fBNice\fP)
Same as the \fI\-nice\fP command-line option.  Default 10.
.TP 8
.B lock\fP (class \fBBoolean\fP)
Same as the \fI\-lock\fP command-line option.
.TP 8
.B lockTimeout\fP (class \fBTime\fP)
Same as the \fI\-lock\-timeout\fP command-line option.
.TP 8
.B passwdTimeout\fP (class \fBTime\fP)
If the screen is locked, then this is how many seconds the password dialog box
should be left on the screen before giving up (default 30.)  This should not
be too large: the X server is grabbed for the duration that the password
dialog box is up (for security purposes) and leaving the server grabbed for
too long can cause problems.
.TP 8
.B verbose\fP (class \fBBoolean\fP)
Same as the \fI\-verbose\fP command-line option.
.TP 8
.B xidle\fP (class \fBBoolean\fP)
Same as the \fI\-xidle\fP command-line option.
.TP 8
.B fade\fP (class \fBBoolean\fP)
If this is true, then when the screensaver activates, the current contents
of the screen will fade to black instead of simply winking out.  This only
works on displays with writable colormaps, that is, if the screen's default
visual is a PseudoColor visual.  Default true.  A fade will also be done when
switching graphics hacks (when the \fIcycle\fP timer expires.)
.TP 8
.B unfade\fP (class \fBBoolean\fP)
If this is true, then when the screensaver deactivates, the original contents
of the screen will fade in from black instead of appearing immediately.  This
only works on displays with writable colormaps, and if \fIfade\fP is true
as well.  Default false.
.TP 8
.B fadeSeconds\fP (class \fBTime\fP)
If \fIfade\fP is true, this is how long the fade will be in 
seconds (default 3.)
.TP 8
.B fadeTicks\fP (class \fBInteger\fP)
If \fIfade\fP is true, this is how many times a second the colormap will
be changed to effect a fade.  Higher numbers yield smoother fades, but
may make the fades take longer than the specified \fIfadeSeconds\fP if
your server isn't fast enough to keep up.  Default 20.
.TP 8
.B visualID\fP (class \fBVisualID\fP)
Same as the \fI\-visual\fP command-line option.  Default \fBdefault\fP.
.TP 8
.B installColormap\fP (class \fBBoolean\fP)
Same as the \fI\-install\fP command-line option.  Default true.
.TP 8
.B captureStderr\fP (class \fBBoolean\fP)
Whether \fIxscreensaver\fP should redirect its standard-error stream to the
window itself.  Since its nature is to take over the screen, you would not
normally see error messages generated by the screensaver or the programs it
runs; this resource will cause the output of all relevant programs to be
drawn on the screensaver window itself instead of written to the controlling
terminal of the screensaver driver process.  Default true.
.TP 8
.B captureStdout\fP (class \fBBoolean\fP)
Like \fBcaptureStderr\fP but for the standard-output stream.  Default true.
.TP 8
.B font\fP (class \fBFont\fP)
The font used for the stdout/stderr text, if \fBcaptureStdout\fP or
\fBcaptureStderr\fP are true.  Default \fB*\-medium\-r\-*\-140\-*\-m\-*\fP
(a 14 point fixed-width font.)
.TP 8
.B textForeground\fP (class \fBForeground\fP)
The foreground color used for the stdout/stderr text, if \fBcaptureStdout\fP 
or \fBcaptureStderr\fP are true.  Default: Yellow.
.TP 8
.B textBackground\fP (class \fBBackground\fP)
The background color used for the stdout/stderr text, if \fBcaptureStdout\fP 
or \fBcaptureStderr\fP are true.  Default: Black.
.TP 8
.B programs\fP (class \fBPrograms\fP)
The graphics hacks which \fIxscreensaver\fP runs when the user is idle.
The value of this resource is a string, one \fIsh\fP-syntax command per line.  
Each line must contain exactly one command -- no semicolons, no ampersands.

When the screensaver starts up, one of these is selected at random, and
run.  After the \fIcycle\fP period expires, it is killed, and another
is selected and run.

If the value of this resource is empty, then no programs will be run; the
screen will simply be made black.

If the display has multiple screens, then a different program will be run 
for each screen.

Note that you must escape the newlines; here is an example of how you
might set this in your \fI.Xdefaults\fP file:

.RS 8
.EX
xscreensaver.programs:  \\
        qix -root                          \\n\\
        ico -r -faces -sleep 1 -obj ico    \\n\\
        xdaliclock -builtin2 -root         \\n\\
        xv -root -rmode 5 image.gif -quit  \\n
.EE
.RE
.RS 8
Make sure your \fB$PATH\fP environment variable is set up correctly
\fIbefore\fP xscreensaver is launched, or it won't be able to find the
programs listed in the \fIprograms\fP resource.

To use a program as a screensaver, two things are required: that that
program draw on the root window (or be able to be configured to draw on
the root window); and that that program understand ``virtual root''
windows, as used by virtual window managers such as \fItvtwm\fP.  (Generally,
this is accomplished by just including the \fI"vroot.h"\fP header file in
the program's source.)

If there are some programs that you want to run only when using a color
display, and others that you want to run only when using a monochrome
display, you can specify that like this:

.EX
        mono:   mono-program  -root        \\n\\
        color:  color-program -root        \\n\\
.EE
.RE
.RS 8
More generally, you can specify the kind of visual that should be used for
the window on which the program will be drawing.  For example, if one 
program works best if it has a colormap, but another works best if it has
a 24-bit visual, both can be accommodated:

.EX
        PseudoColor: cmap-program  -root   \\n\\
        TrueColor:   24bit-program -root   \\n\\
.EE
.RE
.RS 8
(This sort of thing used to be accomplished with the \fIcolorPrograms\fP
and \fImonoPrograms\fP resources, but those resources have now been removed;
a warning will be issued if they are used.)

In addition to the symbolic visual names described above (in the section
about the \fI\-visual\fP command-line option) one other visual name is
supported in the \fIprograms\fP list:
.RS 1
.TP 4
.B default-n
This is like \fBdefault\fP, but also requests the use of the default colormap,
instead of a private colormap.  (That is, it behaves as if 
the \fI\-no\-install\fP command-line option was specified, but only for
this particular hack.)  This is provided because some third-party programs
that draw on the root window make assumptions about the visual and colormap
of that window: assumptions which xscreensaver can violate.

.RE
If you specify a particular visual for a program, and that visual does not
exist on the screen, then that program will not be chosen to run.  This
means that on displays with multiple screens of different depths, you can
arrange for appropriate hacks to be run on each.  For example, if one screen
is color and the other is monochrome, hacks that look good in mono can be 
run on one, and hacks that only look good in color will show up on the other.
.RE
.PP
.PP
Normally you won't need to change the following resources:
.PP
.TP 8
.B bourneShell\fP (class \fBBourneShell\fP)
The pathname of the shell that \fIxscreensaver\fP uses to start subprocesses.
This must be whatever your local variant of \fB/bin/sh\fP is -- in particular,
it must not be \fBcsh\fP.
.TP 8
.B windowCreationTimeout\fP (class \fBTime\fP)
When server extensions are not in use, this controls the delay between when 
windows are created and when \fIxscreensaver\fP selects events on them.
Default 30 seconds.
.TP 8
.B pointerPollTime\fP (class \fBTime\fP)
When server extensions are not in use, this controls how 
frequently \fIxscreensaver\fP checks to see if the mouse position or buttons
have changed.  Default 5 seconds.
.TP 8
.B initialDelay\fP (class \fBTime\fP)
When server extensions are not in use, \fIxscreensaver\fP will wait this many
seconds before selecting events on existing windows, under the assumption that 
\fIxscreensaver\fP is started during your login procedure, and the window 
state may be in flux.  Default 30 seconds.
.TP 8
.B overlayStderr\fP (class \fBBoolean\fP)
If \fBcaptureStderr\fP or \fBcaptureStdout\fP are True, and your server 
supports ``overlay'' visuals, then the text will be written into one of
the higher layers instead of into the same layer as the running screenhack.
Set this to False to disable that (though you shouldn't need to.)
.SH HOW IT WORKS
When it is time to activate the screensaver, a full-screen black window is
created on each screen of the display.  The window or windows is given the
appropriate properties so that, to any subsequently-created programs, it 
will appear to be a ``virtual root'' window.  Because of this, any program 
which draws on the root window (and which understands virtual roots) can be
used as a screensaver.

When the user becomes active again, the screensaver windows are unmapped and
the running subprocesses are killed by sending them \fBSIGTERM\fP.  This is 
also how the subprocesses are killed when the screensaver decides that it's
time to run a different demo: the old one is killed and a new one is launched.

Before launching a subprocess, \fIxscreensaver\fP stores an appropriate value
for \fB$DISPLAY\fP in the environment that the child will recieve.  (This is
so that if you start \fIxscreensaver\fP with a \fI-display\fP argument, the
programs which \fIxscreensaver\fP launches will draw on the same display;
and so that the child will end up drawing on the appropriate screen of a
multi-headed display.)

When the screensaver turns off, or is killed, care is taken to restore 
the ``real'' virtual root window if there is one.  Because of this, it is
important that you not kill the screensaver process with \fIkill -9\fP if
you are running a virtual-root window manager.  If you kill it with \-9,
you may need to restart your window manager to repair the damage.  This
isn't an issue if you aren't running a virtual-root window manager.

For all the gory details, see the commentary at the top of xscreensaver.c.

You can control a running screensaver process by using the
.BR xscreensaver\-command (1)
program (which see.)
.SH USING XDM(1)
You can run \fIxscreensaver\fP from your xdm session, so that the 
screensaver will run even when nobody is logged in on the console.  
Simply add \fB"xscreensaver &"\fP to your \fI/usr/lib/X11/xdm/Xsetup\fP 
file.  Because \fIxdm\fP grabs the keyboard, keypresses will not make 
the screensaver deactivate, but any mouse activity will.

Make sure you have \fB$PATH\fP set up correctly in the Xsetup script, or
\fIxdm\fP won't be able to find \fIxscreensaver\fP, and/or \fIxscreensaver\fP
won't be able to find its graphics hacks.

(If your system does not seem to be executing the \fIXsetup\fP file, you
may need to configure it to do so -- the traditional way to do this is
to make that file the value of the \fIDisplayManager*setup\fP resource
in the \fIxdm-config\fP file.  See the man page for
.BR xdm (1)
for more details.)

Users may want to add \fB"xscreensaver-command -restart"\fP to their 
startup scripts, so that the screensaver will be reinitialized with
their private resource settings when they log in.

It is safe to run this program as root (as \fIxdm\fP is likely to do.)  If 
run as root, \fIxscreensaver\fP changes its effective user and group ids to
something safe (like \fI"nobody"\fP) before connecting to the X server
or launching user-specified programs.

Locking doesn't work if the screensaver is launched by \fIxdm\fP.  To get
around this, you can run the screensaver from \fIxdm\fP without locking, 
and kill and restart it from your personal X startup script to enable
locking; for example, by using this pair of commands:

.EX
        xscreensaver-command -exit ; xscreensaver
.EE
.SH USING CDE (COMMON DESKTOP ENVIRONMENT)
The easiest way to use \fIxscreensaver\fP on a system with CDE is to simply
switch off the built-in CDE screensaver, and use \fIxscreensaver\fP instead;
and second, to tell the front panel to run 
.BR xscreensaver\-command (1)
with the \fI\-lock\fP option when the \fILock\fP icon is clicked.

To accomplish this involves five steps:
.RS 4
.TP 3
\fB1: Switch off CDE's locker\fP
Do this by turning off ``\fIScreen Saver and Screen Lock\fP'' in the
Screen section of the Style Manager.
.TP 3
\fB2: Edit sessionetc\fP
Edit the file \fI~/.dt/sessions/sessionetc\fP and add to it the line

.EX
    xscreensaver &
.EE
This will cause \fIxscreensaver\fP to be launched when you log in.
(As always, make sure that xscreensaver and the graphics demos are on
your \fB$PATH\fP; the path needs to be set in \fI.cshrc\fP 
and/or \fI.dtprofile\fP, not \fI.login\fP.)
.TP 3
\fB3: Create XScreenSaver.dt\fP
Create a file called \fI~/.dt/types/XScreenSaver.dt\fP with the following
contents:

.EX
ACTION XScreenSaver
{
  LABEL         XScreenSaver
  TYPE          COMMAND
  EXEC_STRING   xscreensaver-command -lock
  ICON          Dtkey
  WINDOW_TYPE   NO_STDIO
}
.EE
This defines a ``lock'' command for the CDE front panel, that knows how
to talk to \fIxscreensaver\fP.
.TP 3
\fB4: Create Lock.fp\fP
Create a file called \fI~/.dt/types/Lock.fp\fP with the following
contents:

.EX
CONTROL Lock
{
  TYPE             icon
  CONTAINER_NAME   Switch
  CONTAINER_TYPE   SWITCH
  POSITION_HINTS   1
  ICON             Fplock
  LABEL            Lock
  PUSH_ACTION      XScreenSaver
  HELP_TOPIC       FPOnItemLock
  HELP_VOLUME      FPanel
}
.EE
This associates the CDE front panel ``Lock'' icon with the lock command
we just defined in step 3.
.TP 3
\fB5: Restart\fP
Select ``\fIRestart Workspace Manager\fP'' from the popup menu to make
your changes take effect.  If things seem not to be working, check the
file \fI~/.dt/errorlog\fP for error messages.
.RE
.SH USING HP VUE (VISUAL USER ENVIRONMENT)
Since CDE is a descendant of VUE, the instructions for using xscreensaver
under VUE are similar to the above:

.RS 4
.TP 3
\fB1: Switch off VUE's locker\fP
Do this by turning off ``\fIScreen Saver and Screen Lock\fP'' in the
Screen section of the Style Manager.
.TP 3
\fB2: Edit vue.session\fP
Edit the file \fI~/.vue/sessions/home/vue.session\fP and add to it
the line
.EX
    vuesmcmd -screen 0 -cmd "xscreensaver"
.EE
This will cause \fIxscreensaver\fP to be launched when you log in.
(As always, make sure that xscreensaver and the graphics demos are on
your \fB$PATH\fP; the path needs to be set in \fI.cshrc\fP
and/or \fI.profile\fP, not \fI.login\fP.)
.TP 3
\fB3: Edit vuewmrc\fP
Edit the file \fI~/.vue/vuewmrc\fP and add (or change) the Lock control:
.EX
CONTROL Lock
{
  TYPE         button
  IMAGE        lock
  PUSH_ACTION  f.exec "xscreensaver-command -lock"
  HELP_TOPIC   FPLock
}
.EE
This associates the VUE front panel ``Lock'' icon with the xscreensaver 
lock command.
.RE
.PP
.SH BUGS
(This is not a bug, but) note that as of release 1.32, the \fBcolorPrograms\fP 
and \fBmonoPrograms\fP resources are no longer used: they have been 
supplanted by the extended syntax of the \fBprograms\fP resource (which is
described above, in the \fIX Resources\fP section.)
.TP 8
.B Extensions
If you are not making use of one of the server extensions (\fBXIDLE\fP,
\fBSGI SCREEN_SAVER\fP, or \fBMIT-SCREEN-SAVER\fP), then it is possible, in 
rare situations, for \fIxscreensaver\fP to interfere with event propagation 
and make another X program malfunction.  For this to occur, that other
application would need to \fInot\fP select \fBKeyPress\fP events on its 
non-leaf windows within the first 30 seconds of their existence, but then 
select for them later.  In this case, that client \fImight\fP fail to receive 
those events.  This isn't very likely, since programs generally select a
constant set of events immediately after creating their windows and then 
don't change them, but this is the reason that it's a good idea to install 
and use one of the server extensions instead, to work around this shortcoming
in the X protocol.
.TP 8
.B Machine Load
Although this program ``nices'' the subprocesses that it starts, 
graphics-intensive subprograms can still overload the machine by causing
the X server process itself (which is not ``niced'') to suck a lot of 
cycles.  Care should be taken to slow down programs intended for use as 
screensavers by inserting strategic calls to
.BR sleep (3)
or
.BR usleep (3)
(or making liberal use of any \fI\-delay\fP options which the programs 
may provide.)

Also, an active screensaver will cause your X server to be pretty much 
permanently swapped in; but the same is true of any program that draws
periodically, like 
.BR xclock (1)
or
.BR xload (1).
.TP 8
.B Latency and Responsiveness
If the subprocess is drawing too quickly and the connection to the X
server is a slow one (such as an X terminal running over a phone line) then 
the screensaver might not turn off right away when the user becomes active
again (the
.BR ico (1)
demo has this problem if being run in full-speed mode).  This can be
alleviated by inserting strategic calls to
.BR XSync (3)
in code intended for use as a screensaver.  This prevents too much graphics
activity from being buffered up.
.TP 8
.B Locking and XDM
Locking doesn't work if the screensaver is launched by \fIxdm\fP.
The reason for this is that when it is launched by \fIxdm\fP, the
screensaver process is owned by some standard user id (such as \fIroot\fP
or \fIdaemon\fP) instead of the user who is logged in on the console:
because the screensaver was started \fIbefore\fP anyone was logged in.
In order for the screensaver to prompt for the password of the person
who had logged in from \fIxdm\fP, it would need to know who that user was, 
and there is no reliable and safe way to figure that out.  (And even if 
there was, there would be some other security issues here as well.)

So if you want to use it as a locker, you must start it with your user id.
If it has already been started by \fIxdm\fP, you can kill it with
\fBxscreensaver\-command -exit\fP, and then start it again as you.
.TP 8
.B Locking and root logins
An implication of the above is that if you log in as \fIroot\fP on the
console, xscreensaver will refuse to lock the screen (because it can't tell
the difference between \fIroot\fP being logged in on the console, and a
normal user being logged in on the console but xscreensaver having been run
by \fIxdm\fP.)

The solution to this is simple: you shouldn't be logging in on the console
as \fIroot\fP in the first place (what, are you crazy or something?)  You 
should log in as you, and
.BR su (1)
to \fIroot\fP as necessary.  People who spend their day logged in 
as \fIroot\fP are just begging for disaster.
.TP 8
.B Passwords
If you get an error message like ``couldn't get password of \fIuser\fP'' 
then this probably means that you're on a system in which the
.BR getpwent (3)
library routine can only be effectively used by root.  If this is the case, 
then \fIxscreensaver\fP must be installed as setuid to root.  Care has 
been taken to make this a safe thing to do.  

It also may mean that your system uses shadow passwords instead of the
standard \fIgetpwent\fP interface; in that case, you may need to change
some options with \fIconfigure\fP and recompile.

If you change your password after xscreensaver has been launched, it will
continue using your old password to unlock the screen until xscreensaver
is restarted.  This turns out to be kind of hard to fix.  (But remember,
kids!  Unix security doesn't do much more than keep honest people honest...)
.TP 8
.B Colormap lossage: TWM
The \fBinstallColormap\fP option doesn't work very well with the
.BR twm (1)
window manager and its descendants.  

There is a race condition between the screensaver and this window manager,
which can result in the screensaver's colormap not getting installed
properly, meaning the graphics hacks will appear in essentially random
colors.  (If the screen goes white instead of black, this is probably why.)

The
.BR mwm (1)
and
.BR olwm (1)
window managers don't seem to have this problem.  The race condition exists
because X does not provide a way for an OverrideRedirect window to have its
own colormap, short of grabbing the server (which is neither a good idea, nor
really possible with the current design.)  What happens is that, as soon as
the screensaver installs its colormap, \fBtwm\fP responds to 
the \fBColormapNotify\fP event that is generated by re-instaling the default
colormap.  Apparently, \fBtwm\fP doesn't \fIalways\fP do this; it seems to do
it regularly if the screensaver is activated from a menu item, but seems to
not do it if the screensaver comes on of its own volition, or is activated
from another console.  Any thoughts on this problem are welcome...
.TP 8
.B Colormap lossage: XV, XAnim, XEarth
Some programs don't operate properly on visuals other than the default one,
or with colormaps other than the default one.  See the discussion of the
magic "default-n" visual name in the section about the \fBprograms\fP 
resource.  When programs only work with the default colormap, you need to
use a syntax like this:
.EX
    default-n: xv -root image-1.gif -quit  \\n\\
    default-n: xearth -nostars -wait 0     \\n\\
.EE
It would also work to turn off the \fBinstallColormap\fP option altogether,
but that would deny extra colors to those programs that \fIcan\fP take
advantage of them.
.TP 8
.B XView Clients
Apparently there are some problems with XView programs getting confused
and thinking that the screensaver window is the real root window even when
the screensaver is not active: ClientMessages intended for the window manager
are sent to the screensaver window instead.  This could be solved by making
xscreensaver forward all unrecognised ClientMessages to the real root window,
but there may be other problems as well.  If anyone has any insight on the
cause of this problem, please let me know.  (XView is an X11 toolkit that 
implements the (quite abominable) Sun OpenLook look-and-feel.)
.TP 8
.B MIT Extension and Fading
When using the \fBMIT-SCREEN-SAVER\fP extension in conjunction with 
the \fBfade\fP option, you may notice an unattractive flicker just before 
the fade begins.  This is because the server maps a black window just before 
it tells the \fIxscreensaver\fP process to activate.  The \fIxscreensaver\fP 
process immediately unmaps that window, but this results in a flicker.  I 
haven't figured a way  to get around this; it seems to be a fundamental
property of the (mis-) design of this server extension.
.TP 8
.B Lesstif (Motif clone)
Demo mode is buggy if XScreenSaver was compiled against really old versions
Lesstif; if you use Lesstif, use version 0.82 or newer.
.TP 8
.B Athena Widgets
If you compiled against the Athena widget toolkit, the dialog boxes are
pretty ugly, especially the password dialog.  Use Motif!  If you don't
have OSF Motif, use GNU Lesstif, it's free: http://www.lesstif.org/
.TP 8
.B SGI Power Saver
If you're running Irix 6.3, you might find that your monitor is powering down
after an hour or two even if you've told it not to.  This is fixed by SGI
patches 2447 and 2537.
.TP 8
.B Red Hot Lava
There need to be a lot more graphics hacks.  In particular, there should be
a simulation of a Lavalite (tm).
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number, and to inform the sub-programs
of the screen on which to draw.
.TP 8
.B PATH
to find the sub-programs to run.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH UPGRADES
The latest version can always be found at 
http://people.netscape.com/jwz/xscreensaver/
.SH SEE ALSO
.BR X (1),
.BR xscreensaver\-command (1),
.BR xdm (1),
.BR ant (1),
.BR atlantis (1),
.BR attraction (1),
.BR blitspin (1),
.BR bouboule (1),
.BR braid (1),
.BR bubbles (1),
.BR cage (1),
.BR coral (1),
.BR cynosure (1),
.BR decayscreen (1),
.BR deco (1),
.BR drift (1),
.BR fadeplot (1),
.BR flag (1),
.BR flame (1),
.BR forest (1),
.BR galaxy (1),
.BR gears (1),
.BR goop (1),
.BR grav (1),
.BR greynetic (1),
.BR halo (1),
.BR helix (1),
.BR hopalong (1),
.BR hypercube (1),
.BR ifs (1),
.BR imsmap (1),
.BR jigsaw (1),
.BR julia (1),
.BR kaleidescope (1),
.BR laser (1),
.BR lightning (1),
.BR lisa (1),
.BR lissie (1),
.BR lmorph (1),
.BR maze (1),
.BR moebius (1),
.BR moire (1),
.BR moire2 (1),
.BR morph3d (1),
.BR mountain (1),
.BR munch (1),
.BR noseguy (1),
.BR pedal (1),
.BR penrose (1),
.BR pipes (1),
.BR pyro (1),
.BR qix (1),
.BR rd-bomb (1),
.BR rocks (1),
.BR rorschach (1),
.BR rotor (1),
.BR rubik (1),
.BR sierpinski (1),
.BR slidescreen (1),
.BR slip (1),
.BR sphere (1),
.BR spiral (1),
.BR sproingies (1),
.BR stairs (1),
.BR starfish (1),
.BR strange (1),
.BR superquadrics (1),
.BR swirl (1),
.BR triangle (1),
.BR vines (1),
.BR worm (1),
.BR xjack (1),
.BR xlyap (1),
.BR xroger (1),
.BR bongo (1),
.BR ico (1),
.BR xaos (1),
.BR xbouncebits (1),
.BR xcthugha (1),
.BR xdaliclock (1),
.BR xfishtank (1),
.BR xmountains (1),
.BR xsplinefun (1),
.BR xswarm (1),
.BR xtacy (1),
.BR xv (1),
.BR xwave (1).
.SH COPYRIGHT
Copyright \(co 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998
by Jamie Zawinski.  Permission to use, copy, modify, distribute, and sell
this software and its documentation for any purpose is hereby granted without
fee, provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in supporting
documentation.  No representations are made about the suitability of this
software for any purpose.  It is provided "as is" without express or implied
warranty.
.SH AUTHOR
Jamie Zawinski <jwz@netscape.com>.  Written in late 1991; first posted
to comp.sources.x on 13-Aug-1992.

Please let me know if you find any bugs or make any improvements.
.SH ACKNOWLEDGEMENTS
Thanks to David Wojtowicz for implementing \fIlockTimeout\fP.

Thanks to Martin Kraemer for adding support for shadow passwords and
locking-disabled diagnostics.

Thanks to the many people who have contributed graphics demos to the package.

Thanks to Patrick Moreau for the VMS port.

Thanks to Mark Bowyer for figuring out how to hook it up to CDE.

And huge thanks to Jon A. Christopher for implementing the Athena dialog
support, back in the days before Lesstif was a viable alternative to Motif.
