.TH XTEA 1 07-Jun-1994
.SH NAME
xtea \- administrate distribution of tea and other commodities

.SH SYNOPSIS

.B xtea
.I [-v] [-s] [-G groupnum] [-c res1,res2,..] 
.I [-p res1,res2,...] 

.SH DESCRIPTION

.B xtea
and its companion daemon 
.B xtead
are used to facilitate the distribution of resources like tea, coffee,
beer, or jellybeans among users of a LAN.

Each user starts xtea, indicating for which resource he is acting as a
consumer or producer.
A list of configured resources is returned by the program
.BR xteaq (1).

For each produced resource, an icon appears in the xtea 
window. When this
icon is clicked on, a popup 
(resource name 
.IR invitepopup )
containing all users being logged on as 
consumers for 
that resource appears. 
After entering the number of available units and an optional
short description,
some or all of these users can be selected and 
invited to e.g. a cup of tea. 

As the inivitees notice the popups on their screens 
(resource name 
.IR informpopup )
and decide whether
they'd like a cup or not, their decision status and the remaining
number of tea units can be monitored by the invitor.

The resources are assigned on a first-come-first-serve basis. To
prevent race conditions, a status window
(resource name
.IR confirmpopup )
appears for each order, indicating whether the request could be
granted or not. This status window disappears after 10 seconds or
when it is clicked on.


.SH OPTIONS

.TP
\-c list
Specifies the comma-separated
list of resources for which you want to be listed as a
consumer. 
The special resource
.B all
enables all resources.

.TP
\-p list
Specifies the list of resources for which you want to become a 
producer.
The special resource
.B all
enables all resources.

At least one of the -c and -d flags must be given.

.TP
\-G groupnumber
Specify an override user group number. Normally, the user group is determined
automatically by an installation-specific method.

.TP
\-v
Turn on verbose output.
.TP
\-s
Don't catch signals (for debugging only)

.SH CUSTOMIZATION

For most application resources, see the supplied XTea.ad file.

If you want a bigger window to enter descriptive text for your tea offerings,
put the follwing lines in your .Xresources:

.DS
XTea*infotext.height: 50
XTea*infotext*scrollHorizontal: always
.DE

To turn off the double beep when something is being offered, use

.DS
XTea.beep: false
.DE

Finally, to play a sound using aplay when xtea starts or something is offered,
you may add the following resources (to do this, aplay must be in your $PATH and
the sound files must be in your $SOUNDPATH):

.DS
XTea.eventprogram: aplay %s
XTea.default_event: ping.au
XTea.startup_event: -g 10 xtea.au
XTea.tea_event: teaready.au
XTea.coffee_event: coffeeready.au
.DE



.SH EXAMPLE

Joe User has a coffee machine in his office
and brings from time to time some
sweets with him, so he starts xtea as follows:

.RS
xtea -pcoffee,jellybeans -call
.RE

.SH BUGS

Icons for cappuchino, espresso, and wine are still missing.


.SH AUTHORS

.nf
Henning Spruth (idea and program design)
spruth@regent.e-technik.tu-muenchen.de

Rolf Schlagenhaft (icon design)
schlagenhaft@regent.e-technik.tu-muenchen.de
.fi

.SH SEE ALSO

.BR xtead (1)

.BR xteaq (1)
