/******************************************************************************
 * $RCSfile: list.c,v $   $Revision: 1.1.1.1 $
 * Copyright (C) 1993, 1994  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/

#include "list.h"


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static void
    Insert(list *, /* the list */
	   list,   /* the element to insert */
	   list	   /* the next element after the inserted one */
	   );


static void
    Exclude(list *, /* the list */
	    list    /* the element to exclude */
	    );


static void*
    Delete(list *,
	   int,    /* is the list sorted? */
	   void *,
	   list *, /* rest of the list (NULL will be ignored) */
	   int (*)(void *, void *)
	   );


static void*
    Seek(list,
	 int,    /* is the list sorted? */
	 void *,
	 list *, /* rest of the list (NULL will be ignored) */
	 int (*)(void *, void *)
	 );


static list
    SeekSublist(list,
		int,   /* is the list sorted? */
		void*,
		int (*)(void *, void *)
		);



/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
list
    New_list()
{
	return (NULL);
}


/*----------------------------------------------------------------------------*/
int
    Empty_list(list l)
{
	if (l == NULL)
	    return (1);
	else
	    return (0);
}


/*----------------------------------------------------------------------------*/
void*
    First_list(list l)
{
	if (l != NULL)
	    return (l->data);
	else
	    return (NULL);
}


/*----------------------------------------------------------------------------*/
void*
    Last_list(list l)
{
	if (l != NULL)
	    return ((l->prev)->data);
	else
	    return (NULL);
}


/*----------------------------------------------------------------------------*/
list
    Next_list(list l)
{
	if (l != NULL)
	    return (l->next);
	else
	    return (NULL);
}


/*----------------------------------------------------------------------------*/
list
    Previous_list(list l)
{
	if (l != NULL  &&  (l->prev)->next != NULL)
	    return (l->prev);
	else
	    return (NULL);
}


/*----------------------------------------------------------------------------*/
void
    AppendTrue_list(list *lptr,
		    void *data)
{
	list newelem;

	newelem = (list)TrueReAlloc(NULL, 1, sizeof(struct list));
	newelem->data = data;
	Insert(lptr, newelem, NULL);
}


/*----------------------------------------------------------------------------*/
void
    AddTrueSorted_list(list *lptr,
		       void *data,
		       int (*cmp)(void *, void *))
{
	list newelem;
	register list l;

	newelem = (list)TrueReAlloc(NULL, 1, sizeof(struct list));
	newelem->data = data;
	for (l = *lptr; l != NULL && (*cmp)(l->data, data) < 0; l = l->next);
	Insert(lptr, newelem, l);
}


/*----------------------------------------------------------------------------*/
int
    AddTrueNewSorted_list(list *lptr,
			  void *data,
			  int (*cmp)(void *, void *))
{
	register list l;
	int comp = 1;

	for (l = *lptr; l != NULL && (comp = (*cmp)(l->data, data)) < 0;
								l = l->next);
	if (comp == 0)
	    return (1);
	else {
		list newelem;

		newelem = (list)TrueReAlloc(NULL, 1, sizeof(struct list));
		newelem->data = data;
		Insert(lptr, newelem, l);
	}
	return (0);
}


/*----------------------------------------------------------------------------*/
void*
    Seek_list(list l,
	      void* data,
	      list* rest,
	      int (*cmp)(void*, void*))
{
	return (Seek(l, 0, data, rest, *cmp));
}


/*----------------------------------------------------------------------------*/
void*
    SeekSorted_list(list l,
		    void* data,
		    list* rest,
		    int (*cmp)(void*, void*))
{
	return (Seek(l, 1, data, rest, *cmp));
}


/*----------------------------------------------------------------------------*/
void*
    Del_list(list* lptr,
	     void *data,
	     list *rest,
	     int (*cmp)(void *, void *))
{
	return (Delete(lptr, 0, data, rest, *cmp));
}


/*----------------------------------------------------------------------------*/
void*
    DelSorted_list(list* lptr,
		   void* data,
		   list* rest,
		   int (*cmp)(void *, void *))
{
	return (Delete(lptr, 1, data, rest, *cmp));
}


/*----------------------------------------------------------------------------*/
void*
    TakeOut_list(list* lptr)
{
	list l = *lptr;
	void* dat = NULL;

	if (l != NULL) {
		dat = l->data;
		Exclude(lptr, l);
		Free((void**)&l);
	}
	return (dat);
}


/*----------------------------------------------------------------------------*/
void
    InOrder_list(list l,
		 void (*func)(void *))
{
	register list i;

	for (i = l; i != NULL; i = i->next)
	    (*func)(i->data);
}


/*----------------------------------------------------------------------------*/
void
    Free_list(list *lptr,
	      void (*elemfree)(void **))
{
	register list l;

	l = *lptr;
	while (l != NULL) {
		list del;

		del = l;
		l = l->next;
		(*elemfree)(&(del->data));
		Free((void**)&del);
	}
	*lptr = NULL;
}


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
static void
    Insert(list *head,
	   list new,
	   list next)
{
	if (*head == NULL) {
		*head = new->prev = new;
		new->next = NULL;
	}
	else {
		if (*head == next) {
			new->prev = (*head)->prev;
			(*head)->prev = new;
			new->next = *head;
			*head = new;
		}
		else {
			if (next != NULL) {
				(next->prev)->next = new;
				new->prev = next->prev;
				new->next = next;
				next->prev = new;
			}
			else {
				((*head)->prev)->next = new;
				new->prev = (*head)->prev;
				new->next = NULL;
				(*head)->prev = new;
			}
		}
	}
}


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
static void
    Exclude(list* head,
	    list del)
{
	if (del->next != NULL)
	    (del->next)->prev = del->prev;
	if (*head == del)
	    *head = del->next;
	else {
		(del->prev)->next = del->next;
		if (del->next == NULL)
		    (*head)->prev = del->prev;
	}
}


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
static void*
    Delete(list* lptr,
	   int sortedflag,
	   void* data,
	   list* rest,
	   int (*cmp)(void *, void *))
{
	list l;
	void* dat = NULL;

	l = SeekSublist(*lptr, sortedflag, data, *cmp);
	if (rest != NULL)
	    *rest = NULL;
	if (l != NULL) {
		dat = l->data;
		if (rest != NULL)
		    *rest = l->next;
		Exclude(lptr, l);
		Free((void**)&l);
	}
	return (dat);
}


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
static void*
    Seek(list l,
	 int sortedflag,
	 void* data,
	 list* rest,
	 int (*cmp)(void *, void *))
{
	l = SeekSublist(l, sortedflag, data, *cmp);
	if (rest != NULL)
	    *rest = (l != NULL) ? l->next : NULL;
	return ((l != NULL) ? l->data : NULL);
}


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
static list
    SeekSublist(list l,
		int sortedflag,
		void* data,
		int (*cmp)(void*, void*))
{
	while (l != NULL) {
		register int comp;

		if ((comp = (*cmp)(data, l->data)) == 0)
		    break;
		if (sortedflag && comp < 0)
		    l = NULL;
		else
		    l = l->next;
	}
	return (l);
}
