/******************************************************************************
 * $RCSfile: mem.c,v $   $Revision: 1.3 $
 * Copyright (C) 1993  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/


#include "mem.h"
#include <malloc.h>


/*----------------------------------------------------------------------------*/
void*
    TrueReAlloc(void* oldptr,
		size_t n,
		size_t size)
{
	void* ptr = NULL;

	if (n > 0) {
		if (oldptr == NULL) {  /* SUN-realloc() don't work with NULL */
			if ((ptr = (void*)malloc(n * size)) == NULL) {
				perror("malloc()");
				Error(-1, "can't malloc");
			}
		}
		else {
			if ((ptr = (void*)realloc(oldptr, n * size)) == NULL) {
				perror("realloc()");
				Error(-1, "out of memory");
			}
		}
	}
	return (ptr);
}


/*----------------------------------------------------------------------------*/
void
    Free(void** blockptr)
{
	if (*blockptr != NULL) {
		free(*blockptr);
		*blockptr = NULL;
	}
}
