/******************************************************************************
 * $RCSfile: sys.c,v $   $Revision: 1.15 $
 * Copyright (C) 1993  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/


#include "sys.h"
#ifdef SVR4
#  include <sys/systeminfo.h>
#endif /* SVR4 */
#include <misc/ipc.h>


/*----------------------------------------------------------------------------*/
char*
    GetHostname()
{
	static string name = NULL;
	char hostnamebuf[MAXHOSTNAMELEN + 1];

#ifdef SVR4
	if (sysinfo(SI_HOSTNAME, hostnamebuf, MAXHOSTNAMELEN) > 0)
#else
	if (gethostname(hostnamebuf, MAXHOSTNAMELEN) == 0)
#endif
	    {
		    StrTrueReAlloc(&name, hostnamebuf);
	    }
	else {
		perror("gethostname()");
		Warning("can't get hostname");
		StrTrueReAlloc(&name, "");
	}
	return ((char *)name);
}


/*----------------------------------------------------------------------------*/
struct hostent *
    GetHostByName(char* name)
{
	static struct hostent * ent;
	static string lastname = NULL;

	if (lastname == NULL  ||  strcmp(name, lastname) != 0) {
		ent = gethostbyname(name);
		StrTrueReAlloc(&lastname, name);
		endhostent();
	}
	return (ent);
}


/*----------------------------------------------------------------------------*/
char*
    GetFullHostname()
{
	static string fullname = NULL;

	StrTrueReAlloc(&fullname, GetHostnameByName(GetHostname()));
	return ((char*)fullname);
}


/*----------------------------------------------------------------------------*/
int
    TestHostname(char* name)
{
	if (GetHostByName(name) == NULL)
	    return (0);
	else
	    return (1);
}


/*----------------------------------------------------------------------------*/
char*
    GetHostnameByName(char* name)
{
	static string fullname = NULL;
	struct hostent * ent;

	if ((ent = GetHostByName(name)) != NULL) {
		StrTrueReAlloc(&fullname, ent->h_name);
	}
	else {
		Warning("can't get hostname for \"%s\"", name);
		StrTrueReAlloc(&fullname, "");
	}
	return ((char*)fullname);
}


/*----------------------------------------------------------------------------*/
int
    PingHost(char* hostname)
{
	conn pingconn;
	char* test = "host-ping";
	int ret;

	if (! TestHostname(hostname))
	    return (0);
	pingconn = Connect_conn(NULL, hostname, 7, 0, CONN_DATAGRAM);
	if (pingconn == NULL)
	    return (0);
	SendString_conn(pingconn, test);
	SendString_conn(pingconn, test);
	SendString_conn(pingconn, test);
	ret = Test_conn(pingconn->sock, CONN_ISREAD, 2);
	Close_conn(&pingconn);
	return (ret);
}


/*----------------------------------------------------------------------------*/
char*
    GetDisplayHostname(Display* disp)
{
	static string fullname = NULL;

	StrSplit(&fullname, NULL, XDisplayString(disp), ":");
	if (fullname[0] == '\0') {
		StrTrueReAlloc(&fullname, GetHostname());
	}
	else {
		StrTrueReAlloc(&fullname, GetHostnameByName((char *)fullname));
	}
	return ((char*)fullname);
}


/*----------------------------------------------------------------------------*/
char*
    GetLogin()
{
	static string mylogin = NULL;
	char* utmplogin;
	struct passwd * passwd;

	utmplogin = getlogin();
	if (utmplogin == NULL  ||  (passwd = getpwnam(utmplogin)) == NULL)
	    passwd = getpwuid(getuid());
	StrTrueReAlloc(&mylogin, passwd->pw_name);
	return ((char*)mylogin);
}


/*----------------------------------------------------------------------------*/
char*
    GetRealName(char* login)
{
	static string realname = NULL;
	struct passwd * passwd;

	if ((passwd = getpwnam(login)) == NULL)
	    StrTrueReAlloc(&realname, "");
	else
	    StrTrueReAlloc(&realname, passwd->pw_gecos);
	return ((char*)realname);
}


#ifndef SYSV
static string utfile = NULL;
static FILE* utstream = NULL;
#endif

/*----------------------------------------------------------------------------*/
void
    UTmpName(const char* file)
{
#ifdef SYSV
	utmpname(file);
#else
	StrTrueReAlloc(&utfile, file);
#endif
}


/*----------------------------------------------------------------------------*/
struct UTmp *
    GetUTEnt()
{
	static struct UTmp utent;

	while (1) {
#ifdef SYSV
		struct utmp * ut;

		ut = getutent();
		if (ut == NULL) {
			EndUTEnt();
			return (NULL);
		}
		if (ut->ut_type == USER_PROCESS) {
			strncpy(utent.user, ut->ut_user, 8);
			utent.user[8] = '\0';
			strncpy(utent.tty, ut->ut_line, 12);
			utent.tty[12] = '\0';
#  if defined(SVR4) || defined(sgi)
			utent.host[0] = '\0';
#  else
			strncpy(utent.host, ut->ut_host, 16);
			utent.host[16] = '\0';
#  endif
			break;
		}
#else /* SYSV */
		struct utmp ut;

		if (utfile == NULL)
		    StrTrueReAlloc(&utfile, UTMP_FILE);
		if (utstream == NULL)
		    if ((utstream = fopen(utfile, "r"))  ==  NULL)
			return (NULL);
		if (fread(&ut, sizeof (struct utmp), 1, utstream)  !=  1) {
			EndUTEnt();
			return (NULL);
		}
		if (ut.ut_user[0] != '\0') {
			strncpy(utent.user, ut.ut_user, 8);
			utent.user[8] = '\0';
			strncpy(utent.tty, ut.ut_line, 8);
			utent.tty[8] = '\0';
			strncpy(utent.host, ut.ut_host, 16);
			utent.host[16] = '\0';
			break;
		}
#endif /* SYSV */
	}

	return (&utent);
}


/*----------------------------------------------------------------------------*/
void
    EndUTEnt()
{
#ifdef SYSV
	endutent();
#else
	if (utstream != NULL) {
		fclose(utstream);
		utstream = NULL;
	}
#endif
}
