/******************************************************************************
 * $RCSfile: tree.c,v $   $Revision: 1.3 $
 * Copyright (C) 1994  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/

#include "tree.h"
#include <misc/list.h>


/*----------------------------------------------------------------------------*
 * intern variables
 *----------------------------------------------------------------------------*/

static tree** path = NULL;
static int path_pos = 0;
static int path_maxpos = -1;


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static void
    L_Rotation(tree*);

static void
    R_Rotation(tree*);

static void
    L_Balance(tree*);

static void
    R_Balance(tree*);


static void
    Push_path(tree*);

static tree*
    Pop_path();


/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
tree
    New_tree()
{
	return (NULL);
}


/*----------------------------------------------------------------------------*/
int
    Empty_tree(tree root)
{
	if (root == NULL)
	    return (1);
	else
	    return (0);
}


/*----------------------------------------------------------------------------*/
void
    AddTrue_tree(tree* root,
		 void* data,
		 int (*cmp)(void*, void*))
{
	tree* node = root;
	tree* crucialnode = root;

	while (*node != NULL) {
		if ((*node)->balance != 0)
		    crucialnode = node;
		node = ((*cmp)(data,(*node)->data) < 0) ?
		    &((*node)->left) : &((*node)->right);
	}

	*node = (tree)TrueReAlloc(NULL, 1, sizeof (struct tree));
	(*node)->data = data;
	(*node)->balance = 0;
	(*node)->left = (*node)->right = NULL;

	if (*crucialnode != NULL) {
		tree n;

		n = *crucialnode;
		while (n != *node)
		    if ((*cmp)(data,n->data) < 0) {
			    n->balance--;
			    n = n->left;
		    }
		    else {
			    n->balance++;
			    n = n->right;
		    }

		node = crucialnode;
		if (abs((*node)->balance) > 1) {
			if ((*node)->balance == -2)
			    if ((*node)->left->balance == -1) {
				    (*node)->balance = 0;
				    R_Rotation(node);
			    }
			    else {
				    (*node)->balance =
					((*node)->left->right->balance == -1) ?
					    1 : 0;
				    (*node)->left->balance =
					((*node)->left->right->balance == 1) ?
					    -1 : 0;
				    L_Rotation(&((*node)->left));
				    R_Rotation(node);
			    }
			if ((*node)->balance == 2)
			    if ((*node)->right->balance == 1) {
				    (*node)->balance = 0;
				    L_Rotation(node);
			    }
			    else {
				    (*node)->balance =
					((*node)->right->left->balance == 1) ?
					    -1 : 0;
				    (*node)->right->balance =
					((*node)->right->left->balance == -1) ?
					    1 : 0;
				    R_Rotation(&((*node)->right));
				    L_Rotation(node);
			    }
			(*node)->balance = 0;
			*crucialnode = *node;
		}
	}
}


/*----------------------------------------------------------------------------*/
void*
    AddTrueNew_tree(tree* root,
		    void* data,
		    int (*cmp)(void*, void*))
{
	if (Seek_tree(*root, data, NULL, *cmp) != NULL)
	    return (data);
	AddTrue_tree(root, data, *cmp);
	return (NULL);
}


/*----------------------------------------------------------------------------*/
void*
    Seek_tree(tree node,
	      void* data,
	      tree* rest,
	      int (*cmp)(void*, void*))
{
	while (node != NULL) {
		int ret = (*cmp)(data, node->data);

		if (ret == 0) {
			if (rest != NULL)
			    *rest = node->right;
			return (node->data);
		}
		node = (ret < 0) ? node->left : node->right;
	}
	return (NULL);
}


/*----------------------------------------------------------------------------*/
void*
    Del_tree(tree* root,
	     void* data,
	     tree* rest,
	     int (*cmp)(void*, void*))
{
	tree* node = root;
	tree delnode = NULL;
	tree replacenode = NULL;
	void* found = NULL;

	while (*node != NULL  &&  (*cmp)(data,(*node)->data) != 0) {
		Push_path(node);
		node = ((*cmp)(data,(*node)->data) < 0) ?
		    &((*node)->left) : &((*node)->right);
	}
	if (*node == NULL) {
		if (rest != NULL)
		    *rest = NULL;
		return (NULL);
	}
	if (rest != NULL)
	    *rest = (*node)->right;
	found = (*node)->data;
	delnode = *node;
	if ((*node)->left == NULL)
	    replacenode = (*node)->right;
	else
	    if ((*node)->right == NULL)
		replacenode = (*node)->left;
	    else {
		    Push_path(node);
		    node = &((*node)->left);
		    while ((*node)->right != NULL) {
			    Push_path(node);
			    node = &((*node)->right);
		    }
		    data = (*node)->data;
		    replacenode = (*node)->left;
	    }
	if (rest != NULL && *rest == *node)
	    *rest = NULL;
	Free((void**)node);
	while ((node = Pop_path()) != NULL) {
		if ((*cmp)(data,(*node)->data) < 0) {
			(*node)->left = replacenode;
			L_Balance(node);
			replacenode = *node;
		}
		else {
			(*node)->right = replacenode;
			R_Balance(node);
			replacenode = *node;
		}
	}
	if (path_pos < 0) {
		path_pos = -path_pos;
		node = Pop_path();
		if ((*cmp)(data,(*node)->data) < 0)
		    (*node)->left = replacenode;
		else
		    (*node)->right = replacenode;
	}
	if (path_pos == 0 && path[0] == root)
	    *root = replacenode;
	if (delnode != NULL)
	    delnode->data = data;
	return (found);
}


/*----------------------------------------------------------------------------*/
void
    InOrder_tree(tree node,
		 void (*func)(void*))
{
	if (node != NULL) {
		InOrder_tree(node->left, *func);
		(*func)(node->data);
		InOrder_tree(node->right, *func);
	}
}


/*----------------------------------------------------------------------------*/
void
    Free_tree(tree* root,
	      void (*elemfree)(void**))
{
	if (*root != NULL) {
		Free_tree(&( (*root)->left ), *elemfree);
		Free_tree(&( (*root)->right ), *elemfree);
		(*elemfree)( &( (*root)->data ) );
		Free((void**)root);
	}
}


/*----------------------------------------------------------------------------*/
static void
    L_Rotation(tree* node)
{
	tree new = (*node)->right;

	(*node)->right = new->left;
	new->left = *node;
	*node = new;
}


/*----------------------------------------------------------------------------*/
static void
    R_Rotation(tree* node)
{
	tree new = (*node)->left;

	(*node)->left = new->right;
	new->right = *node;
	*node = new;
}


/*----------------------------------------------------------------------------*/
static void
    L_Balance(tree* node)
{
	switch ((*node)->balance) {
	    case 0:
		path_pos = -path_pos;
	    case -1:
		(*node)->balance++;
		break;
	    case 1:
		switch ((*node)->right->balance) {
		    case 0:
			(*node)->right->balance = -1;
			path_pos = -path_pos;
			L_Rotation(node);
			break;
		    case 1:
			(*node)->balance = (*node)->right->balance = 0;
			L_Rotation(node);
			break;
		    case -1:
			(*node)->balance =
			    ((*node)->right->left->balance == 1) ? -1 : 0;
			(*node)->right->balance =
			    ((*node)->right->left->balance == -1) ? 1 : 0;
			R_Rotation(&((*node)->right));
			L_Rotation(node);
			(*node)->balance = 0;
		}
	}
}


/*----------------------------------------------------------------------------*/
static void
    R_Balance(tree* node)
{
	switch ((*node)->balance) {
	    case 0:
		path_pos = -path_pos;
	    case 1:
		(*node)->balance--;
		break;
	    case -1:
		switch ((*node)->left->balance) {
		    case 0:
			(*node)->left->balance = 1;
			path_pos = -path_pos;
			R_Rotation(node);
			break;
		    case -1:
			(*node)->balance = (*node)->left->balance = 0;
			R_Rotation(node);
			break;
		    case 1:
			(*node)->balance =
			    ((*node)->left->right->balance == -1) ? 1 : 0;
			(*node)->left->balance =
			    ((*node)->left->right->balance == 1) ? -1 : 0;
			L_Rotation(&((*node)->left));
			R_Rotation(node);
			(*node)->balance = 0;
		}
	}
}


/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void
    Push_path(tree* node)
{
	if ((*node)->balance == 0)
	    path_pos = 0;
	if (path_pos > path_maxpos) {
		if (path_maxpos == -1)
		    path_maxpos = 20;
		else
		    path_maxpos *= 2;
		path = (tree**)TrueReAlloc(path, path_maxpos+1, sizeof (tree*));
	}
	path[path_pos++] = node;
}


/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static tree*
    Pop_path()
{
	if (path_pos > 0)
	    return (path[--path_pos]);
	else
	    return (NULL);
}
