#include "xwho.h"
#include <misc/flex.h>

/* tokens */
enum {
	/* server-config */
	DOMAIN, GATEWAYS,
	PORT, INTEGER, SUBHOST, FILENAME,

	/* client-config */
	LAYOUT, NICKNAME, NICKGROUP, BUTTON, NOUSER,
	DEFAULT, REGEX,
	MENU, LABEL, COUNT, NL,
	NICK, EQ,
	COMMAND,

	/* general */
	HOST,
	OPEN, CLOSE,
	UNKNOWN
};


extern string parsetext;
extern char *yytext;


/*----------------------------------------------------------------------------*
 * extern prototypes
 *----------------------------------------------------------------------------*/

extern int
    ParseConfig();

extern int
    ParseDomain();

extern int
    ParseGateways();

extern int
    ParseSubhost();


extern int
    ParseRCFile();

extern int
    ParseLayout();

extern int
    ParseLayoutInner();

extern int
    ParseNicknames();

extern int
    ParseButtons();

extern int
    ParseButtonCommand();

extern int
    ParseNoUser();
