/******************************************************************************
 * $RCSfile: xwho.c,v $   $Revision: 1.15 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

#include "xwho.h"


/*----------------------------------------------------------------------------*
 * extern variables
 *----------------------------------------------------------------------------*/

string myhostname = NULL;
string mydisplayhostname = NULL;
string mylogin = NULL;
string myhome = NULL;
XtAppContext appctxt;
Display* mydisplay;
Widget toplevel = NULL;
conn myinput;
Pixel mybackground, myforeground;
Pixel groupbackground, groupforeground;
Pixel aliasbackground, aliasforeground;
Pixel userbackground, userforeground;
Pixel nobackground, noforeground;
int verboseflag = 0;



/*----------------------------------------------------------------------------*
 * intern variables
 *----------------------------------------------------------------------------*/

static string rcfile = NULL;


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static void
    InitColors();

static void
    Syntax();

static void
    NoX();



/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
void 
    main(int argc,
	 char *argv[])
{
	/* init global variables */
	programname = "xwho";
	StrTrueReAlloc(&noserver, "NoServer");
	StrTrueReAlloc(&nouser, "        ");


	/* XtAppInitialize */
	{
		static String fallbackresources[] = {
#			include "fallback.h"
			NULL
		    };

		XtToolkitInitialize();
		appctxt = XtCreateApplicationContext();
		XtAppSetFallbackResources(appctxt, fallbackresources);
		mydisplay = XtOpenDisplay(appctxt, NULL, "xwho", "XWho",
					  NULL, 0,
					  (int*)&argc, (String*)argv);
		if (mydisplay == NULL)
		    NoX();
	}


	/* parse the remaining command line arguments */
	{
		int c;
		extern int optind;

		while ((c = getopt(argc, argv, "tvD")) != -1) {
			switch (c) {
			    case 't':
				NoX();
				break;
			    case 'v':
				verboseflag = 1;
				break;
			    case 'D':
				debugflag = 1;
				break;
			    default:
				Syntax();
				exit (1);
			}
		}
		if (optind < argc) {
			Syntax();
			exit (1);
		}
	}


	/* get some values associated with the current session */
	StrTrueReAlloc(&mylogin, GetLogin());
	StrTrueReAlloc(&myhostname, GetFullHostname());
	StrTrueReAlloc(&mydisplayhostname, GetDisplayHostname(mydisplay));
	StrTrueReAlloc(&myhome, getenv("HOME"));
	StrTrueReAlloc(&rcfile, myhome);
	StrTrueCat(&rcfile, RCFILE);


	/* open the input-port and register it to be monitored by the
	 * event-handling */
	if (verboseflag)
	    puts("opening the input-port ...");
	myinput = Open_conn(NULL, XWHO_PORT_MIN, XWHO_PORT_MAX, CONN_DATAGRAM);
	XtAppAddInput(appctxt, myinput->sock, (XtPointer)XtInputReadMask,
		      (XtInputCallbackProc)InterpretInput, (XtPointer)myinput);


	/* create the widgets of the XWho-Layout */
	InitColors();
	CreateLayout(NULL);


	/* display the widgets and start the event-handling */
	if (verboseflag)
	    puts("starting the main-loop ...");
	XtAppMainLoop(appctxt);
}


/*----------------------------------------------------------------------------*/
void
    CreateLayout(Widget parent)
{
	char* layout_tag = NULL;

	if (parent != NULL)
	    XtVaGetValues(parent, XtNlabel, &layout_tag, NULL);

	Destroy_widgetlines();
	toplevel = XtVaAppCreateShell("xwho", "XWho",
				      applicationShellWidgetClass, mydisplay,
				      XtNallowShellResize, True, NULL, NULL);

	if (verboseflag)
	    printf("reading your configuration from %s ...\n", rcfile);
	ReadClientConfig(rcfile, layout_tag);

	if (verboseflag)
	    puts("creating the widgets ...");
	Create_widgetlines(toplevel);
	XtRealizeWidget(toplevel);

	XtAppAddTimeOut(appctxt, 1 * 1000,
			(XtTimerCallbackProc)Init_servers, (XtPointer)myinput);

	XtAppAddTimeOut(appctxt, 2 * 60 * 1000,
			(XtTimerCallbackProc)Check_servers,
			(XtPointer)myinput->port);
}


/*----------------------------------------------------------------------------*/
void
    InterpretInput(conn input)
{
	xwhodservedhost hostdata;
	string serverhost = NULL;
	int ret;

	if (verboseflag)
	    puts("receiving socket input");
	if (RecvBuffer_conn(input) < 0) {
		Warning("can't receive the input");
		return;
	}
	if (RecvProtocol(NULL) < 0) {
		Warning("illegal input on socket");
		return;
	}
	if ((ret = RecvClientInput(NULL, &hostdata, &serverhost))  <  0) {
		Warning("can't interpret socket input");
		return;
	}
	if (ret == 1)
	    ReSubscribe_servers(serverhost, myinput->port);
	else
	    if (hostdata != NULL)
		Update_widgetlines(hostdata);

	SetLastUpdate_servers(serverhost);
	StrFree(&serverhost);
	if (verboseflag)
	    puts("end of socket input");
}


/*----------------------------------------------------------------------------*/
void
    Quit()
{
	XtDestroyWidget(toplevel);
	exit (0);
}


/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void
    InitColors()
{
	Widget w;

	toplevel = XtVaAppCreateShell("xwho", "XWho",
				      applicationShellWidgetClass, mydisplay,
				      NULL, NULL);

	w = XtVaCreateManagedWidget("xwhoButton", commandWidgetClass,
				    toplevel, NULL);
	XtVaGetValues(w,
		      XtNbackground, &nobackground,
		      XtNforeground, &noforeground,
		      NULL);
	XtDestroyWidget(w);

	w = XtVaCreateManagedWidget("xwhoUser", commandWidgetClass,
				    toplevel, NULL);
	XtVaGetValues(w,
		      XtNbackground, &userbackground,
		      XtNforeground, &userforeground,
		      NULL);
	XtDestroyWidget(w);

	w = XtVaCreateManagedWidget("xwhoAlias", commandWidgetClass,
				    toplevel, NULL);
	XtVaGetValues(w,
		      XtNbackground, &aliasbackground,
		      XtNforeground, &aliasforeground,
		      NULL);
	XtDestroyWidget(w);

	w = XtVaCreateManagedWidget("xwhoGroup", commandWidgetClass,
				    toplevel, NULL);
	XtVaGetValues(w,
		      XtNbackground, &groupbackground,
		      XtNforeground, &groupforeground,
		      NULL);
	XtDestroyWidget(w);

	w = XtVaCreateManagedWidget("xwhoMyself", commandWidgetClass,
				    toplevel, NULL);
	XtVaGetValues(w,
		      XtNbackground, &mybackground,
		      XtNforeground, &myforeground,
		      NULL);
	XtDestroyWidget(w);
}


/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void
    Syntax()
{
	fprintf(errout, "%s\n", "Usage: xwho [-toolkitoption ...] [-tv]");
}


/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void
    NoX()
{
	XtDestroyApplicationContext(appctxt);

	Error(-1, "can't open display");
}
