/******************************************************************************
 * $RCSfile: xwho.h,v $   $Revision: 1.25 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 * Author: A.Michael.Leliveld@Informatik.TU-Muenchen.De
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ******************************************************************************/

#include <unistd.h>
#ifndef ultrix
#  include <stdio.h>
#  include <sys/stat.h>
#endif
#include <sys/types.h>
#include <signal.h>
#ifdef linux
#  include <getopt.h>
#endif

#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xp/Table.h>

#include <misc/error.h>
#include <misc/file.h>
#include <misc/dtstruct.h>
#include <misc/ipc.h>
#include <misc/str.h>
#include <misc/sys.h>


#include "xwhologin.h"
#include "xwhodconfig.h"
#include "xwhodclient.h"
#include "xwhowidget.h"
#include "xwhoserver.h"
#include "xwhonick.h"
#include "xwhopopupbutton.h"


/* The port of the server (may be overwritten in xwho.config) */
#define XWHOD_PORT  8190
/* The port a client connects to tell the inetd to start a server */
#define INETD_PORT  8191
/* It seems to be a good idea to leave this ports unchanged, if you not 
 * absolutely have to */

/* The user's configuration file - will be appended to $HOME */
#define RCFILE  "/.xwhorc"

/* This TTY in the utmp-file identifies a local login (may be overwritten in
 * xwho.config) */
#define DEFAULT_LOCALTTY  "X0"

/* Which ports shall the clients use for their communications? */
#define XWHO_PORT_MIN           8200
#define XWHO_PORT_MAX           9000

/* The client reconnects the server, if it receives no update for this time */
#define XWHO_SERVER_CHECK_TIME  600 /* 10 min */

/* The server waits for this time, until it rereads the utmp-file */
#define XWHOD_WAIT_SEC        30

/* After this time the subscript for updates times out and the client has to
 * resubscribe, if it still exists */
#define XWHOD_CLIENT_TIMEOUT  3600 /* 1 h */

/* If a subsript-connection to a client lasts longer than this time, the server
 * assumes something's wrong and terminates */
#define XWHOD_CONN_TIMEOUT    60 /* 1 min */


#define FORMOPT  TBL_RIGHT


/*----------------------------------------------------------------------------*
 * extern variables
 *----------------------------------------------------------------------------*/

extern string myhostname;
extern string mydisplayhostname;
extern string mylogin;
extern string myhome;
extern XtAppContext appctxt;
extern Display* mydisplay;
extern Widget toplevel;
extern conn myinput;
extern Pixel mybackground, myforeground;
extern Pixel groupbackground, groupforeground;
extern Pixel aliasbackground, aliasforeground;
extern Pixel userbackground, userforeground;
extern Pixel nobackground, noforeground;


/*----------------------------------------------------------------------------*
 * extern prototypes
 *----------------------------------------------------------------------------*/

/*--- xwho.c ---*/

extern void
    CreateLayout(Widget);

extern void
    InterpretInput(conn);

extern void
    Quit();


/*--- ReadConfig.c ---*/

extern xwhodaemon
    GetConfigServer(string);

extern void
    EndConfig();


/*--- ReadRCFile.c ---*/

extern void
    ReadClientConfig(string, string);


/*--- Menu.c ---*/

extern void
    CreateXWhoMenu(Widget, xwhowidget, int, int);

extern void
    Add_layoutentries(string);


/*--- Protocol.c ---*/

extern int
    SettleProtocol_server(conn);

extern int
    SettleProtocol_client(conn);

extern void
    SendProtocol(conn, int);

extern int
    RecvProtocol(conn);

extern void
    SendClientSubscript(conn, string, int, int, xwhodservedhosts*);

extern int
    RecvServerInput(conn, string*, int*, int*, xwhodservedhosts);

extern void
    SendUpdateData(conn, xwhodservedhost);

extern void
    SendTimeOut(conn);

extern int
    RecvClientInput(conn, xwhodservedhost*, string*);

extern void
    SendHostData(conn, string);

extern void
    RecvHostData(conn, string*);

extern void
    SendLoginData(conn, string, string, string, int);

extern void
    RecvLoginData(conn, string*, string*, string*, int*);

extern void
    SendTtyData(conn, string, string);

extern void
    RecvTtyData(conn, string*, string*);

extern void
    ProtocolNext(conn);

extern void
    ProtocolEnd(conn);

extern int
    ProtocolHasNext(conn);

extern void
    CommunicationEnd_server(conn);

extern void
    CommunicationEnd_client(conn);


/*--- Popup.c ---*/

extern void
    UserClick();

extern void
    UpdateLastPopup(xwhowidget);

extern void
    DestroyLastPopup();
