/******************************************************************************
 * $RCSfile: xwhodconfig.h,v $   $Revision: 1.8 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

struct xwhodservedhost {
	string hostname;
	string utmpfile;
	string localtty;
	xwhologins logins;
	xwhologins lastlogins;
};
typedef struct xwhodservedhost * xwhodservedhost;
typedef list xwhodservedhosts;


struct xwhodaemon {
	string hostname;
	int port;
	xwhodservedhosts subhosts;
};
typedef struct xwhodaemon * xwhodaemon;
typedef list xwhodaemons;


struct xwhoseekserver {
	string subhost;
	xwhodaemon daemon;
};
typedef struct xwhoseekserver * xwhoseekserver;

struct xwhodconfig {
	xwhodaemons domain;
	xwhodaemons gateways;
	tree seektree;
};
typedef struct xwhodconfig * xwhodconfig;


/*----------------------------------------------------------------------------*
 * extern prototypes
 *----------------------------------------------------------------------------*/

extern xwhodconfig
    New_xwhodconfig();

extern xwhodaemon
    SeekServer_xwhodconfig(xwhodconfig, string);

extern void
    Free_xwhodconfig(void**);


extern xwhoseekserver
    New_xwhoseekserver();

extern int
    Cmp_xwhoseekserver(void*, void*);

extern xwhoseekserver
    SeekServer_xwhoseekserver(tree, string);

extern void
    Free_xwhoseekserver(void**);


extern xwhodaemons
    New_xwhodaemons();

extern void
    Add_xwhodaemons(xwhodaemons*, xwhodaemon);

extern void
    Del_xwhodaemons(xwhodaemons*, xwhodaemon);

extern xwhodaemon
    SeekServer_xwhodaemons(xwhodaemons, string);

extern void
    Show_xwhodaemons(xwhodaemons);

extern void
    Free_xwhodaemons(void**);


extern xwhodaemon
    New_xwhodaemon();

extern xwhodaemon
    Init_xwhodaemon(string);

extern void
    AddSubhost_xwhodaemon(xwhodaemon, xwhodservedhost);

extern void
    SetPort_xwhodaemon(xwhodaemon, int);

extern int
    Cmp_xwhodaemon(void*, void*);

extern xwhodaemon
    Copy_xwhodaemon(xwhodaemon);

extern int
    HasSubhost_xwhodaemon(xwhodaemon, string);

extern void
    Show_xwhodaemon(void*);

extern void
    Free_xwhodaemon(void**);



extern xwhodservedhosts
    New_xwhodservedhosts();

extern void
    Add_xwhodservedhosts(xwhodservedhosts*, xwhodservedhost);

extern xwhodservedhosts
    Copy_xwhodservedhosts(xwhodservedhosts);

extern xwhodservedhost
    TakeOut_xwhodservedhosts(xwhodservedhosts*);

extern int
    HasSubhost_xwhodservedhosts(xwhodservedhosts, string);

extern void
    Update_xwhodservedhosts(xwhodservedhosts);

extern xwhodservedhosts
    Changed_xwhodservedhosts(xwhodservedhosts);

extern void
    Send_xwhodservedhosts(conn, xwhodservedhosts);

extern xwhodservedhosts
    Recv_xwhodservedhosts(conn);

extern void
    Show_xwhodservedhosts(xwhodservedhosts);

extern void
    Free_xwhodservedhosts(void**);


extern xwhodservedhost
    New_xwhodservedhost();

extern xwhodservedhost
    Init_xwhodservedhost(string);

extern void
    SetUtmpFile_xwhodservedhost(xwhodservedhost, string);

extern void
    SetLocalTty_xwhodservedhost(xwhodservedhost, string);

extern xwhodservedhost
    Copy_xwhodservedhost(xwhodservedhost);

extern int
    Cmp_xwhodservedhost(void*, void*);

extern void
    Update_xwhodservedhost(void*);

extern int
    HasChanged_xwhodservedhost(xwhodservedhost);

extern void
    Show_xwhodservedhost(void*);

extern void
    Send_xwhodservedhost(conn, xwhodservedhost);

extern xwhodservedhost
    Recv_xwhodservedhost(conn);

extern void
    Free_xwhodservedhost(void**);
