/*
 *  IncludeFileToWidget()   -   includes a file to a text widget
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      Widget  - widget to put text
 *      filename - filename to obtain text from
 *      beginning - if beginnin ==  True, include file at the top
 *                  of the widget, otherwise, include file after the
 *                  existing text in the widget
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   18-Mar-95   first cut
 */


#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

void IncludeFileToWidget (widget, filename, beginning)
Widget
    widget;
char
    *filename;
unsigned int
    beginning;

{
    char
        *ftext;

    char
        tmpbuf[MaxTextLength],
        tmpfile[MaxTextLength];

    static XmTextPosition
        pos;

    FILE
        *fp;

    struct stat
        sb;

    char
        title[100];

    char
        *bname;

    int
        length;

    int
        i;

    int
        rc = 0;

    *title='\0';
    length = 80;
    *tmpfile = '\0';
    *tmpbuf = '\0';

    TemporaryFilename(tmpfile);

    stat (filename, &sb);

    if (sb.st_size == 0)
    {
        Warning("Empry file", filename);
        WriteStatusMessage(1, messageTextW,
            "Could not include empty file!");
        return;
    }

    bname = basename(filename);

    /*
    ** check if the file is binary, we will uuencode it in that case
    */

    rc = IsBinary (filename);

    switch (rc)
    {
        case 1: /* binary file */
        {
#ifdef DEBUG
            (void) fprintf(stderr,
                "Binary file: %s\n", filename);
#endif
            /*
            ** uuencode it
            */
            (void) sprintf(tmpbuf,"** uuencoding file: \"%s\" ...\n", filename);
            WriteStatusMessage(0, messageTextW, tmpbuf);
            Uuencode (filename, tmpfile);
            (void) sprintf(tmpbuf,"** uuencoded file: \"%s\" **\n", filename);
            WriteStatusMessage(0, messageTextW, tmpbuf);
            break;
        }

        case 0: /* text file */
        {
            break;
        }
        
        case 2: /* Unexpected EOF */
        {
            WriteStatusMessage(1, messageTextW,
                "Unexpected end of file while reading!");
            return;
            break;
        }
    }

    (void) strcpy(title, "\n");

    for (i=0; i <(40-(int) strlen(bname)); i++)
        (void) sprintf(title,"%s%s", title,"=");
    (void) sprintf(title,"%s%s", title,bname);

    if (rc == 1)
    {
        (void) sprintf(title, "%s%s", title, "==[uuencoded]=");
        for (i=0; i <(40-5-(int)strlen("uuencoded")-(int) strlen(bname)); i++)
            (void) sprintf(title,"%s%s", title,"=");
    }
    else
        for (i=0; i <(40-(int) strlen(bname)); i++)
            (void) sprintf(title,"%s%s", title,"=");

    (void) sprintf(title,"%s\n", title);

    title[(int) strlen(title)] = '\0';


    if (rc == 1)
    {
        stat (tmpfile, &sb);
        fp = fopen (tmpfile, "r");
    }
    else
        fp = fopen (filename, "r");


    if (!(ftext = XtMalloc((unsigned)(sb.st_size+1))))
    {
        Warning("Bad XtMalloc", "IncludeFileToWidget()");
        return;
    }   

    if (!fread(ftext, sizeof(char), sb.st_size+1, fp))
        WriteStatusMessage(1, messageTextW,
            "Warning: File might have been read partially!\n");

    ftext[sb.st_size] = '\0';

    if (beginning == False)
    {
        pos = XmTextGetLastPosition (widget);
        XmTextInsert (widget, pos, title);
        pos = XmTextGetLastPosition (widget);
        XmTextInsert (widget, pos, ftext);
        pos = XmTextGetLastPosition (widget);
        XmTextInsert (widget, pos, title);
        XmTextShowPosition (widget, pos);
        
    }

    XtFree (ftext);
    if (rc == 1)
        unlink(tmpfile);

    (void) fclose ((FILE *) fp);
}
