/*
 *  PutListOnScreen()   -   put the list on the widget
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  11/12/94    muquit  first cut
 */

#include "xhead.h"
#include "xymrolo.h"

void PutListOnScreen()
{
    RoloRec
        *rr;
    
    char
        buf[500];

    int
        n,
        i;
    
    XmString
        *xmtable;
    
    memset(buf, 0, 500);

    n = 0;
    for(rr=RoloList; rr != (RoloRec *) NULL; rr=rr->next)
    {
        n++;
    }   
    GnumberOfCards = n;

    xmtable = (XmString *) calloc(n, sizeof(XmString));

    for (rr=RoloList, i=0; rr != (RoloRec *) NULL; rr=rr->next)
        if (rr->on)
        {
            sprintf(buf, "%-30s", rr->name);
			buf[30] = '\0';
            xmtable[i] = XmStringCreateSimple (buf);
            i++;
        }
    
    XtUnmapWidget (w_special[ADDRESSLIST_W]);
    XmListDeleteAllItems(w_special[ADDRESSLIST_W]);
    XmListAddItems(w_special[ADDRESSLIST_W], xmtable, n, 0);
    XtMapWidget(w_special[ADDRESSLIST_W]);

    for (i=0; i < n; i++)
        XmStringFree (xmtable[i]);

#ifdef DEBUG2
(void) fprintf(stderr,
    "PutListOnScreen: n=: %d\n", n);    
#endif
    free(xmtable);

    if (XtIsManaged (GinfodW))
        RoloInfoCB ((Widget) NULL, (XtPointer) NULL, 
            (XtPointer) NULL);
}
