/*
 *  rolo.c  -   routines to manimulate rolodex database
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description
 *      borrowed from mrolo
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  11/13/94    muquit  first cut
 */

#include "xhead.h"
#include "xymrolo.h"
#include "defines.h"

int 
    RoloSearch[8] = {1,1,1,1,1,1,1,1};


void RoloFilter (s)
char
    *s;
{
    RoloRec
        *rr;
    
    if (XmToggleButtonGadgetGetState(GSnameTbW))
        RoloSearch[0] = 1;
    else
        RoloSearch[0] = 0;

    if (XmToggleButtonGadgetGetState(GScompanyTbW))
        RoloSearch[1] = 1;
    else
        RoloSearch[1] = 0;

    if (XmToggleButtonGadgetGetState(GSaddressTbW))
    {
        RoloSearch[2] = 1;
        RoloSearch[3] = 1;
    }
    else
    {
        RoloSearch[2] = 0;
        RoloSearch[3] = 0;
    }

    if (XmToggleButtonGadgetGetState(GSph1TbW))
        RoloSearch[4] = 1;
    else
        RoloSearch[4] = 0;

    if (XmToggleButtonGadgetGetState(GSph2TbW))
        RoloSearch[5] = 1;
    else
        RoloSearch[5] = 0;

    if (XmToggleButtonGadgetGetState(GSfaxTbW))
        RoloSearch[6] = 1;
    else
        RoloSearch[6] = 0;

    if (XmToggleButtonGadgetGetState(GSemailTbW))
        RoloSearch[7] = 1;
    else
        RoloSearch[7] = 0;


    if (XmToggleButtonGadgetGetState(GSremarksTbW))
        RoloSearch[8] = 1;
    else
        RoloSearch[8] = 0;

    if ((s == (char *) NULL) || AllSpace(s))
        for (rr=RoloList; rr != (RoloRec *)NULL; rr=rr->next)
            rr->on=1;
    else
    {
        for(rr=RoloList; rr != (RoloRec *)NULL; rr=rr->next)
            rr->on =((mystrstrcase(rr->name,s) != (char *) NULL
                    && RoloSearch[0]) ||
                    (mystrstrcase(rr->company,s) != (char *)NULL 
                    && RoloSearch[1]) ||
                    (mystrstrcase(rr->address,s) != (char *)NULL 
                    && RoloSearch[2]) ||
                    (mystrstrcase(rr->address2,s) != (char *)NULL 
                    && RoloSearch[3]) ||
                    (mystrstrcase(rr->number,s) != (char *)NULL 
                    && RoloSearch[4]) ||
                    (mystrstrcase(rr->number2,s) != (char *)NULL 
                    && RoloSearch[5]) ||
                    (mystrstrcase(rr->number3,s) != (char *)NULL 
                    && RoloSearch[6]) ||
                    (mystrstrcase(rr->email,s) != (char *)NULL 
                    && RoloSearch[7]) ||
                    (mystrstrcase(rr->text,s) != (char *)NULL 
                    && RoloSearch[8]));
    }
}

int AllSpace(s)
char
    *s;
{
    if (s == (char *) NULL)
        return 1;
    
    for (; *s != '\0'; s++)
        if (!isspace(*s)) 
            return 0;

return 1;
}

void DeleteCard(n)
int
    n;
{
    RoloRec
        *rr,
        *pp;

    if (n < 0)
        return;
    

    rr = GetN(n);

    if (rr == RoloList)
        RoloList = RoloList->next;
    else
    {
        for(pp=RoloList; pp->next != rr; pp=pp->next);
        pp->next=rr->next;
    }

    if (rr->name != (char *) NULL)
        (void) free ((char *) rr->name);
    if (rr->company != (char *) NULL)
        (void) free ((char *) rr->company);
    if (rr->address != (char *) NULL)
        (void) free ((char *) rr->address);
    if (rr->address2 != (char *) NULL)
        (void) free ((char *) rr->address2);
    if (rr->number != (char *) NULL)
        (void) free ((char *) rr->number);
    if (rr->number2 != (char *) NULL)
        (void) free ((char *) rr->number2);
    if (rr->number3 != (char *) NULL)
        (void) free ((char *) rr->number3);
    if (rr->email != (char *) NULL)
        (void) free ((char *) rr->email);
    if (rr->text != (char *) NULL)
        (void) free ((char *) rr->text);

    (void) free ((char *)rr);
}
