package provide server 1.0

proc do_command {orig command param} {


        set thelist [split $param " "]
        set dest [lindex $thelist 0]


        switch -exact $command {

        "001"           -

        "002"           -

        "003"           -

        "004"           { rec_STARTUP $param }


        "303"           {rec_NOTIFY $orig $param}

        "311"           {rec_WHOISUSER $orig $param}
        "312"           {rec_WHOISSERVER $orig $param}
        "313"           {rec_WHOISOPERATOR $orig $param}
        "317"           {rec_WHOISIDLE $orig $param}
        "318"           {rec_WHOISENDOF $orig $param}
        "319"           {rec_WHOISCHANNELS $orig $param}

	"322"		{rec_LIST $orig $param}
        "324"           {rec_CHANMODE $orig $param}
	"329"		{rec_CHANNELDATE $orig $param}
        "332"           {rec_JOINTOPIC $orig $param}
        "353"           {rec_CHANLIST $orig $param}

        "367"           {rec_BANLIST $orig $param $command}

        "377"           {rec_MOTD $orig $param}

        "433"           {rec_NICKINUSE }

        "DCC"           {rec_DCC $orig $param}

        "KICK"          {rec_KICK  $orig $param}

        "NICK"          {rec_NICK  $orig $param}

        "QUIT"          {rec_QUIT  $orig $param}

        "MODE"          { rec_MODE $orig $param}

        "JOIN"          { rec_JOIN $orig $param}

        "PART"          { rec_PART $orig $param}

        "PING"          { rec_PING $orig $param}                 

        "TOPIC"         {rec_TOPIC $orig $param}

        "NOTICE"        { rec_NOTICE $orig $param}

        "PRIVMSG"       { rec_PRIVMSG $orig $param}

        default         { rec_unknown $orig $param }
        }
}
    



proc read_sock {sock} {
global serveractive
if $serveractive {
  set l [gets $sock]
  if {[eof $sock]} {
        close $sock
        send_to_window server "IRC SERVER CONNECTION CLOSED!!\n\n"
	.zipperserver.controls.connect configure -state normal
        .zipperserver.controls.disconnect configure -state disabled
        send_to_window server "Disconneted from server.\n"
        wm title .zipperserver "Zipper: Not Connected"      
        close_irc_connection
	
  } else {
    handle_server_message $l
  }
}
}

proc handle_server_message {l} {
        global log
        global server
        global nick
	global currchan
        set orig ""
        set command ""

        if ![string compare ":" [string index $l 0] ] {
          scan $l "%s %s" orig command
          set orig [string trimleft $orig ":"]
        } else {
	  set orig $server
          scan $l "%s" command
        }
        set param [string range $l [string first $command $l] end ]
        set param [string trimleft $param $command]
        set param [string trimleft $param " :=@"]


#       set beforig $orig
#       set orig [string range $orig 0 [string first "!" $orig]]
#       set orig [string trimright $orig "!"]


puts stdout $l
puts $log $l
flush $log
        do_command $orig $command $param


}                   

proc rec_NOTIFY {orig param} {
        global nick
	global notfst

        set list [split [string trim [string range $param [string length $nick] end] " :"] ]
	set list [string tolower $list]
        if [winfo exists .zippernotify] {
                wm deiconify .zippernotify
        } else { notify_window }

	set oldlist [.zippernotify.list get 0 end]

        .zippernotify.list delete 0 end


	set list [lsort -command customsort $list]
	foreach name $oldlist {
		set name [string tolower $name]
		set x [lsearch -exact $list $name]
		if [expr $x<0] {
			send_to_window [get_chan_name [focus]] "$notfst$name has left IRC"
		}

	}
        foreach name $list {
		set name [string tolower $name]
		set x [lsearch -exact $oldlist $name]
		if [expr $x<0] {
			send_to_window [get_chan_name [focus]] "$notfst$name is on IRC"
		}
		irc_event "NOTIFY" "N/A" $name "N/A"
                .zippernotify.list insert end $name
        }

}


proc rec_NICKINUSE {} {

        global esvrSock
        global port
        global server
        global nick
        global altnick

         send_to_window server "Nickname <$nick> already in use \n\n"
         set nick $altnick
         wm title .zipperserver "Zipper: $nick on server $server port: $port"
         send_to_server $esvrSock "NICK $nick"
}


proc rec_CHANLIST {orig param} {
        extract_msg $param
        extract_msg $msg

        set win .zipperwin[winman $dest]
        if [ison $dest] {
                set names [split $msg]
                $win.list del 0 end
                set names [lsort -command customsort $names]

                foreach name $names {
                if [string compare "" $name] {
                $win.list insert end $name
                }       }
                send_to_window server "Users on $dest: $msg\n\n"
        } else {
                send_to_window server "Users on $dest: $msg\n\n"
        }

}    

proc rec_PRIVMSG {orig param} {
          global esvrSock
          global notify
          global server
          global nick
	  global actst

	  set longnick $orig
          get_shortnick $orig
          set frommsg "<$orig>"
          extract_msg $param
          if ![string compare [string tolower $dest] [string tolower $nick]] {
                rec_PERSONAL $orig $frommsg $msg $longnick $dest
          } elseif ![string compare $orig $server] {
            send_to_window server "$frommsg $msg\n\n"
          } else {
            if ![string compare "\x01" [string index $msg 0] ] {
		handle_ctcp $orig $msg $longnick $dest
		return
            }
        if [winfo exists ".zipperwin[winman $dest]"] {
            if [is_on_ignore $orig "c" ] { return }
            send_to_window $dest "$frommsg $msg\n"
        } else {
            if [is_on_ignore $orig "c" ] { return }
            send_to_window server "$dest/$frommsg $msg\n\n"

        }
            }

	irc_event CHANMSG $dest $longnick ""
}                          


proc rec_PERSONAL {orig frommsg msg longnick dest} {


        if [string compare "\x01" [string index $msg 0] ] {

        if [is_on_ignore $orig "m" ] { return }

        if [winfo exists ".zipperwin[winman $orig]"] {
                send_to_window $orig "$frommsg $msg\n"
        } else {
          winmannew $orig "$orig" "priv" 1
          insert_chan_list [string tolower $orig]
          send_to_window $orig "$frommsg $msg\n"
          set_chan_activity 1 $orig
          }
        } else {

                if [is_on_ignore $orig "p" ] { return }
                handle_ctcp $orig $msg $longnick $orig
        }
	irc_event PRIVMSG "" $longnick ""
}             

proc rec_MODE {orig param} {
	global nick
	global modest

	set parmlist [split $param " "]
	set nickchan [lindex $parmlist 0]
	set mode [lindex $parmlist 1]
	set who1 [lindex $parmlist 2]
	set who2 [lindex $parmlist 3]
	set who3 [lindex $parmlist 4]
	
	set modetype [join [lrange [split $mode ""] 0 1] ""]
	if [is_channel $nickchan] {
	if [sNull $who1] {
		set win [winman2 $nickchan]

        	if [winfo exists $win] {
               		$win.labels.modes configure -text $mode
        	}                               	
		return
	}
	}
	if ![string compare $nick $nickchan] {
		send_to_window server "$modest\You have set your mode to$mode\n"

	} else {

		send_to_window $nickchan "$modest$orig sets mode $mode to $who1 $who2 $who3\n"
		set switch [lindex [split $mode ""] 0]
		set newmode [lindex [split $mode ""] 1]
		switch -exact -- $modetype {	
		+o	-
		-o	-
		+v	-
		-v	{togglemode $switch $who1 $nickchan $newmode
			togglemode $switch $who2 $nickchan $newmode
			togglemode $switch $who3 $nickchan $newmode }
		+b	-
		-b	{fake_user_in "/echo A ban was set on $who1 $who2 $who3"}

		default	{}	
		}

	}
	switch -exact -- $modetype {
		
		+o	{ irc_event OP $nickchan $orig "$who1 $who2 $who3" }
		-o	{ irc_event DEOP $nickchan $orig "$who1 $who2 $who3" }
		+b	{ irc_event BAN $nickchan $orig "$who1 $who2 $who3" }
		-b	{ irc_event UNBAN $nickchan $orig "$who1 $who2 $who3" }

		default	{ irc_event MODE $nickchan $orig $mode }

	}
}         



proc rec_NICK {orig param} {
        global esvrSock
        global notify
        global nick
        global server
        global port
	global modest
        set dest ""
        set msg ""


        get_shortnick $orig
        extract_msg $param
        send_to_window server "$modest$orig is now know as $dest\n\n"
        set chanlist [.zipperserver.list get 0 end]
        foreach channel $chanlist {
                set append ""
                set channel [string trimleft $channel "> "]
		if [winfo exists .zipperwin[winman $channel].list ] {
                set nicklist [.zipperwin[winman $channel].list get 0 end]
                foreach nickname $nicklist {
                        if ![string compare [string tolower $orig] [string trimleft [string tolower $nickname] " @+" ] ] {
                                if ![string compare "@" [string range [string tolower $nickname] 0 0] ] {
                                        set append "@"
                                } elseif ![string compare "+" [string range [string tolower $nickname] 0 0] ] {
                                        set append "+"
                                }
                                send_to_window $channel "$modest\002$orig is now known as $dest\002\n"
                                remove_nick $channel $nickname
                                insert_nick $channel "$append$dest"
                        }
                }
		}
        }
        if [is_me $orig] {
                set nick $dest
                wm title .zipperserver "Zipper: $nick on server $server port: $port"
        }
	irc_event NICK All $dest NA


}                   


proc rec_QUIT {orig param} {
	global partst
        global esvrSock
        global notify
	set oldorig $orig
        get_shortnick $orig
        set param [string trimleft $param " :=@"]
        send_to_window server "$partst$orig has Quit IRC: $param\n\n"
        set chanlist [.zipperserver.list get 0 end]
        foreach channel $chanlist {
                set channel [string trimleft $channel "> "]
                if ![string match "DCC*" $channel] {
                if [winfo exists .zipperwin[winman $channel].list ] {
                set thelist [.zipperwin[winman $channel].list get 0 end]
                foreach nickname $thelist {
                        if ![string compare [string tolower $orig] [string tolower [string trimleft $nickname " >@+"] ] ] {
                                send_to_window $channel "$partst\002$orig has Quit IRC: $param\002\n"
                                remove_nick $channel $nickname
                        }
                }
                }
                }
        }
	irc_event QUIT All $oldorig NA

}
proc rec_JOIN {orig param} {
        global esvrSock
        global notify
        global joinst

        set plist [split $param " "]
        set chan [lindex $plist 0]
        set me $orig
        get_shortnick $orig
        set mme $orig
        set orig $me

        if [is_me $mme] {
        if [winfo exists .zipperwin[winman $chan]] {
                raise .zipperwin[winman $chan]
                focus .zipperwin[winman $chan].entry
                send_to_window $chan "$joinst\Now Talking on $chan\n"
        } else {
          insert_chan_list $chan
          winmannew $chan $chan "pub" 0
          fake_user_in "/mode $chan"
          send_to_window $chan "Now Talking on $chan\n"
        }
        } else {
        insert_nick $chan $mme
        send_to_window $chan "$joinst\002$orig has joined $chan\002\n"
	process_options $orig
        }
	irc_event  JOIN $chan $orig NA
}      


proc rec_PART {orig param} {
        global nick
        global esvrSock
        global notify
	global partst

        extract_msg $param
        get_shortnick $orig

        if ![is_me $orig] {
        send_to_window [string tolower $dest] "$partst\002$orig has left $dest \002\n"
        remove_nick [string tolower $dest] $orig
        } else {
        remove_chan_list $dest
        if [winfo exists .zipperwin[winman $dest]] {
		destroy .zipperwin[winman $dest]
	}
        }
	irc_event  PART $dest $orig NA
}

proc rec_NOTICE {orig param} {
        global esvrSock
        global notify
	global notcst

        if [is_on_ignore $orig "n" ] { return }
        extract_msg $param
        if [string compare "\001" [string index $msg 0] ] {

#               send_to_window server "$notcst\--NOTICE from $orig $msg\--\n\n"
		send_to_window [get_chan_name [focus]] "$notcst\--NOTICE from $orig $msg\--\n\n"
        } else {
                handle_ctcp_reply $orig $msg 
        }
}                 

proc rec_PING {orig param} {
        global nick
        global notify

        global esvrSock
        send_to_server $esvrSock "PONG :$param"
        send_to_server $esvrSock "ISON $notify"
}    



proc rec_KICK {orig param} {
	global kickst
	global nick
	global autorejoin
	scan $param "%s %s" chan target
        extract_msg $param
        get_shortnick $orig
        extract_msg $msg


        if ![is_me $target] {
        send_to_window [string tolower $chan] "$kickst$orig has kicked $target from $chan: ($msg)\n"
        remove_nick $chan $target
        } else {
		destroy .zipperwin[winman $chan]
		remove_chan_list $chan
		send_to_window server "You Were Kicked from $chan by $orig: ($msg)\n"
		if $autorejoin { fake_user_in "/join [string tolower $chan]" }
		}
	irc_event KICK $chan $orig $target
}

proc rec_MOTD {orig param} {
	global nick
	
	set param [string trim [string range $param [string length $nick] end] " :" ]
	send_to_window server "$param\n"

}

proc rec_unknown {orig param} {
	
	set list [split $param " "]
	set list [lrange $list 1 end]
	set param [string trimleft [join $list " "] " @=:" ]
	send_to_window server "$param\n"

}


proc rec_STARTUP { param } {

	set param [string trimleft [string range $param [string first  ":" $param ] end] ":" ]
	send_to_window server "$param\n"

}

proc rec_WHOISUSER {orig param} {
	global whoisvisible
	global whoisuser
	set msg ""
	set dest ""

	extract_msg $param
	set list [split $msg " "]
	set unick [lindex $list 0]
	set user [string trimleft [lindex $list 1] "~" ]
	set host [lindex $list 2]
	set realname [string trimleft [lrange $list 4 end] ":"] 
	set whoisuser "$unick!$user@$host"

	if $whoisvisible {	
		send_to_window server "WHOIS for $unick:\n"
		send_to_window server "$unick: $user@$host\n"
		send_to_window server "$unick: $realname\n"
	}	
	
}
proc rec_WHOISSERVER {orig param} {
	global whoisvisible

	set list [split $param " "]

	set server [string trimleft [lindex $list 2] "~" ]
	set serverinfo [string trimleft [join [lrange $list 3 end] " "] ":"] 

	if $whoisvisible {	
		send_to_window server "[lindex $list 1]: Using $server, $serverinfo\n"
	}	

}
proc rec_WHOISOPERATOR {orig param} {
	global whoisvisible
	set msg ""
	set dest ""

	extract_msg $param
	set list [split $msg " "]
	set oper [string trimleft [lrange $list 1 end] ":"] 
	if $whoisvisible {	
		send_to_window server "[lindex $list 0]: is an IRC Operator. \n"
	}	

}
proc rec_WHOISIDLE {orig param} {
	global whoisvisible
	set msg ""
	set dest ""

	extract_msg $param
	set list [split $msg " "]
	set time [string trimleft [lindex $list 1] ]
	set serverinfo [string trimleft [lrange $list 2 end] ":"] 
	if $whoisvisible {	
		send_to_window server "[lindex $list 0]: Has been idle for $time seconds.\n"
	}	

}
proc rec_WHOISENDOF {orig param} {
	global whoisvisible
	set msg ""
	set dest ""

	extract_msg $param
	set list [split $msg " "]
	set msg [string trimleft [lrange $list 1 end] ":"] 
	if $whoisvisible {	
		send_to_window server "[lindex $list 0]: $msg  \n"
	}	
	set whoisvisible 1

}
proc rec_WHOISCHANNELS {orig param} {
	global whoisvisible
	set msg ""
	set dest ""

	extract_msg $param
	set msg [string trim $msg " "]
	set list [split $msg " "]
	set msg [string trimleft [lrange $list 1 end] ":"] 
	if $whoisvisible {	
		send_to_window server "[lindex $list 0]: $msg  \n"
	}	
	set whoisvisible 1
}


proc rec_JOINTOPIC {orig param} {

	set plist [split $param " "]
	set from  [lindex $plist 0]
	set chan  [lindex $plist 1]
	set win .zipperwin[winman $chan]
	set topic [string trimleft [join [lrange $plist 2 end] " "] ": "]
	if [winfo exists $win] {
		$win.labels.topic configure -text $topic
	}

}

proc rec_CHANMODE {orig param} {
puts $param
	set plist [split $param " "]
	set from [lindex $plist 0]
	set chan  [lindex $plist 1]
	set modes [string trimleft [join [lrange $plist 2 end] " "] ":+ "]
	set win .zipperwin[winman $chan]

	if [winfo exists $win] {
		$win.labels.modes configure -text $modes
	}

}

proc rec_TOPIC {orig param} {


	set plist [split $param " "]
	set chan [lindex $plist 0]
	set topic [string trimleft [join [lrange $plist 1 end] " "] ": "]
	set win .zipperwin[winman $chan]

	if [winfo exists $win] {
		$win.labels.topic configure -text $topic
		send_to_window $chan "\0033Topic changed by $orig to: \002$topic\002"
	}
	irc_event TOPIC $chan $orig NA
}

proc rec_BANLIST {orig param command} {

	global bansvisible
	set w  .zipperbanlist

	if $bansvisible {
		send_to_window server "$param\n"
	}
	set chan [lindex [split $param " "] 1]
	if ![winfo exists $w] {
		create_banlist_window $chan
	} else {
		raise $w
		focus $w
	}
	set ban [lindex [split $param " "] 2]
	$w.bans.list insert end $ban
	

}


proc rec_LIST {orig param} {

	global listmatch

	set match [lindex [split $listmatch " "] 0]
	set min [lindex [split $listmatch " "] 1]
	set max [lindex [split $listmatch " "] 2]

	if [sNull $match] { set match "*" }
	if [sNull $min]   { set min 1 }	
	if [sNull $max]   { set max 999 }	
	set w .zipperchannellist
	if [winfo exists $w] {
		raise  $w
		focus $w
	} else {
		create_chanlist_window
	}
	set l1 [lindex [split $param " "] 1]
	set l2 [lindex [split $param " "] 2]
	set l3 [join [lrange [split $param " "] 3 end] ]
	
	if [expr $l2 <= $max] {
	if [expr $l2 >= $min] {
	if [string match $match $l1] {	
		$w.channels.list insert end "$l1\t\tUsers: $l2\t\tTopic: $l3"
	}}}
}


proc rec_CHANNELDATE {orig param} {
puts $param
	set channel [lindex [split $param " "] 1]
	set inttime [lindex [split $param " "] 2]

	set time [clock format $inttime]
	fake_user_in "/echo $channel was created on $time."
}
