
/* copyright 1997 Kaleb S. KEITHLEY. All Rights Reserved */

#include "showjpg.h"

static void allocate_colors (showjpgstuff data, unsigned long* pixels)
{
    XColor xcol;
    int i;
    unsigned char* bitptr;
    struct {
	unsigned char red;
	unsigned char green;
	unsigned char blue;
	char used;
    } rgbs[256];

    for (i = 0; i < data->ncolors; i++) {
	rgbs[i].red = data->rmap[i];
	rgbs[i].green = data->gmap[i];
	rgbs[i].blue = data->bmap[i];
	rgbs[i].used = 0;
    }

    for (i = 0, bitptr = data->bits; 
	 i < data->width * data->height; 
	 i++, bitptr++)
	rgbs[*bitptr].used = 1;

    for (i = 0; i < data->ncolors; i++) {
	if (rgbs[i].used) {
	    xcol.red = rgbs[i].red << 8;
	    xcol.green = rgbs[i].green << 8;
	    xcol.blue = rgbs[i].blue << 8;

	    XAllocColor (XtDisplay (data->top), 
			DefaultColormap(XtDisplay (data->top),0), &xcol);
	    pixels[i] = xcol.pixel;
	}
    }
}

int cvtJpegToImage (showjpgstuff data)
{
    unsigned char* paddedbits;
    int numpad;
    int imagewidth;
    int i,j;
    unsigned long pixels[256];
    XImage* image;
    Display* dpy = XtDisplay (data->top);

    if (setupSharedMemory (data)) data->use_shm = 1;
    else data->use_shm = 0;

    numpad = (4 - (data->width % 4)) & 3;
    imagewidth = data->width + numpad;

    if (data->use_shm && (imagewidth * data->height) > (1024 * 1024))
	data->use_shm = 0;

    if (data->use_shm)
	paddedbits = (unsigned char*) data->shm_info.shmaddr;
    else
	paddedbits = (unsigned char*) calloc (imagewidth * data->height, 1);

    if (paddedbits) {
	unsigned char* pp = data->bits;
	unsigned char* ip = paddedbits;

	allocate_colors (data, pixels);

	for (i = 0; i < data->height; i++) {
	    for (j = 0; j < data->width; j++, pp++, ip++)
		*ip = (unsigned char) pixels[*pp];
	    ip += numpad;
	}
	if (data->use_shm)
	    data->image = XShmCreateImage (dpy,
				DefaultVisual(dpy,0), 
				DefaultDepth (dpy,0),
				ZPixmap, (char*) paddedbits,
				&data->shm_info,
				data->width, data->height);
	else
	    data->image = XCreateImage (dpy,
				DefaultVisual(dpy,0), 
				DefaultDepth (dpy,0),
				ZPixmap, 0, (char*) paddedbits, 
				data->width, data->height, 32, imagewidth);

	if (data->image)
	    return 1;
    }
    return 0;
} 
