
/* Copyright 1997 Kaleb S. KEITHLEY. All Rights Reserved */

#include "showjpg.h"
#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>
#include "jpeglib.h"
#include "jerror.h"

int loadJFIF (char* const fname, showjpgstuff data)
{
    FILE* fp;
    struct jpeg_decompress_struct cinfo;
    struct jpeg_error_mgr jerr;
    jmp_buf setjmp_buffer;
    int i,w,h;
    unsigned char* buf;
    JSAMPROW rowp[1];
 
    if ((fp = fopen (fname, "rb")) == NULL)
	return 0;

    memset (&cinfo, 0, sizeof cinfo);
    cinfo.err = jpeg_std_error (&jerr);

    if (setjmp (setjmp_buffer)) {
	jpeg_destroy_decompress (&cinfo);
	fclose (fp);
	return 0;
    }

    jpeg_create_decompress (&cinfo);

    jpeg_stdio_src (&cinfo, fp);

    jpeg_read_header (&cinfo, TRUE);

    jpeg_calc_output_dimensions (&cinfo);

    w = cinfo.output_width;
    h = cinfo.output_height;
    buf = malloc (w * h * cinfo.output_components);

    cinfo.quantize_colors = TRUE;
    cinfo.two_pass_quantize = TRUE;
    cinfo.desired_number_of_colors = 64;

    jpeg_start_decompress (&cinfo);

    while (cinfo.output_scanline < cinfo.output_height) {
	rowp[0] = &buf[cinfo.output_scanline * w * cinfo.output_components];
	jpeg_read_scanlines (&cinfo, rowp, 1);
    }

    jpeg_finish_decompress (&cinfo);

    data->width = w;
    data->height = h;
    data->bits = buf;
    data->ncolors = cinfo.actual_number_of_colors;
    data->rmap = malloc (data->ncolors);
    data->gmap = malloc (data->ncolors);
    data->bmap = malloc (data->ncolors);
    if (cinfo.out_color_space == JCS_GRAYSCALE) {
	for (i = 0; i < data->ncolors; i++)
	    data->rmap[i] = data->gmap[i] = data->bmap[i] = i * (256 / (data->ncolors));
    } else {
	memcpy (data->rmap, cinfo.colormap[0], data->ncolors);
	memcpy (data->gmap, cinfo.colormap[1], data->ncolors);
	memcpy (data->bmap, cinfo.colormap[2], data->ncolors);
#if 0
	for (i = 0; i < data->ncolors; i++) {
	    data->rmap[i] = cinfo.colormap[0][i];
	    data->gmap[i] = cinfo.colormap[1][i];
	    data->bmap[i] = cinfo.colormap[2][i];
	}
#endif
    }

    jpeg_destroy_decompress (&cinfo);

    fclose (fp);

    return 1;
}
