///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
// UIComponent.h: Base class for all C++/Motif UI components
/////////////////////////////////////////////////////////////////
#ifndef UICOMPONENT_H
#define UICOMPONENT_H
#include <Xm/Xm.h>
#include "BasicComponent.h"

class UIComponent : public BasicComponent {
    
public:
    
    virtual ~UIComponent();  // Destructor
    
    // Manage the entire widget subtree 
    
    virtual void manage();
    
    // Public access functions
    
    virtual const char *const className() { return ( "UIComponent" ); }
    
protected:
    
    // Protect constructor to prevent direct instantiation
    
    UIComponent ( const char * );
    
    void installDestroyHandler(); // Easy hook for derived classes
    
    // Called by widgetDestroyedCallback() if base widget is destroyed
    
    virtual void widgetDestroyed(); 
    
    // Loads components default resources into database
    
    void setDefaultResources ( const Widget, const String * );
    
    // Retrieve resources for this clsss from the resource manager
    
    void getResources ( const XtResourceList, int );
    
private:
    
    // Interface between XmNdestroyCallback and this class
    
    static void widgetDestroyedCallback ( Widget, XtPointer,XtPointer );
};
#endif
