///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif
//         by
//           Douglas Young
//           Prentice Hall, 1992
//           ISBN 0-13-630252-1	
//
//         Copyright 1991 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////
// Command.h
///////////////////////////////////////////////////////////////
#ifndef COMMAND_H
#define COMMAND_H

#include "UIComponent.h"

class TicTacToe;

class Command: public UIComponent {
    
  private:
    
    static void newGameCallback ( Widget, XtPointer, XtPointer );
    static void quitCallback ( Widget, XtPointer, XtPointer );
    
  protected:
    
    Widget     _newGame;
    Widget     _quit;
    TicTacToe *_game;
    virtual void newGame();
    virtual void quit();
    
  public:
    
    Command ( Widget, TicTacToe *, char * ); 
    virtual const char * const className() { return "Command"; };
};
#endif
