///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif
//         by
//           Douglas Young
//           Prentice Hall, 1992
//           ISBN 0-13-630252-1	
//
//         Copyright 1991 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////
// Engine.h: The brains of the tic-tac-toe game
///////////////////////////////////////////////////////////////
#ifndef ENGINE_H
#define ENGINE_H

#include "Board.h"

class TicTacToe;
class MoveGenerator;

class Engine {
    
  protected:
    
    TicTacToe       *_game;
    markType         _whoseMove;     // Remember whose turn it is
    Board           *_board;         // Internal game state
    MoveGenerator   *_moveGenerator; // Picks next move
    int              _gameOver;      // True is game has ended
    void   checkForWin();            // Check and report the winner
    
  public:
    
    Engine ( TicTacToe * ); 
    virtual ~Engine();
    void recordMove ( int square ); 
    void reset();                    // Start over
    void quit();
    virtual const char *const className() { return "Engine"; }
};
#define NEWGAMEMSG     "New Game. Choose an X square"
#define ILLEGALMOVEMSG "Illegal Move, Choose an other X square"
#define USERSMOVEMSG   "Choose an X square"
#define XWINSMSG       "X Wins!"
#define OWINSMSG       "O Wins!"
#define TIEGAMEMSG     "Tie Game"
#define GAMEISOVERMSG  "Sorry, the game is over"
#endif
