///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif
//         by
//           Douglas Young
//           Prentice Hall, 1992
//           ISBN 0-13-630252-1	
//
//         Copyright 1991 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////
// Stage.h
///////////////////////////////////////////////////////////////
#ifndef STAGE_H
#define STAGE_H
#include "UIComponent.h"
#include <X11/extensions/multibuf.h>

class Actor;

class Stage : public UIComponent {
    
private:
    
    static void resizeCallback ( Widget, XtPointer, XtPointer );
    static void redisplayCallback ( Widget, XtPointer, XtPointer );
    
protected:
    
    GC          _gc;               // Used to clear and copy pixmaps
    Dimension   _width, _height;   // Current window/buffer size.

    int   	_front;
    Multibuffer _buffers[2];

    virtual void resize();
    virtual void redisplay();
    virtual void swapBuffers();
    
    int     _nActors;    // Number of Actors on the Stage
    Actor **_cast;       // List of Actor objects on the Stage
    
public:
    
    Stage ( Widget, char * );    
    ~Stage ();    
    
    virtual void nextFrame();   // Move all actors to the next frame
    
    void addActor ( Actor * );       
    void removeActor ( Actor * );
    
    virtual const char *const className() { return ( "Stage" ); }
};
#endif
