///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////
// Application.h: 
////////////////////////////////////////////////////////////
#ifndef APPLICATION_H
#define APPLICATION_H
#include "UIComponent.h"
#include "SimpleList.h"

class MainWidnow;

class Application : public UIComponent {
    
    // Allow main and MainWindow to access protected member functions
    
friend void main ( int, char ** );
    
friend MainWindow;  // MainWindow needs to call 
    // private functions for registration
public:
    
    Application ( const char * );
    virtual ~Application();     
    
    // Functions to manipulate applications top-level windows
    
    void manage();
    void unmanage();
    void iconify();
    
    // Convenient access functions
    
    Display      *display()     { return ( _display ); }
    XtAppContext  appContext()  { return ( _appContext ); }
    const char   *applicationClass()  { return ( _applicationClass ); }
    
    virtual const char *const className() { return ( "Application" ); }
    
protected:
    
    // Support commonly needed data structures as a convenience
    
    Display     *_display;
    XtAppContext _appContext;
    
    // Functions to handle Xt interface
    
    virtual void initialize ( int *, char ** );  
    virtual void handleEvents();
    
    char   *_applicationClass;    // Class name of this application
    SimpleList<MainWindow*>  _windows;   
    
private:    
    
    // Functions for registering and unregistering top level windows
    
    void registerWindow ( MainWindow * );
    void unregisterWindow ( MainWindow * );
};

// Pointer to single global instance

extern Application *theApplication; 

#endif












































































































































































