///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////
// Clock.h
/////////////////////////////////////////////////////
#ifndef CLOCK_H
#define CLOCK_H
#include "UIComponent.h"

class Clock : public UIComponent {
    
public:
    
    Clock ( const char *, Widget, 
	    int,             // Minimum speed, in frames per second
	    int );           // Maximum speed, in frames per second
    ~Clock ();
    
    void stop();    // Stop the clock
    void pulse();   // Make the clock tick once
    void start();   // Start or restart the clock
    virtual const char *const className() { return ( "Clock" ); }
    
protected:
    
    virtual void tick() = 0;  // Hook for derived classes
    
private:
    
    int          _delta;     // The time between ticks
    XtIntervalId _id;        // Xt Timeout identifier
    
    virtual void timeout();  // Called every delta milliseconds
    virtual void speedChanged ( int ); // Called if the user moves 
  	                                       // the speed control
    //  Xt Callbacks
    
    static void timeoutCallback ( XtPointer, XtIntervalId * );
    static void speedChangedCallback ( Widget, XtPointer, XtPointer );
};
#endif






