///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////
// ColorChooser.h
//////////////////////////////////////////////////////////
#ifndef COLORCHOOSER_H
#define COLORCHOOSER_H
#include "UIComponent.h"

// Function type to be passed to pickColor()

typedef void ( *ColorSelectedCallback ) ( int, int, int, void * );
typedef void ( *CancelCallback ) ( void * );

class ColorModel;
class ColorView;

class ColorChooser : public UIComponent {
    
public:
    
    ColorChooser ( const char *, Widget );
    virtual ~ColorChooser ();
    void pickColor ( ColorSelectedCallback, CancelCallback, void * );
    virtual const char *const className() { return ( "ColorChooser" );}
    
private:
    
    ColorModel    *_model;       // The abstract color model
    ColorView     *_rgbSliders;  // Controls the model
    ColorView     *_swatch;      // A patch of color
    ColorView     *_rgbView;     // Text view of RGB components
    ColorView     *_hsvView;     // Text view of HSV components
    Widget _okButton;            // Selects the current color
    Widget _cancelButton;        // Dismisses dialog
    
    // Pointers to application-defined functions called
    // when user selects a color or cancels the selection
    
    ColorSelectedCallback _clientOkCallback;  
    CancelCallback        _clientCancelCallback;
    void                 *_clientData;
    void   ok();                      // Called by click on "OK"
    void   cancel();                  // Called by click on "Cancel"
    static void okCallback ( Widget, XtPointer, XtPointer );
    static void cancelCallback ( Widget, XtPointer, XtPointer );
};
#endif
