///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////
// DialogManager.h: A base class for cached dialogs
//////////////////////////////////////////////////////////
#ifndef DIALOGMANAGER_H
#define DIALOGMANAGER_H

#include "UIComponent.h"
#include "DialogCallbackData.h"

class DialogManager : public UIComponent {
    
public:
    
    DialogManager ( const char * );
    
    virtual Widget post ( const char *, 
			  void *clientData      = NULL,
			  DialogCallback ok     = NULL,
			  DialogCallback cancel = NULL,
			  DialogCallback help   = NULL );
protected:
    
    // Called to get a new dialog
    
    virtual Widget createDialog ( Widget ) = 0;   
    
private:
    
    Widget getDialog(); 
    
    static void actionCallback ( Widget, XtPointer,  XtPointer );
};
#endif











