///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



  /////////////////////////////////////////////////////////////
  // HSVView.h: Display the contents of a ColorModel as
  //            HSV color components
  /////////////////////////////////////////////////////////////
  #ifndef HSVVIEW_H
  #define HSVVIEW_H
  #include "TextView.h"
  class ColorModel;
 
  class HSVView : public TextView {
      
    public:
      
      HSVView ( const char *, Widget parent );
      virtual void update ( ColorModel * );
      virtual const char *const className() { return ( "HSVView" ); }
  
    protected:
      
      void RGBToHSV ( int, int, int, int&, int&, int& );
  };
  #endif
