///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



 ////////////////////////////////////////////////////////////////////
 // MainWindow.C: Support a top-level window
 ////////////////////////////////////////////////////////////////////
 #include "Application.h"
 #include "MainWindow.h"
 #include <Xm/MainW.h>
 #include <assert.h>
 
 MainWindow::MainWindow ( const char *name ) : UIComponent ( name )
  {
      _workArea = NULL;
  
      assert ( theApplication ); // Application object must exist
                                 // before any MainWindow object
  
      theApplication->registerWindow ( this );
  }
  void MainWindow::initialize( )
  {
      // All top-level windows in the MotifApp framework are 
      // implemented as a popup shell off the Applications
      // base widget
  
      _w = XtCreatePopupShell ( _name, 
                                applicationShellWidgetClass,
                                theApplication->baseWidget(),
                                NULL, 0 );
      installDestroyHandler();
  
      // Use a Motif XmMainWindow widget to handle window layout
  
      _main = XtCreateManagedWidget ( "mainWindow", 
                                      xmMainWindowWidgetClass,
                                      _w,  NULL, 0 );
        
      // Called derived class to create the work area
  
      _workArea = createWorkArea ( _main );  
      assert ( _workArea );
      
      // Designate the _workArea widget as the XmMainWindow
      // widgets XmNworkArea widget
  
      XtVaSetValues ( _main, 
  		                    XmNworkWindow, _workArea, 
  		                    NULL );
  
     // Manage the work area if the derived class hasnt already
  
     if ( !XtIsManaged ( _workArea ) )
        XtManageChild ( _workArea ); 
  }
  MainWindow::~MainWindow( )
  {
      // Unregister this window with the Application object
      
      theApplication->unregisterWindow ( this );
  }
  void MainWindow::manage()
  {
      assert ( _w );
     XtPopup ( _w, XtGrabNone );
  
      // Map the window, in case the window is iconified
  
      if ( XtIsRealized ( _w ) )
  	        XMapRaised ( theApplication->display(), XtWindow ( _w ) );
  }
  void MainWindow::unmanage()
  {
      assert ( _w );
      XtPopdown ( _w );
  }
  void MainWindow::iconify()
  {
      assert ( _w );
  
      // Set the widget to have an initial iconic state
      // in case the base widget has not yet been realized
  
      XtVaSetValues ( _w, XmNiconic, TRUE, NULL );
  
      // If the widget has already been realized, iconify it
  
      if ( XtIsRealized ( _w ) )
  	        XIconifyWindow ( theApplication->display(), XtWindow ( _w ), 0 );
  }
