///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


 ////////////////////////////////////////////////////
 // MainWindow.h: Support a top-level window
 ////////////////////////////////////////////////////
 #ifndef MAINWINDOW_H
 #define MAINWINDOW_H
 #include "UIComponent.h"
 
 class MainWindow : public UIComponent {
 
    public:
      
      MainWindow ( const char * );   // Constructor requires only a name
      virtual ~MainWindow();
  
      // The Application class automatically calls initialize() 
      // for all registered main window objects
  
      virtual void initialize();
  
      virtual void manage();   // Pop up the window
      virtual void unmanage(); // Pop down the window
      virtual void iconify();
  
    protected:
      
      Widget   _main;        // The XmMainWindow widget
      Widget   _workArea;    // Widget created by derived class
  
      // Derived classes must define this function to 
      // create the application-specific work area
  
      virtual Widget createWorkArea ( Widget ) = 0;
  };
  #endif
