///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


  ////////////////////////////////////////////////////////////////
  // MenuBar.h: A menubar that supports panes of Cmd objects
  ////////////////////////////////////////////////////////////////
  #ifndef MENUBAR_H
  #define MENUBAR_H
  #include "UIComponent.h"
  class Cmd;
  class CmdList;
 
  class MenuBar : public UIComponent {
      
    public:
  
      MenuBar ( const char *, Widget );
  
      // Create a named menu pane from a list of Cmd objects
  
      virtual void addCommands ( CmdList * );
      virtual void createPulldown ( Widget, CmdList * );
      virtual const char *const className() { return ( "MenuBar" ); }
  };
  #endif   
