///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


 //////////////////////////////////////////////////////////////////////
 // SelectFileCmd.h:  Allow the user to select a file interactively
 //////////////////////////////////////////////////////////////////////
 #ifndef SELECTFILECMD_H
 #define SELECTFILECMD_H
 #include "NoUndoCmd.h"
 #include <Xm/Xm.h>
 typedef void (*FileCallback) ( void *, char * );
 
  class SelectFileCmd : public NoUndoCmd {
  
    public:
  
      SelectFileCmd ( char *, int , FileCallback, void * );
  
    protected:
  
      void doit();              // Called by base class
      FileCallback _callback;   // Function to be called 
                                // when user selects a file
      void        *_clientData; // Data provided by caller
  
      Widget      _fileBrowser; // The Motif widget used to get file
      virtual void fileSelected ( char * );
  
    private:
  
      static void fileSelectedCallback ( Widget, XtPointer, XtPointer );
  };
  #endif
