///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



 ////////////////////////////////////////////////////////////////
 // WarnNoUndoCmd.C: Warns user before executing a command
 ////////////////////////////////////////////////////////////////
 #include "WarnNoUndoCmd.h"
 
 #define DEFAULTWARNING "This command cannot be undone. Proceed anyway?"
 #define FALSE 0
 
 WarnNoUndoCmd::WarnNoUndoCmd ( const char *name, int active ) : 
                                           AskFirstCmd ( name, active )
  {
      _hasUndo = FALSE;     // Specify that there is no undo
      setQuestion ( DEFAULTWARNING );
  }
  
  void WarnNoUndoCmd::undoit()
  {
      // Empty
  } 
