///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>

void createForm ( Widget );

void main (int argc, char **argv)
{
    Widget       toplevel;
    XtAppContext app;
    Display     *dpy;
    
    // Initialize the Intrinsics
    
    XtToolkitInitialize();
    
    // Create an application context
    
    app = XtCreateApplicationContext();
    
    // Open a connection to the X server
    
    dpy = XtOpenDisplay(app, NULL, NULL, 
			"Form", 
			NULL, 0, 
			&argc, argv);
    
    // Create a toplevel shell
    
    toplevel = XtAppCreateShell(NULL, "Form", 
				applicationShellWidgetClass,
				dpy, NULL, 0);
    
    
    createForm( toplevel );
    
    // Realize all widgets and enter the main event loop
    
    XtRealizeWidget(toplevel);
    XtAppMainLoop(app);
    
}

void createForm ( Widget parent )
{
    
    // Create a form and four children

    Widget form, widgetA, widgetB, widgetC, widgetD;
    form = 	XtCreateManagedWidget ( "form", 
					xmFormWidgetClass,
					parent,  NULL, 0);
    widgetA = XtCreateManagedWidget 	( "widgetA", 
					  xmPushButtonWidgetClass, 
					  form, NULL, 0 );
    widgetB = XtCreateManagedWidget ( "widgetB",
				      xmPushButtonWidgetClass, 
				      form, NULL, 0 );
    widgetC = XtCreateManagedWidget ( "widgetC",
				      xmPushButtonWidgetClass, 
				      form, NULL, 0 );
    widgetD = XtCreateManagedWidget ( "widgetD",
				      xmPushButtonWidgetClass, 
				      form, NULL, 0 );
    
    // Attach widgetA to the left, top, and bottom of the form
    
    XtVaSetValues ( widgetA, XmNtopAttachment,    XmATTACH_FORM,
		    XmNbottomAttachment, XmATTACH_FORM,
		    XmNleftAttachment,   XmATTACH_FORM,
		    XmNrightAttachment,  XmATTACH_NONE,
		    NULL );
    
    // Attach widgetB to the top of the form, the right side of
    // widgetA, the top of widgetC, and the the left side of widgetD
    
    XtVaSetValues ( widgetB, XmNtopAttachment,    XmATTACH_FORM,
		    XmNbottomAttachment, XmATTACH_WIDGET,
		    XmNbottomWidget,     widgetC,
		    XmNleftAttachment,   XmATTACH_WIDGET,
		    XmNleftWidget,       widgetA,
		    XmNrightAttachment,  XmATTACH_WIDGET,
		    XmNrightWidget,      widgetD,
		    NULL );
    
    // Attach widgetC to the bottom of the form, the 
    // right side of widgetA, and the left side of widgetD
    
    XtVaSetValues ( widgetC, XmNtopAttachment,    XmATTACH_NONE,
		    XmNbottomAttachment, XmATTACH_FORM,
		    XmNleftAttachment,   XmATTACH_WIDGET,
		    XmNleftWidget,       widgetA,
		    XmNrightAttachment,  XmATTACH_WIDGET,
		    XmNrightWidget,      widgetD,
		    NULL );
    
    // Attach widgetD to the top, bottom, and right of the form
    
    XtVaSetValues ( widgetD, XmNtopAttachment,    XmATTACH_FORM,
		    XmNbottomAttachment, XmATTACH_FORM,
		    XmNrightAttachment,  XmATTACH_FORM,
		    XmNleftAttachment,   XmATTACH_NONE,
		    NULL );
}
