///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////
// pushme.C, Using callback functions in C++
////////////////////////////////////////////////////////
#include <stdlib.h>  // Needed for exit prototype
#include <Xm/Xm.h>
#include <Xm/PushB.h>

static void quitCallback ( Widget, XtPointer, XtPointer );

void main ( int argc, char **argv )
{
    Widget       button, shell;
    XtAppContext app;
    XmString     xmstr;
    
    // Initialize the Intrinsics
    
    shell = XtAppInitialize ( &app, "Pushme", NULL, 0, 
			      &argc, argv, NULL, NULL, 0 );
    
    // Create a compound string 
    
    xmstr = XmStringCreateLocalized ( "Push Me" );
    
    // Create an XmPushButton widget to display the string
    
    button = XtVaCreateManagedWidget ( "button",
				       xmPushButtonWidgetClass,
				       shell,
				       XmNlabelString, xmstr, 
				       NULL );
    
    // Free the compound string after the XmPushButton has copied it
    
    XmStringFree ( xmstr );
    
    // Register the quitCallback callback function
    // to be called when the button is pushed
    
    XtAddCallback ( button, 
		    XmNactivateCallback, 
		    quitCallback, 
		    NULL ); // No client data needed
    
    // Realize all widgets and enter the main event loop
    
    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );
}

 
 // Callback invoked when button is activated
 
 void quitCallback ( Widget, XtPointer, XtPointer )
 {
     exit ( 0 );
 } 
