///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////
// Control.h: A start/stop pair of buttons for the stopwatch program
//////////////////////////////////////////////////////////////////////
#ifndef CONTROL_H
#define CONTROL_H
#include "BasicComponent.h"

class Timer;
class Stopwatch;

class Control : public BasicComponent {
    
  public:
    
    Control ( const char *, Widget, Stopwatch *, Timer * );
    
  protected:
    
    Widget     _startWidget; // The start button
    Widget     _stopWidget;  // Stop button
    
    virtual void start( Widget, XtPointer );  // Called when the user 
                                              // hits the start button
    virtual void stop ( Widget, XtPointer );  // Called when the user
                                              // hits the stop button
  private:
    
    Timer     *_timer;       // The timer controlled by this class
    Stopwatch *_stopwatch;   // The stopwatch containing this control
    
    
    // Static member functions that interface member
    // functions with Motif widget callbacks
    
    static void startCallback ( Widget, XtPointer, XtPointer );
    static void stopCallback ( Widget, XtPointer, XtPointer );
};
#endif
