///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////
// Control.C: A start/stop pair of buttons for the stopwatch program
/////////////////////////////////////////////////////////////////////
#include "Control.h"
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include "Timer.h"
#include "Stopwatch.h"

Control::Control ( Widget     parent, 
		  char      *name, 
		  Stopwatch *stopwatch,
		  Timer     *timer ) :  BasicComponent ( name )
{
    
    _timer     = timer;     // Keep a pointer to the timer.
    _stopwatch = stopwatch; // Remember stopwatch
    
    // Create the component's widget tree
    
    _w = XmCreateRowColumn ( parent, _name, NULL, 0 );
    
    _startWidget = XtCreateManagedWidget ( "start",
					  xmPushButtonWidgetClass, 
					  _w,  NULL, 0 );
    _stopWidget = XtCreateManagedWidget ( "stop", 
					 xmPushButtonWidgetClass, 
					 _w, NULL, 0 );
    
    // Register callbacks, specifying the object's instance 
    // pointer as client data.
    
    XtAddCallback ( _startWidget, 
		   XmNactivateCallback, 
		   &Control::startCallback,
		   (XtPointer) this );
    
    XtAddCallback ( _stopWidget, 
		   XmNactivateCallback, 
		   &Control::stopCallback,
		   (XtPointer) this );
}

void Control::startCallback ( Widget, XtPointer clientData, XtPointer )
{
    Control *obj = (Control *) clientData;
    
    obj->start();
}

void Control::start()
{
    _timer->start();
    _stopwatch->timerStarted();
}

void Control::stopCallback ( Widget, XtPointer clientData, XtPointer )
{    
    Control *obj = (Control *) clientData;
    
    obj->stop();
}

void Control::stop()
{
    _timer->stop();
    _stopwatch->timerStopped();
}
