///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////
// Timer.C: A clock class for the stopwatch
//////////////////////////////////////////////////
#include "Timer.h"
#include "Face.h"
#include <Xm/Xm.h>

Timer::Timer ( XtAppContext app, Face *face, int interval )
{
    _face     = face;
    _id       = NULL;
    _app      = app;
    _counter  = 0;
    _interval = interval;
}

void Timer::start()
{
    // Reset the elapsed time
    _counter = 0;
    
    stop(); // Remove any pending timeout
    
    // Register a function to be called in _interval milliseconds
    
    _id = XtAppAddTimeOut ( _app, _interval, 
			    &Timer::tickCallback, ( XtPointer ) this );
    
}

void Timer::stop()
{
    // Remove the current timeout function, if any
    
    if ( _id )
	XtRemoveTimeOut ( _id );
    _id = NULL;
}

void Timer::tickCallback ( XtPointer clientData, XtIntervalId * )
{
    // Get the object pointer and call the corresponding tick function
    
    Timer *obj = ( Timer * ) clientData;
    obj->tick();
}

void Timer::tick()
{
    // Increment a counter for each tick
    
    _counter++;  
    
    // Display the current time in the Face object
    
    _face->setTime (  elapsedTime() );
    
    // Reinstall the timeout callback
    
    _id = XtAppAddTimeOut ( _app, _interval, 
			    &Timer::tickCallback, ( XtPointer ) this );
}

float Timer::elapsedTime()
{
    return ( ( float ) _counter * _interval / 1000.0 );
}
