///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////
// Timer.h: A generic clock class, abstract
//          version with pure virtual reportTime
///////////////////////////////////////////////////////
#ifndef TIMER_H
#define TIMER_H

#include <Xm/Xm.h>

class Timer {
    
  private:
    
    // Static member function used for TimeOut callback
    
    static void tickCallback ( XtPointer, XtIntervalId* );
    
    void tick();  // Called every _interval milliseconds
    
    int   _counter;    // Current number of ticks
    int   _interval;   // Time in milliseconds between updates
    XtIntervalId _id;  // Identifier of current TimeOut
    XtAppContext _app; // Required by Xt functions
    
  protected:
    
    // Called at each clock tick. Derived classes must override. 
    
    virtual void reportTime ( float ) = 0;
    
  public:
    
    Timer ( XtAppContext, int );
    
    void start();        // Resets, and starts the clock ticking
    void stop();         // Stops the clock
    float elapsedTime(); // Returns time since timer started
};
#endif
