///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////
// Timer.h: A generic clock class, "callback" version
//////////////////////////////////////////////////////
#ifndef TIMER_H
#define TIMER_H

#include <Xm/Xm.h>

typedef void (*TimerCallback)( float, void * );

class Timer {
    
  private:
    
    // Static member function used for TimeOut callback
    
    static void tickCallback ( XtPointer, XtIntervalId* );
    
    void tick();  // Called every _interval milliseconds
    
    TimerCallback _func;
    void         *_data;
    int   _counter;    // Current number of ticks
    int   _interval;   // Time in miliseconds between updates
    XtIntervalId _id;  // Identifier of current TimeOut
    XtAppContext _app; // Required by Xt functions
    
  public:
    
    Timer ( XtAppContext, TimerCallback, int interval, void *data );
    
    void start();        // Resets, and starts the clock ticking
    void stop();         // Stops the clock
    float elapsedTime(); // Returns time since timer started    
};
#endif
